package com.xforceplus.phoenix.split.service.impl;

import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.model.*;
import com.xforceplus.phoenix.split.service.PreInvoiceGenerateService;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPluginFactory;
import com.xforceplus.phoenix.split.service.dataflow.impl.SplitBillItemPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * 从单据创建预制发票
 */
@Service
public class Bill2PreInvoiceService {

    private static final Logger logger = LoggerFactory.getLogger(Bill2PreInvoiceService.class);

    @Autowired
    private PreInvoiceGenerateService preInvoiceGenerateService;

    @Autowired
    private DataProcessPluginFactory dataProcessPluginFactory;

    /**
     * 根据给定的单据创建预制发票
     *
     * @param billInfo 单据信息
     * @param rule     规则
     * @return 预制发票信息
     */
    public List<SplitPreInvoiceInfo> createPreInvoiceFromBill(BillInfo billInfo, SplitRule rule, String ruleCode) {
        setPriceMethod(billInfo, rule);

        List<ItemGroup> itemGroupList = new ArrayList<>(1);
        ItemGroup itemGroup = new ItemGroup();
        itemGroup.setBillItems(billInfo.getBillItems());
        itemGroupList.add(itemGroup);

        RuleInfo ruleInfo = createRuleInfo(billInfo, rule);
        List<DataProcessPlugin> dataProcessPlugins = dataProcessPluginFactory.getPluginByCode(ruleCode);
        for (DataProcessPlugin dataProcessPlugin : dataProcessPlugins) {
            itemGroupList = dataProcessPlugin.processData(itemGroupList,billInfo, ruleInfo);
        }

        logger.debug("group data = {}", itemGroupList);

        //3.处理每一组明细数据生成预制发票

        List<SplitPreInvoiceInfo> preInvoiceInfoList = new LinkedList<>();

        for (ItemGroup itemData : itemGroupList) {
            List<BillItem> billItems = itemData.getBillItems();
            billInfo.setBillItems(billItems);
            preInvoiceInfoList.addAll(preInvoiceGenerateService.createPreInvoice(billInfo, rule));
        }
        logger.debug("Bill2PreInvoiceService.createPreInvoiceFromBill, result = {}", preInvoiceInfoList);
        return preInvoiceInfoList;
    }

    private RuleInfo createRuleInfo(BillInfo billInfo, SplitRule rule) {
        RuleInfo ruleInfo = new RuleInfo();
        ruleInfo.setSplitRule(rule);
        if (rule.getUnitPriceScale() == null) {
            rule.setUnitPriceScale(15);
        }
        Map<String, Object> extRule = new HashMap<>();
        extRule.put(SplitBillItemPlugin.ORIGIN_INVOICE_CODE, billInfo.getOriginInvoiceCode());
        extRule.put(SplitBillItemPlugin.ORIGIN_INVOICE_NO, billInfo.getOriginInvoiceNo());
        extRule.put(SplitBillItemPlugin.RED_NOTIFICATION_NO, billInfo.getRedNotificationNo());
        ruleInfo.setExtRule(extRule);
        return ruleInfo;
    }


    private void setPriceMethod(BillInfo billInfo, SplitRule rule) {
        rule.setPriceMethod(PriceMethod.value(billInfo.getPriceMethod()));
        rule.setInvoiceType(billInfo.getInvoiceType());
    }


}
