/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.constant;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public enum InvoiceType {
    NORMAL("c", "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968"),
    SPECIAL("s", "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968"),
    SE("se", "\u4e13\u7535\u7968\u79cd"),
    VEHICLE("v", "\u673a\u52a8\u8f66\u9500\u552e\u53d1\u7968"),
    UNIVERSAL("t", "\u901a\u7528\u673a\u6253\u53d1\u7968"),
    ELECTRONIC("ce", "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968"),
    NORMAL_ROLL("ju", " \u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968(\u5377\u7968)");

    private final String type;
    private final String desc;

    private InvoiceType(String type, String description) {
        this.type = type;
        this.desc = description;
    }

    public String value() {
        return this.type;
    }

    public static InvoiceType fromValue(String value) throws RuntimeException {
        return Stream.of(InvoiceType.values()).filter(t -> t.value().equals(value)).findFirst().orElseThrow(() -> new RuntimeException("\u4e0d\u5b58\u5728\u5bf9\u5e94\u7c7b\u578b\u7684\u7968"));
    }

    public boolean isNormal() {
        return this.equals((Object)NORMAL) || this.equals((Object)ELECTRONIC) || this.equals((Object)NORMAL_ROLL);
    }

    public boolean isSpecial() {
        return this.equals((Object)SPECIAL);
    }

    public static List<String> special() {
        return Arrays.asList(SPECIAL.value());
    }
}

