/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service;

import com.google.common.collect.ImmutableSet;
import com.xforceplus.phoenix.split.constant.InvoiceItemOrder;
import com.xforceplus.phoenix.split.constant.InvoiceType;
import com.xforceplus.phoenix.split.constant.PreInvoiceTemplateVersionStatus;
import com.xforceplus.phoenix.split.domain.SplitGroupLimit;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.exception.SplitRuleParamException;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.PreInvoiceGenerateService;
import java.util.Objects;

public class SplitRuleUtil {
    private static final int ELECTRONIC_SALES_LIST_MAX_ROW = 99;
    private static final int SALES_LIST_MAX_ROW = 2000;

    public static SplitGroupLimit createSplitGroupLimit(SplitRule rule, String goodsTaxNo) {
        SplitGroupLimit splitGroupLimit = new SplitGroupLimit();
        splitGroupLimit.setLimitIsAmountWithTax(rule.isLimitIsAmountWithTax());
        splitGroupLimit.setLimitAmount(rule.getInvoiceLimit());
        splitGroupLimit.setInvoiceItemOrder(InvoiceItemOrder.fromValue(rule.getItemSort()));
        splitGroupLimit.setLimitLine(SplitRuleUtil.getLimitLine(rule, !PreInvoiceGenerateService.HBBM_SET.contains(goodsTaxNo)));
        return splitGroupLimit;
    }

    static int getLimitLine(SplitRule rule, boolean isCreateSalesList) {
        if (!isCreateSalesList) {
            return rule.getInvoiceItemMaxRow();
        }
        if ("0".equals(rule.getSaleListOption())) {
            return rule.getInvoiceItemMaxRow();
        }
        if ("1".equals(rule.getSaleListOption())) {
            return Math.max(SplitRuleUtil.getSalesListMaxRow(rule), rule.getInvoiceItemMaxRow());
        }
        if ("2".equals(rule.getSaleListOption())) {
            return SplitRuleUtil.getSalesListMaxRow(rule);
        }
        throw new SplitBizException(String.format("value = [%s] for saleListOption is illegal", rule.getSaleListOption()));
    }

    public static void validateSaleListOption(SplitRule rule) {
        if (!ImmutableSet.of((Object)"0", (Object)"1", (Object)"2").contains((Object)rule.getSaleListOption())) {
            throw new SplitRuleParamException("\u9500\u8d27\u6e05\u5355\u53c2\u6570\u53ea\u80fd\u4e3a\uff1a0-\u4e0d\u542f\u52a8\u9500\u8d27\u6e05\u5355,1-\u542f\u52a8\u9500\u8d27\u6e05\u5355,2-\u5f3a\u5236\u542f\u7528\u9500\u8d27\u6e05\u5355");
        }
    }

    public static void validateInvoiceItemMaxRow(SplitRule rule) {
        Integer invoiceItemMaxRow = rule.getInvoiceItemMaxRow();
        if (invoiceItemMaxRow == null) {
            throw new SplitRuleParamException("\u53d1\u7968\u660e\u7ec6\u6700\u5927\u884c\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (invoiceItemMaxRow < 1) {
            throw new SplitRuleParamException("\u53d1\u7968\u660e\u7ec6\u6700\u5927\u884c\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
        if (InvoiceType.ELECTRONIC.value().equals(rule.getInvoiceType())) {
            if (invoiceItemMaxRow > PreInvoiceTemplateVersionStatus.EIGHT.getValue()) {
                throw new SplitRuleParamException("\u7535\u7968\u660e\u7ec6\u6700\u5927\u884c\u6570\u4e0d\u80fd\u8d85\u8fc78");
            }
        } else if (invoiceItemMaxRow > PreInvoiceTemplateVersionStatus.EIGHT.getValue()) {
            throw new SplitRuleParamException("\u53d1\u7968\u660e\u7ec6\u6700\u5927\u884c\u6570\u4e0d\u80fd\u8d85\u8fc78");
        }
    }

    public static void validateSalesListMaxRow(SplitRule rule) {
        if ("0".equals(rule.getSaleListOption())) {
            return;
        }
        Integer salesListMaxRow = rule.getSalesListMaxRow();
        if (salesListMaxRow == null) {
            throw new SplitRuleParamException("\u542f\u7528\u9500\u8d27\u6e05\u65f6,\u5355\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (salesListMaxRow < 1) {
            throw new SplitRuleParamException("\u542f\u7528\u9500\u8d27\u6e05\u65f6,\uff0c\u9500\u8d27\u6e05\u5355\u6700\u5927\u884c\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
    }

    public static int getSalesListMaxRow(SplitRule rule) {
        if ("0".equals(rule.getSaleListOption())) {
            return 0;
        }
        Integer salesListMaxRow = rule.getSalesListMaxRow();
        if (InvoiceType.ELECTRONIC.value().equals(rule.getInvoiceType()) && salesListMaxRow > 99) {
            salesListMaxRow = 99;
        } else if (salesListMaxRow > 2000) {
            salesListMaxRow = 2000;
        }
        return salesListMaxRow;
    }

    public static void validateUnitPriceAmountOps(SplitRule rule) {
        try {
            Byte.valueOf(rule.getUnitPriceAmountOps());
        }
        catch (Exception e) {
            throw new SplitRuleParamException("\u6253\u5370\u5355\u4ef7\u6570\u91cf\u89c4\u5219\u6709\u8bef");
        }
    }

    public static void validateCustomRemarkSize(SplitRule rule) {
        if (Objects.nonNull(rule.getCustomRemarkSize()) && rule.getCustomRemarkSize() < 0) {
            throw new SplitRuleParamException("\u81ea\u5b9a\u4e49\u5907\u6ce8\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e0");
        }
    }

    public static void validateSplitRule(SplitRule rule) {
        SplitRuleUtil.validateSaleListOption(rule);
        SplitRuleUtil.validateInvoiceItemMaxRow(rule);
        SplitRuleUtil.validateSalesListMaxRow(rule);
        SplitRuleUtil.validateUnitPriceAmountOps(rule);
    }
}

