/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow;

import com.xforceplus.phoenix.split.config.DataProcessPluginConfig;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DataProcessPluginFactory {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DataProcessPluginConfig dataProcessPluginConfig;
    private Map<String, List<DataProcessPlugin>> cache = new ConcurrentHashMap<String, List<DataProcessPlugin>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataProcessPlugin> getPluginByCode(String ruleCode) {
        if (this.cache.get(ruleCode) != null) {
            return this.cache.get(ruleCode);
        }
        Class<DataProcessPlugin> clazz = DataProcessPlugin.class;
        synchronized (DataProcessPlugin.class) {
            if (this.cache.get(ruleCode) == null) {
                List<String> dataProcessPluginBeanNames = this.dataProcessPluginConfig.getBeanNamesByRuleCode(ruleCode);
                if (CollectionUtils.isEmpty(dataProcessPluginBeanNames)) {
                    throw new IllegalStateException("data process plugins bean name not config!");
                }
                ArrayList<Object> dataProcessPlugins = new ArrayList<Object>(dataProcessPluginBeanNames.size());
                for (String beanName : dataProcessPluginBeanNames) {
                    dataProcessPlugins.add(this.applicationContext.getBean(beanName, DataProcessPlugin.class));
                }
                this.cache.put(ruleCode, dataProcessPlugins);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.cache.get(ruleCode);
        }
    }
}

