/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.google.common.collect.Lists;
import com.xforceplus.phoenix.split.constant.InvoiceItemOrder;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.domain.SplitGroupLimit;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.exception.SplitRuleParamException;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.SplitRuleUtil;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import com.xforceplus.phoenix.split.service.impl.DefaultSplitBillItemAmountServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceLimitProcessPlugin
implements DataProcessPlugin {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceLimitProcessPlugin.class);

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo rule) {
        SplitRuleUtil.validateSplitRule(rule.getSplitRule());
        LinkedList allItemGroups = Lists.newLinkedList();
        for (ItemGroup itemGroup : itemGroups) {
            String invoiceOfGroupKey = UUID.randomUUID().toString();
            for (BillItem billItem : itemGroup.getBillItems()) {
                if (billItem.isSplitItem()) continue;
                billItem.setAmountWithoutTax(billItem.getAmountWithoutTax().subtract(billItem.getInnerDiscountWithoutTax()).subtract(billItem.getInnerPrepayAmountWithoutTax()));
                if (billItem.getInnerDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0 || billItem.getInnerPrepayAmountWithoutTax().compareTo(BigDecimal.ZERO) > 0) {
                    this.processPriceOrQuantity(billItem, rule);
                }
                billItem.setAmountWithTax(billItem.getAmountWithTax().subtract(billItem.getInnerDiscountWithTax()).subtract(billItem.getInnerPrepayAmountWithTax()));
                billItem.setTaxAmount(billItem.getTaxAmount().subtract(billItem.getInnerPrepayAmountTax()).subtract(billItem.getInnerDiscountTax()));
                billItem.setDiscountWithoutTax(billItem.getOutterDiscountWithoutTax().add(billItem.getOutterPrepayAmountWithoutTax()));
                billItem.setDiscountWithTax(billItem.getOutterDiscountWithTax().add(billItem.getOutterPrepayAmountWithTax()));
                billItem.setDiscountTax(billItem.getOutterDiscountTax().add(billItem.getOutterPrepayAmountTax()));
            }
            String goodsTaxNo = itemGroup.getBillItems().get(0).getGoodsTaxNo();
            SplitGroupLimit splitGroupLimit = SplitRuleUtil.createSplitGroupLimit(rule.getSplitRule(), goodsTaxNo);
            if (InvoiceItemOrder.ITEM_NO_ORDER.value().equals(rule.getSplitRule().getItemSort())) {
                splitGroupLimit.setInvoiceItemOrder(InvoiceItemOrder.ITEM_NO_ORDER);
                allItemGroups.addAll(this.orderSplitItemGroup(itemGroup, splitGroupLimit, invoiceOfGroupKey));
                continue;
            }
            if (InvoiceItemOrder.MINIMUM_INVOICES.value().equals(rule.getSplitRule().getItemSort())) {
                splitGroupLimit.setInvoiceItemOrder(InvoiceItemOrder.MINIMUM_INVOICES);
                allItemGroups.addAll(this.leastSplitItemGroup(itemGroup, splitGroupLimit, invoiceOfGroupKey));
                continue;
            }
            throw new SplitRuleParamException("\u53d1\u7968\u660e\u7ec6\u987a\u5e8f\u89c4\u5219\u6709\u8bef");
        }
        return allItemGroups;
    }

    private void processPriceOrQuantity(BillItem billItem, RuleInfo rule) {
        int unitPriceScale = rule.getSplitRule().getUnitPriceScale();
        BigDecimal amount = null;
        if (DefaultSplitBillItemAmountServiceImpl.isQuantity(rule.getSplitRule().getAmountSplitRule())) {
            if (billItem.getQuantity() != null && billItem.getQuantity().compareTo(BigDecimal.ZERO) > 0) {
                billItem.setUnitPrice(billItem.getAmountWithoutTax().divide(billItem.getQuantity(), unitPriceScale, 4));
                amount = billItem.getUnitPrice().multiply(billItem.getQuantity()).setScale(2, 4);
            }
        } else if (billItem.getUnitPrice() != null && billItem.getUnitPrice().compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal quantity = billItem.getAmountWithoutTax().divide(billItem.getUnitPrice(), 6, 4);
            if (quantity.compareTo(BigDecimal.ZERO) == 0) {
                quantity = DefaultSplitBillItemAmountServiceImpl.MIN_QUANTITY;
            }
            if (quantity.multiply(billItem.getUnitPrice()).setScale(2, 4).compareTo(billItem.getAmountWithoutTax()) != 0) {
                billItem.setUnitPrice(billItem.getAmountWithoutTax().divide(quantity, unitPriceScale, 4));
            }
            billItem.setQuantity(quantity);
            amount = billItem.getUnitPrice().multiply(billItem.getQuantity()).setScale(2, 4);
        }
        if (amount != null && amount.subtract(billItem.getAmountWithoutTax()).abs().compareTo(new BigDecimal("0.01")) > 0) {
            throw new SplitBizException(String.format("\u65e0\u6cd5\u8ba1\u7b97\u660e\u7ec6id = [%s] \u7684\u5355\u4ef7\u4ee5\u53ca\u6570\u91cf, \u8bef\u5dee\u8d85\u8fc7\u4e00\u5206", billItem.getSalesbillItemId()));
        }
    }

    private List<ItemGroup> orderSplitItemGroup(ItemGroup itemGroup, SplitGroupLimit splitGroupLimit, String invoiceOfGroupKey) {
        LinkedList processedItemGroups = Lists.newLinkedList();
        logger.debug("itemGroup.getBillItems size:{}", (Object)itemGroup.getBillItems().size());
        while (itemGroup.getBillItems().size() > 0) {
            List<BillItem> processedItemList = this.splitByAmountAndLineLimit(itemGroup.getBillItems(), splitGroupLimit);
            if (processedItemList.size() == 0) {
                throw new SplitBizException("\u62c6\u7968\u8bf7\u6c42\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u4ef7\u5185\u5916\u6298\u6263\u4ee5\u53ca\u7a0e\u989d\u662f\u5426\u6b63\u786e");
            }
            ItemGroup processedItemGroup = new ItemGroup(itemGroup.getParentGroupFlag());
            processedItemGroup.setInvoiceOfGroupKey(invoiceOfGroupKey);
            processedItemGroup.setBillItems(processedItemList);
            processedItemGroups.add(processedItemGroup);
        }
        return processedItemGroups;
    }

    private List<ItemGroup> leastSplitItemGroup(ItemGroup itemGroup, SplitGroupLimit splitGroupLimit, String invoiceOfGroupKey) {
        LinkedList allItemGroups = Lists.newLinkedList();
        List<BillItem> billItems = itemGroup.getBillItems();
        Map<Boolean, List<BillItem>> isSplitItemMap = billItems.stream().collect(Collectors.groupingBy(BillItem::isSplitItem));
        List<Object> processItems = new LinkedList<BillItem>();
        List<BillItem> isNotSplitBillItems = isSplitItemMap.get(false);
        if (!CollectionUtils.isEmpty(isNotSplitBillItems)) {
            processItems.addAll(isNotSplitBillItems);
        }
        List<BillItem> isSplitBillItems = isSplitItemMap.get(true);
        LinkedList noNeedProcessItems = Lists.newLinkedList();
        if (!CollectionUtils.isEmpty(isSplitBillItems)) {
            Map<String, List<BillItem>> billIdItemsMap = isSplitBillItems.stream().collect(Collectors.groupingBy(BillItem::getSalesbillItemId));
            for (Map.Entry<String, List<BillItem>> entry : billIdItemsMap.entrySet()) {
                List<BillItem> items = entry.getValue();
                BillItem item = items.get(items.size() - 1);
                items.remove(item);
                processItems.add(item);
                noNeedProcessItems.addAll(items);
            }
            for (BillItem billItem : noNeedProcessItems) {
                ItemGroup notNeedProcessItemGroup = new ItemGroup(itemGroup.getParentGroupFlag());
                notNeedProcessItemGroup.setInvoiceOfGroupKey(invoiceOfGroupKey);
                notNeedProcessItemGroup.setBillItems(Lists.newArrayList((Object[])new BillItem[]{billItem}));
                allItemGroups.add(notNeedProcessItemGroup);
            }
        }
        if (!CollectionUtils.isEmpty(processItems)) {
            processItems = processItems.stream().sorted(((Comparator)(o1, o2) -> {
                BigDecimal value1 = this.actualAmount((BillItem)o1, splitGroupLimit.isLimitIsAmountWithTax());
                BigDecimal value2 = this.actualAmount((BillItem)o2, splitGroupLimit.isLimitIsAmountWithTax());
                return value1.compareTo(value2);
            }).reversed()).collect(Collectors.toList());
            logger.debug("itemGroup.processItems size:{}", (Object)processItems.size());
            List<List<BillItem>> invoices = this.minInvoice(processItems, splitGroupLimit);
            for (List list : invoices) {
                ItemGroup newItemGroup = new ItemGroup(itemGroup.getParentGroupFlag());
                newItemGroup.setInvoiceOfGroupKey(invoiceOfGroupKey);
                newItemGroup.setBillItems(list);
                allItemGroups.add(newItemGroup);
            }
        }
        return allItemGroups;
    }

    protected List<List<BillItem>> minInvoice(List<BillItem> processItems, SplitGroupLimit splitGroupLimit) {
        ArrayList<List<BillItem>> result = new ArrayList<List<BillItem>>();
        while (processItems.size() > 0) {
            List<BillItem> processedItemList = this.splitByAmountAndLineLimit(processItems, splitGroupLimit);
            if (processedItemList.size() == 0) {
                throw new SplitBizException("\u62c6\u7968\u8bf7\u6c42\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u4ef7\u5185\u5916\u6298\u6263\u4ee5\u53ca\u7a0e\u989d\u662f\u5426\u6b63\u786e");
            }
            result.add(processedItemList);
        }
        return result;
    }

    private BigDecimal actualAmount(BillItem item, boolean limitIsAmountWithTax) {
        BigDecimal result = limitIsAmountWithTax ? item.getAmountWithTax().subtract(item.getDiscountWithTax()) : item.getAmountWithoutTax().subtract(item.getDiscountWithoutTax());
        return result;
    }

    private double actualAmountDoubleValue(BillItem item, boolean limitIsAmountWithTax) {
        return this.actualAmount(item, limitIsAmountWithTax).doubleValue();
    }

    protected List<BillItem> splitByAmountAndLineLimit(List<BillItem> billItems, SplitGroupLimit splitGroupLimit) {
        logger.debug("splitByAmountAndLineLimit billItems.size:{}", (Object)billItems.size());
        BigDecimal amount = BigDecimal.valueOf(0L);
        int lineNum = 0;
        BigDecimal sum1 = BigDecimal.valueOf(0L);
        BigDecimal sum2 = BigDecimal.valueOf(0L);
        LinkedList splitGroup = Lists.newLinkedList();
        BigDecimal totalErrorAmount = BigDecimal.ZERO;
        Iterator<BillItem> it = billItems.iterator();
        while (it.hasNext()) {
            boolean rateFor1dot27;
            BillItem item = it.next();
            if (item.getDeductions().compareTo(BigDecimal.ZERO) > 0) {
                if (splitGroup.size() > 0) continue;
                splitGroup.add(item);
                it.remove();
                return splitGroup;
            }
            boolean isAmountGtLimit = amount.add(this.actualAmount(item, splitGroupLimit.isLimitIsAmountWithTax())).compareTo(splitGroupLimit.getLimitAmount()) > 0;
            boolean isLineGtLimit = lineNum + this.needLineNum(item) > splitGroupLimit.getLimitLine();
            BigDecimal currentItemErrorAmount = item.getTaxAmount().subtract(item.getDiscountTax()).subtract(item.getAmountWithoutTax().subtract(item.getDiscountWithoutTax()).multiply(item.getTaxRate())).abs();
            boolean bl = rateFor1dot27 = totalErrorAmount.add(currentItemErrorAmount).compareTo(BigDecimal.valueOf(1.27)) > 0;
            if (isLineGtLimit || rateFor1dot27) {
                return splitGroup;
            }
            if (!isAmountGtLimit) {
                amount = amount.add(this.actualAmount(item, splitGroupLimit.isLimitIsAmountWithTax()));
                lineNum += this.needLineNum(item);
                totalErrorAmount = totalErrorAmount.add(currentItemErrorAmount);
                splitGroup.add(item);
                it.remove();
                continue;
            }
            if (splitGroupLimit.getInvoiceItemOrder() != InvoiceItemOrder.ITEM_NO_ORDER) continue;
            return splitGroup;
        }
        return splitGroup;
    }

    private int getLimitLine(SplitRule rule, boolean isCreateSalesList) {
        if (!isCreateSalesList) {
            return rule.getInvoiceItemMaxRow();
        }
        if ("0".equals(rule.getSaleListOption())) {
            return rule.getInvoiceItemMaxRow();
        }
        if ("1".equals(rule.getSaleListOption())) {
            return Math.max(SplitRuleUtil.getSalesListMaxRow(rule), rule.getInvoiceItemMaxRow());
        }
        if ("2".equals(rule.getSaleListOption())) {
            return SplitRuleUtil.getSalesListMaxRow(rule);
        }
        return 0;
    }

    private int needLineNum(BillItem item) {
        if (item.getDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0 && (item.getOutterDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0 || item.getOutterPrepayAmountWithoutTax().compareTo(BigDecimal.ZERO) > 0)) {
            return 2;
        }
        return 1;
    }
}

