/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.domain.SplitGroupLimit;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.service.dataflow.MinInvoiceService;
import com.xforceplus.phoenix.split.service.dataflow.impl.InvoiceLimitProcessPlugin;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class LBInvoiceLimitProcessPlugin
extends InvoiceLimitProcessPlugin {
    @Value(value="${enable.minInvoice.maxSize:20}")
    private int maxItemSize;

    @Override
    protected List<List<BillItem>> minInvoice(List<BillItem> processItems, SplitGroupLimit splitGroupLimit) {
        if (processItems.size() > this.maxItemSize) {
            return super.minInvoice(processItems, splitGroupLimit);
        }
        MinInvoiceService minInvoiceService = new MinInvoiceService(splitGroupLimit);
        return minInvoiceService.createMinInvoice(processItems);
    }
}

