package com.xforceplus.phoenix.split.constant;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

/**
 * @author YY
 *
 */
public enum InvoiceType
{
    NORMAL("c", "增值税普通发票"),
    SPECIAL("s","增值税专用发票"),
    SE("se","专电票种"),
    VEHICLE("v", "机动车销售发票"),
    UNIVERSAL("t", "通用机打发票"),
    ELECTRONIC("ce", "增值税电子普通发票"),
    NORMAL_ROLL("ju"," 增值税普通发票(卷票)");


    private final String type;
    private final String desc;

    InvoiceType(String type, String description)
    {
        this.type = type;
        this.desc = description;
    }

    public String value()
    {
        return  this.type;
    }

    public static InvoiceType fromValue(String value) throws RuntimeException{
        return Stream.of(InvoiceType.values())
                .filter(t -> t.value().equals(value))
                .findFirst().orElseThrow(() -> new RuntimeException("不存在对应类型的票"));
    }

    public boolean isNormal(){
        return this.equals(NORMAL) || this.equals(ELECTRONIC) ||this.equals(NORMAL_ROLL);
    }

    public boolean isSpecial(){
        return this.equals(SPECIAL);
    }

    public static List<String> special(){
        return Arrays.asList(SPECIAL.value());
    }
}
