package com.xforceplus.phoenix.split.service;

import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.util.CommonTools;
import org.apache.commons.lang3.StringUtils;

import java.nio.charset.Charset;

/**
 * 备注service
 **/
public interface RemarkService {

    /**
     * @param billInfo 发票信息
     * @param rule                拆票规则
     * @return 备注
     */
    String splice(BillInfo billInfo, SplitRule rule);

    /**
     * 字符串指定长度截取
     *
     * @param remark 备注
     * @param limit  长度限制
     * @return 截取后字符串
     */
    static String toLegalRemark(String remark, int limit) {
        if (StringUtils.isEmpty(remark)) {
            return remark;
        }
        String temp = StringUtils.trimToEmpty(remark);
        return CommonTools.substring(temp,limit,Charset.forName("GBK"));
    }


}