package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.domain.SplitGroupLimit;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.service.dataflow.MinInvoiceService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 立邦最少发票生成算法
 * <p>
 * 如果明细超过指定数量，则使用父类最少张数算法生成
 * 如果小于指定数量，最通过回溯算法生成最少张数
 */
@Service
public class LBInvoiceLimitProcessPlugin extends InvoiceLimitProcessPlugin {

    @Value("${enable.minInvoice.maxSize:20}")
    private int maxItemSize;


    @Override
    protected List<List<BillItem>> minInvoice(List<BillItem> processItems, SplitGroupLimit splitGroupLimit) {
        if (processItems.size() > maxItemSize) {
            return super.minInvoice(processItems, splitGroupLimit);
        }


        MinInvoiceService minInvoiceService = new MinInvoiceService(splitGroupLimit);

        return minInvoiceService.createMinInvoice(processItems);
    }
}
