/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.dataflow.impl.GroupItemBySplitFieldPlugin;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Service;

@Service
public class LBGroupItemBySplitFieldPlugin
extends GroupItemBySplitFieldPlugin {
    @Override
    protected List<ItemGroup> groupBillItem(List<ItemGroup> itemGroups, SplitRule rule) {
        LinkedList<ItemGroup> result = new LinkedList<ItemGroup>();
        for (ItemGroup itemGroup : itemGroups) {
            String uuid = UUID.randomUUID().toString();
            List<BillItem> billItems = itemGroup.getBillItems();
            ListMultimap group = MultimapBuilder.linkedHashKeys().linkedListValues().build();
            billItems.forEach(billItem -> {
                String key = this.generateKey((BillItem)billItem, rule);
                group.put((Object)key, billItem);
            });
            group.keySet().forEach(key -> {
                ItemGroup newItemGroup = new ItemGroup(uuid);
                newItemGroup.setBillItems(group.get(key));
                result.add(newItemGroup);
            });
        }
        return result;
    }
}

