/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.domain.SplitGroupLimit;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.service.SplitRuleUtil;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import com.xforceplus.phoenix.split.service.dataflow.MinInvoiceService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class MergeBySplitFieldPlugin
implements DataProcessPlugin {
    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo) {
        if (!ruleInfo.getSplitRule().isMergeBySplitFiled()) {
            return itemGroups;
        }
        LinkedList result = Lists.newLinkedList();
        HashMap<String, Multimap> temp = new HashMap<String, Multimap>();
        for (ItemGroup itemGroup : itemGroups) {
            String parentGroupFlag = itemGroup.getParentGroupFlag();
            String invoiceOfGroupKey = itemGroup.getInvoiceOfGroupKey();
            Multimap invoices = (Multimap)temp.get(parentGroupFlag);
            if (invoices == null) {
                invoices = MultimapBuilder.linkedHashKeys().linkedListValues().build();
                temp.put(parentGroupFlag, invoices);
            }
            invoices.put((Object)invoiceOfGroupKey, (Object)itemGroup);
        }
        for (Map.Entry entry : temp.entrySet()) {
            Multimap invoices = (Multimap)entry.getValue();
            result.addAll(this.merge((Multimap<String, ItemGroup>)invoices, ruleInfo));
        }
        return result;
    }

    private List<ItemGroup> merge(Multimap<String, ItemGroup> invoices, RuleInfo ruleInfo) {
        LinkedList result = Lists.newLinkedList();
        List<ItemGroup> toBeProcessItemGroup = new ArrayList<ItemGroup>();
        for (String key : invoices.keySet()) {
            if (invoices.get((Object)key).size() > 1) {
                result.addAll(invoices.get((Object)key));
                continue;
            }
            toBeProcessItemGroup.addAll(invoices.get((Object)key));
        }
        if (toBeProcessItemGroup.size() > 1) {
            toBeProcessItemGroup = this.mergerInvoice(toBeProcessItemGroup, ruleInfo);
        }
        result.addAll(toBeProcessItemGroup);
        return result;
    }

    private List<ItemGroup> mergerInvoice(List<ItemGroup> toBeProcessItemGroup, RuleInfo ruleInfo) {
        SplitGroupLimit splitGroupLimit = SplitRuleUtil.createSplitGroupLimit(ruleInfo.getSplitRule(), toBeProcessItemGroup.get(0).getBillItems().get(0).getGoodsTaxNo());
        MinInvoiceService minInvoiceService = new MinInvoiceService(splitGroupLimit);
        List<List<BillItem>> invoices = minInvoiceService.minMergeInvoices(toBeProcessItemGroup);
        LinkedList result = Lists.newLinkedList();
        invoices.forEach(invoice -> {
            ItemGroup itemGroup = new ItemGroup();
            itemGroup.setBillItems((List<BillItem>)invoice);
            result.add(itemGroup);
        });
        return result;
    }
}

