/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.impl;

import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.PriceMethod;
import com.xforceplus.phoenix.split.model.SplitPreInvoiceInfo;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.PreInvoiceGenerateService;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPluginFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Bill2PreInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(Bill2PreInvoiceService.class);
    @Autowired
    private PreInvoiceGenerateService preInvoiceGenerateService;
    @Autowired
    private DataProcessPluginFactory dataProcessPluginFactory;

    public List<SplitPreInvoiceInfo> createPreInvoiceFromBill(BillInfo billInfo, SplitRule rule, String ruleCode) {
        this.setPriceMethod(billInfo, rule);
        List<ItemGroup> itemGroupList = new ArrayList<ItemGroup>(1);
        ItemGroup itemGroup = new ItemGroup();
        itemGroup.setBillItems(billInfo.getBillItems());
        itemGroupList.add(itemGroup);
        RuleInfo ruleInfo = this.createRuleInfo(billInfo, rule);
        List<DataProcessPlugin> dataProcessPlugins = this.dataProcessPluginFactory.getPluginByCode(ruleCode);
        for (DataProcessPlugin dataProcessPlugin : dataProcessPlugins) {
            itemGroupList = dataProcessPlugin.processData(itemGroupList, billInfo, ruleInfo);
        }
        logger.debug("group data = {}", itemGroupList);
        LinkedList<SplitPreInvoiceInfo> preInvoiceInfoList = new LinkedList<SplitPreInvoiceInfo>();
        for (ItemGroup itemData : itemGroupList) {
            List<BillItem> billItems = itemData.getBillItems();
            billInfo.setBillItems(billItems);
            preInvoiceInfoList.addAll(this.preInvoiceGenerateService.createPreInvoice(billInfo, rule));
        }
        logger.debug("Bill2PreInvoiceService.createPreInvoiceFromBill, result = {}", preInvoiceInfoList);
        return preInvoiceInfoList;
    }

    private RuleInfo createRuleInfo(BillInfo billInfo, SplitRule rule) {
        RuleInfo ruleInfo = new RuleInfo();
        ruleInfo.setSplitRule(rule);
        if (rule.getUnitPriceScale() == null) {
            rule.setUnitPriceScale(Integer.valueOf(15));
        }
        HashMap<String, Object> extRule = new HashMap<String, Object>();
        extRule.put("originInvoiceCode", billInfo.getOriginInvoiceCode());
        extRule.put("originInvoiceNo", billInfo.getOriginInvoiceNo());
        extRule.put("redNotificationNo", billInfo.getRedNotificationNo());
        ruleInfo.setExtRule(extRule);
        return ruleInfo;
    }

    private void setPriceMethod(BillInfo billInfo, SplitRule rule) {
        rule.setPriceMethod(PriceMethod.value((Integer)billInfo.getPriceMethod()));
        rule.setInvoiceType(billInfo.getInvoiceType());
    }
}

