/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.impl;

import com.alibaba.fastjson.JSON;
import com.xforceplus.phoenix.split.domain.ItemAmountInfo;
import com.xforceplus.phoenix.split.model.PriceMethod;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.SplitBillItemAmountService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultSplitBillItemAmountServiceImpl
implements SplitBillItemAmountService {
    private Logger logger = LoggerFactory.getLogger(DefaultSplitBillItemAmountServiceImpl.class);
    public static final BigDecimal MIN_QUANTITY = BigDecimal.ONE.movePointLeft(6);
    private static final BigDecimal ERROR_AMOUNT_LIMIT = BigDecimal.ONE.movePointLeft(2);

    @Override
    public List<ItemAmountInfo> splitAmount(ItemAmountInfo itemAmountInfo, SplitRule rule) {
        ItemAmountInfo splitAmountInfo = (ItemAmountInfo)JSON.parseObject((String)JSON.toJSONString((Object)itemAmountInfo), ItemAmountInfo.class);
        LinkedList<ItemAmountInfo> result = new LinkedList<ItemAmountInfo>();
        this.calculateAmountByPriceMethod(splitAmountInfo);
        boolean hasQuantity = itemAmountInfo.getQuantity().compareTo(BigDecimal.ZERO) != 0;
        this.mergeDiscountAmount(splitAmountInfo);
        BigDecimal limitAmount = rule.getInvoiceLimit();
        ItemAmountInfo splitItemAmountInfo = null;
        while (this.gtLimitAmount(splitAmountInfo, limitAmount)) {
            splitItemAmountInfo = splitItemAmountInfo == null ? this.splitFirstItemAmountInfo(rule, splitAmountInfo, limitAmount) : this.copyFirstItemAmount(limitAmount, rule, splitAmountInfo, splitItemAmountInfo);
            this.deductSplitItemAmount(rule, splitAmountInfo, splitItemAmountInfo);
            result.add(splitItemAmountInfo);
        }
        this.processLastItemAmountInfo(splitAmountInfo, hasQuantity, rule);
        result.add(splitAmountInfo);
        this.logger.debug("before process error amount result = {}", result);
        this.processErrorAmount(result);
        this.logger.debug("after process error amount result = {}", result);
        return result;
    }

    protected void calculateAmountByPriceMethod(ItemAmountInfo splitAmountInfo) {
        this.calculateWithoutTaxAmount(splitAmountInfo);
    }

    protected void processErrorAmount(List<ItemAmountInfo> itemAmountInfoList) {
        ItemAmountInfo itemAmountInfo;
        ItemAmountInfo lastItemAmountInfo = itemAmountInfoList.get(itemAmountInfoList.size() - 1);
        BigDecimal taxAmountError = lastItemAmountInfo.getAmountWithoutTax().subtract(lastItemAmountInfo.getDeductions()).multiply(lastItemAmountInfo.getTaxRate()).setScale(2, RoundingMode.HALF_UP).subtract(lastItemAmountInfo.getTaxAmount()).abs();
        BigDecimal discountTaxAmount = BigDecimal.ZERO;
        ItemAmountInfo lastDiscountItemAmountInfo = null;
        if (lastItemAmountInfo.getOutterDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0 || lastItemAmountInfo.getOutterPrepayAmountWithoutTax().compareTo(BigDecimal.ZERO) > 0) {
            for (int i = itemAmountInfoList.size() - 1; i >= 0; --i) {
                itemAmountInfo = itemAmountInfoList.get(i);
                if (itemAmountInfo.getDiscountWithoutTax().compareTo(BigDecimal.ZERO) <= 0) continue;
                lastDiscountItemAmountInfo = itemAmountInfo;
                break;
            }
            if (lastDiscountItemAmountInfo == null) {
                throw new RuntimeException("\u672a\u627e\u5230\u6700\u540e\u4e00\u7b14\u6298\u6263\u91d1\u989d\u660e\u7ec6!");
            }
            discountTaxAmount = lastDiscountItemAmountInfo.getDiscountWithoutTax().multiply(lastDiscountItemAmountInfo.getTaxRate()).setScale(2, RoundingMode.HALF_UP).subtract(lastDiscountItemAmountInfo.getDiscountTax()).abs();
        }
        this.logger.info("taxAmountError = {}, discountTaxAmount = {}", (Object)taxAmountError, (Object)discountTaxAmount);
        int index = 0;
        while (this.hasErrorAmount(taxAmountError, discountTaxAmount)) {
            itemAmountInfo = itemAmountInfoList.get(index++);
            taxAmountError = this.processTaxAmountError(taxAmountError, itemAmountInfo, lastItemAmountInfo);
            discountTaxAmount = this.processDiscountTaxAmountError(discountTaxAmount, itemAmountInfo, lastDiscountItemAmountInfo);
        }
    }

    private BigDecimal processDiscountTaxAmountError(BigDecimal discountTaxAmount, ItemAmountInfo itemAmountInfo, ItemAmountInfo lastItemAmountInfo) {
        if (discountTaxAmount.compareTo(ERROR_AMOUNT_LIMIT) > 0) {
            discountTaxAmount = discountTaxAmount.subtract(ERROR_AMOUNT_LIMIT);
            itemAmountInfo.setDiscountTax(itemAmountInfo.getDiscountTax().add(ERROR_AMOUNT_LIMIT));
            itemAmountInfo.setDiscountWithTax(itemAmountInfo.getDiscountWithTax().add(ERROR_AMOUNT_LIMIT));
            lastItemAmountInfo.setDiscountTax(lastItemAmountInfo.getDiscountTax().subtract(ERROR_AMOUNT_LIMIT));
            lastItemAmountInfo.setDiscountWithTax(lastItemAmountInfo.getDiscountWithTax().subtract(ERROR_AMOUNT_LIMIT));
        }
        return discountTaxAmount;
    }

    private BigDecimal processTaxAmountError(BigDecimal taxAmountError, ItemAmountInfo itemAmountInfo, ItemAmountInfo lastItemAmountInfo) {
        if (taxAmountError.compareTo(ERROR_AMOUNT_LIMIT) > 0) {
            taxAmountError = taxAmountError.subtract(ERROR_AMOUNT_LIMIT);
            itemAmountInfo.setTaxAmount(itemAmountInfo.getTaxAmount().add(ERROR_AMOUNT_LIMIT));
            itemAmountInfo.setAmountWithTax(itemAmountInfo.getAmountWithTax().add(ERROR_AMOUNT_LIMIT));
            lastItemAmountInfo.setTaxAmount(lastItemAmountInfo.getTaxAmount().subtract(ERROR_AMOUNT_LIMIT));
            lastItemAmountInfo.setAmountWithTax(lastItemAmountInfo.getAmountWithTax().subtract(ERROR_AMOUNT_LIMIT));
        }
        return taxAmountError;
    }

    private boolean hasErrorAmount(BigDecimal taxAmountError, BigDecimal discountTaxAmount) {
        return taxAmountError.compareTo(ERROR_AMOUNT_LIMIT) > 0 || discountTaxAmount.compareTo(ERROR_AMOUNT_LIMIT) > 0;
    }

    protected void processLastItemAmountInfo(ItemAmountInfo itemAmountInfo, boolean hasQuantity, SplitRule rule) {
        if (hasQuantity) {
            BigDecimal quantity = itemAmountInfo.getQuantity();
            if (quantity.compareTo(BigDecimal.ZERO) == 0) {
                quantity = MIN_QUANTITY;
            }
            itemAmountInfo.setQuantity(quantity);
            itemAmountInfo.setUnitPrice(itemAmountInfo.getAmountWithoutTax().divide(quantity, (int)rule.getUnitPriceScale(), 4));
        }
    }

    private void deductSplitItemAmount(SplitRule rule, ItemAmountInfo itemAmountInfo, ItemAmountInfo splitItemAmountInfo) {
        itemAmountInfo.deductNewItemAmount(splitItemAmountInfo);
        if (DefaultSplitBillItemAmountServiceImpl.isUnitPriceAndQuantityInteger(rule.getAmountSplitRule()) || this.isUnitPrice(rule.getAmountSplitRule())) {
            itemAmountInfo.setQuantity(itemAmountInfo.getQuantity().subtract(splitItemAmountInfo.getQuantity()));
        }
    }

    private ItemAmountInfo copyFirstItemAmount(BigDecimal limitAmount, SplitRule rule, ItemAmountInfo itemAmountInfo, ItemAmountInfo splitItemAmountInfo) {
        ItemAmountInfo result = (ItemAmountInfo)JSON.parseObject((String)JSON.toJSONString((Object)splitItemAmountInfo), ItemAmountInfo.class);
        if (this.leftDiscountAmountLtSplitDiscountAmount(itemAmountInfo, result)) {
            this.reCalculateAmount(limitAmount, rule, itemAmountInfo, result);
        }
        return result;
    }

    protected void reCalculateAmount(BigDecimal limitAmount, SplitRule rule, ItemAmountInfo itemAmountInfo, ItemAmountInfo result) {
        result.setDiscountWithoutTax(itemAmountInfo.getDiscountWithoutTax());
        result.setDiscountTax(itemAmountInfo.getDiscountTax());
        result.setDiscountWithTax(itemAmountInfo.getDiscountWithTax());
        if (result.getAmountWithoutTax().subtract(result.getDiscountWithoutTax()).compareTo(limitAmount) > 0) {
            BigDecimal splitAmountWithoutTax = limitAmount.add(result.getDiscountWithoutTax()).setScale(2, 1);
            BigDecimal splitTaxAmount = splitAmountWithoutTax.subtract(result.getDeductions()).multiply(itemAmountInfo.getTaxRate()).setScale(2, 1);
            BigDecimal splitAmountWithTax = splitAmountWithoutTax.add(splitTaxAmount).setScale(2, 4);
            result.setAmountWithTax(splitAmountWithTax);
            result.setAmountWithoutTax(splitAmountWithoutTax);
            result.setTaxAmount(splitTaxAmount);
            this.processUnitPriceOrQuantity(rule, result);
        }
    }

    protected boolean leftDiscountAmountLtSplitDiscountAmount(ItemAmountInfo itemAmountInfo, ItemAmountInfo result) {
        return itemAmountInfo.getDiscountWithoutTax().compareTo(result.getDiscountWithoutTax()) <= 0;
    }

    protected ItemAmountInfo splitFirstItemAmountInfo(SplitRule rule, ItemAmountInfo itemAmountInfo, BigDecimal limitAmount) {
        return itemAmountInfo.createItemAmountByAmountWithoutTax(rule, limitAmount);
    }

    protected void processUnitPriceOrQuantity(SplitRule rule, ItemAmountInfo newItemAmountInfo) {
        if (this.isUnitPrice(rule.getAmountSplitRule())) {
            BigDecimal unitPrice = newItemAmountInfo.getUnitPrice();
            if (unitPrice != null && unitPrice.compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal quantity = newItemAmountInfo.getAmountWithoutTax().divide(unitPrice, 6, 4);
                if (quantity.compareTo(BigDecimal.ZERO) == 0) {
                    quantity = MIN_QUANTITY;
                    newItemAmountInfo.setUnitPrice(newItemAmountInfo.getAmountWithoutTax().divide(quantity, (int)rule.getUnitPriceScale(), 4));
                }
                newItemAmountInfo.setQuantity(quantity);
            }
        } else if (DefaultSplitBillItemAmountServiceImpl.isUnitPriceAndQuantityInteger(rule.getAmountSplitRule())) {
            BigDecimal quantity = newItemAmountInfo.getAmountWithoutTax().divide(newItemAmountInfo.getUnitPrice(), 0, 4);
            newItemAmountInfo.setQuantity(quantity);
        } else if (DefaultSplitBillItemAmountServiceImpl.isQuantity(rule.getAmountSplitRule())) {
            if (newItemAmountInfo.getQuantity() != null && newItemAmountInfo.getQuantity().compareTo(BigDecimal.ZERO) > 0) {
                newItemAmountInfo.setUnitPrice(newItemAmountInfo.getAmountWithoutTax().divide(newItemAmountInfo.getQuantity(), (int)rule.getUnitPriceScale(), 4));
            }
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected boolean gtLimitAmount(ItemAmountInfo itemAmountInfo, BigDecimal limitAmount) {
        return itemAmountInfo.getAmountWithoutTax().subtract(itemAmountInfo.getDiscountWithoutTax()).compareTo(limitAmount) > 0;
    }

    private void mergeDiscountAmount(ItemAmountInfo itemAmountInfo) {
        itemAmountInfo.setAmountWithoutTax(itemAmountInfo.getAmountWithoutTax().subtract(itemAmountInfo.getInnerDiscountWithoutTax()).subtract(itemAmountInfo.getInnerPrepayAmountWithoutTax()));
        itemAmountInfo.setAmountWithTax(itemAmountInfo.getAmountWithTax().subtract(itemAmountInfo.getInnerDiscountWithTax()).subtract(itemAmountInfo.getInnerPrepayAmountWithTax()));
        itemAmountInfo.setTaxAmount(itemAmountInfo.getTaxAmount().subtract(itemAmountInfo.getInnerDiscountTax()).subtract(itemAmountInfo.getInnerPrepayAmountTax()));
        itemAmountInfo.setDiscountWithoutTax(itemAmountInfo.getOutterDiscountWithoutTax().add(itemAmountInfo.getOutterPrepayAmountWithoutTax()));
        itemAmountInfo.setDiscountWithTax(itemAmountInfo.getOutterDiscountWithTax().add(itemAmountInfo.getOutterPrepayAmountWithTax()));
        itemAmountInfo.setDiscountTax(itemAmountInfo.getOutterDiscountTax().add(itemAmountInfo.getOutterPrepayAmountTax()));
    }

    private void calculateWithoutTaxAmount(ItemAmountInfo itemAmountInfo) {
        if (itemAmountInfo.getPriceMethod() == PriceMethod.WITH_TAX) {
            BigDecimal innerPrepayAmountWithTax;
            BigDecimal innerDiscountWithTax;
            BigDecimal outterPrepayAmountWithTax;
            BigDecimal amountWithTax = itemAmountInfo.getAmountWithTax();
            BigDecimal taxRate = itemAmountInfo.getTaxRate();
            itemAmountInfo.setAmountWithoutTax(amountWithTax.add(itemAmountInfo.getDeductions().multiply(taxRate)).divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP));
            itemAmountInfo.setTaxAmount(amountWithTax.subtract(itemAmountInfo.getAmountWithoutTax()));
            BigDecimal outterDiscountWithTax = itemAmountInfo.getOutterDiscountWithTax();
            if (outterDiscountWithTax.compareTo(BigDecimal.ZERO) > 0) {
                itemAmountInfo.setOutterDiscountWithoutTax(outterDiscountWithTax.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP));
                itemAmountInfo.setOutterDiscountTax(itemAmountInfo.getOutterDiscountWithTax().subtract(itemAmountInfo.getOutterDiscountWithoutTax()));
            }
            if ((outterPrepayAmountWithTax = itemAmountInfo.getOutterPrepayAmountWithTax()).compareTo(BigDecimal.ZERO) > 0) {
                itemAmountInfo.setOutterPrepayAmountWithoutTax(outterPrepayAmountWithTax.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP));
                itemAmountInfo.setOutterPrepayAmountTax(itemAmountInfo.getOutterPrepayAmountWithTax().subtract(itemAmountInfo.getOutterPrepayAmountWithoutTax()));
            }
            if ((innerDiscountWithTax = itemAmountInfo.getInnerDiscountWithTax()).compareTo(BigDecimal.ZERO) > 0) {
                itemAmountInfo.setInnerDiscountWithoutTax(innerDiscountWithTax.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP));
                itemAmountInfo.setInnerDiscountTax(itemAmountInfo.getInnerDiscountWithTax().subtract(itemAmountInfo.getInnerDiscountWithoutTax()));
            }
            if ((innerPrepayAmountWithTax = itemAmountInfo.getInnerPrepayAmountWithTax()).compareTo(BigDecimal.ZERO) > 0) {
                itemAmountInfo.setInnerPrepayAmountWithoutTax(innerPrepayAmountWithTax.divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP));
                itemAmountInfo.setInnerPrepayAmountTax(itemAmountInfo.getInnerPrepayAmountWithTax().subtract(itemAmountInfo.getInnerPrepayAmountWithoutTax()));
            }
        }
    }

    public static boolean isQuantity(String amountSplitRule) {
        return "1".equals(amountSplitRule);
    }

    private boolean isUnitPrice(String amountSplitRule) {
        return "3".equals(amountSplitRule);
    }

    public static boolean isUnitPriceAndQuantityInteger(String amountSplitRule) {
        return "2".equals(amountSplitRule);
    }
}

