/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.xforceplus.phoenix.split.constant.InvoiceType;
import com.xforceplus.phoenix.split.constant.PreInvoiceTemplateVersionStatus;
import com.xforceplus.phoenix.split.constant.RemarkConstant;
import com.xforceplus.phoenix.split.exception.SplitBizException;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.PreInvoiceExt;
import com.xforceplus.phoenix.split.model.PreInvoiceItem;
import com.xforceplus.phoenix.split.model.PreInvoiceMain;
import com.xforceplus.phoenix.split.model.SplitPreInvoiceInfo;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.model.ZeroTaxOption;
import com.xforceplus.phoenix.split.service.PreInvoiceGenerateService;
import com.xforceplus.phoenix.split.service.RemarkService;
import com.xforceplus.phoenix.split.util.CommonTools;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PreInvoiceGenerateServiceImpl
implements PreInvoiceGenerateService {
    private static final Logger logger = LoggerFactory.getLogger(PreInvoiceGenerateServiceImpl.class);
    public static final String MESSAGE = "\u6210\u54c1\u6cb9\u53d1\u7968\u6570\u91cf\uff0c\u5355\u4f4d\u4e3a\u5fc5\u586b";
    public static final String CPY = "2";
    public static final String FORCE_LIST_OPTION = "2";
    private static final String DISABLE_LIST_OPTION = "0";
    @Autowired
    protected RemarkService remarkService;
    @Value(value="${cargoNameLengthLimit:100}")
    private int cargoNameLengthLimit;
    private static final Charset GBK = Charset.forName("GBK");

    @Override
    public List<SplitPreInvoiceInfo> createPreInvoice(BillInfo billInfo, SplitRule rule) {
        List billItemList = billInfo.getBillItems();
        if (CollectionUtils.isEmpty((Collection)billItemList)) {
            return Lists.newArrayList();
        }
        if (("1".equals(rule.getSaleListOption()) || "2".equals(rule.getSaleListOption())) && billInfo.getInvoiceType().equals(InvoiceType.NORMAL_ROLL.value())) {
            throw new SplitBizException("\u5377\u7968\u4e0d\u652f\u6301\u9500\u8d27\u6e05\u5355");
        }
        SplitPreInvoiceInfo splitPreInvoiceInfo = this.generatePreInvoice(billInfo, rule);
        splitPreInvoiceInfo.getPreInvoiceMain().setRemark(this.toLegalRemark(billInfo, rule));
        return Lists.newArrayList((Object[])new SplitPreInvoiceInfo[]{splitPreInvoiceInfo});
    }

    boolean isRedInvoice(PreInvoiceMain preInvoiceMain) {
        return StringUtils.isNotBlank((CharSequence)preInvoiceMain.getOriginInvoiceNo()) || StringUtils.isNotBlank((CharSequence)preInvoiceMain.getOriginInvoiceCode()) || StringUtils.isNotBlank((CharSequence)preInvoiceMain.getRedNotificationNo());
    }

    private SplitPreInvoiceInfo generatePreInvoice(BillInfo billInfo, SplitRule rule) {
        BillItem billItem0 = (BillItem)billInfo.getBillItems().get(0);
        boolean isRedItem = ((BillItem)billInfo.getBillItems().get(0)).isRedItem();
        if (rule.getZeroTaxOption().equals((Object)ZeroTaxOption.PROCESS) && billItem0.getTaxRate().equals(BigDecimal.ZERO)) {
            billInfo.setInvoiceType(InvoiceType.NORMAL.value());
        }
        String specialInvoiceFlag = DISABLE_LIST_OPTION;
        if (RemarkConstant.HBBM_SET.contains(billItem0.getGoodsTaxNo())) {
            specialInvoiceFlag = "2";
        }
        SplitPreInvoiceInfo splitPreInvoiceInfo = new SplitPreInvoiceInfo();
        splitPreInvoiceInfo.setRuleId(String.valueOf(rule.getRuleId()));
        splitPreInvoiceInfo.setPreInvoiceMain(this.createPreInvoiceMain(billInfo, rule, specialInvoiceFlag));
        splitPreInvoiceInfo.setPreInvoiceItems(this.createPreInvoiceItems(billInfo.getBillItems(), rule, isRedItem));
        splitPreInvoiceInfo.getPreInvoiceMain().setSaleListFileFlag(Byte.valueOf(this.getPrintSalesListFlag(splitPreInvoiceInfo, rule) ? "1" : DISABLE_LIST_OPTION));
        if (splitPreInvoiceInfo.getPreInvoiceMain().getSaleListFileFlag().equals(Byte.valueOf("1")) && splitPreInvoiceInfo.getPreInvoiceItems().size() > rule.getSalesListMaxRow()) {
            throw new SplitBizException("\u660e\u7ec6\u884c\u6570\u8d85\u8fc7\u9500\u8d27\u6e05\u5355\u884c\u6570\uff01");
        }
        splitPreInvoiceInfo.getPreInvoiceMain().setListGoodsName(Byte.valueOf("1").equals(splitPreInvoiceInfo.getPreInvoiceMain().getSaleListFileFlag()) ? RemarkConstant.LIST_GOODS_NAME : "");
        List taxRateList = splitPreInvoiceInfo.getPreInvoiceItems().stream().map(PreInvoiceItem::getTaxRate).distinct().map(BigDecimal::toPlainString).collect(Collectors.toList());
        splitPreInvoiceInfo.getPreInvoiceMain().setTaxRate(Joiner.on((String)",").skipNulls().join(taxRateList));
        BigDecimal amountWithTax = splitPreInvoiceInfo.getPreInvoiceItems().stream().map(PreInvoiceItem::getAmountWithTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal discountWithTax = splitPreInvoiceInfo.getPreInvoiceItems().stream().map(PreInvoiceItem::getDiscountWithTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        splitPreInvoiceInfo.getPreInvoiceMain().setAmountWithTax(amountWithTax.subtract(discountWithTax).setScale(2, 4));
        BigDecimal amountWithoutTax = splitPreInvoiceInfo.getPreInvoiceItems().stream().map(PreInvoiceItem::getAmountWithoutTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal discountWithoutTax = splitPreInvoiceInfo.getPreInvoiceItems().stream().map(PreInvoiceItem::getDiscountWithoutTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        splitPreInvoiceInfo.getPreInvoiceMain().setAmountWithoutTax(amountWithoutTax.subtract(discountWithoutTax).setScale(2, 4));
        BigDecimal taxAmount = splitPreInvoiceInfo.getPreInvoiceItems().stream().map(PreInvoiceItem::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal discountTax = splitPreInvoiceInfo.getPreInvoiceItems().stream().map(PreInvoiceItem::getDiscountTax).reduce(BigDecimal.ZERO, BigDecimal::add);
        splitPreInvoiceInfo.getPreInvoiceMain().setTaxAmount(taxAmount.subtract(discountTax).setScale(2, 4));
        return splitPreInvoiceInfo;
    }

    private boolean getPrintSalesListFlag(SplitPreInvoiceInfo splitPreInvoiceInfo, SplitRule rule) {
        int itemSize = 0;
        for (PreInvoiceItem preInvoiceItem : splitPreInvoiceInfo.getPreInvoiceItems()) {
            itemSize = this.hasDiscount(preInvoiceItem) ? itemSize + 2 : itemSize + 1;
        }
        if ("2".equals(splitPreInvoiceInfo.getPreInvoiceMain().getSpecialInvoiceFlag())) {
            return false;
        }
        if (this.forcePrintListFlag(splitPreInvoiceInfo, rule, itemSize)) {
            return true;
        }
        if ("2".equals(rule.getSaleListOption())) {
            return true;
        }
        if (DISABLE_LIST_OPTION.equals(rule.getSaleListOption())) {
            return false;
        }
        return rule.getInvoiceItemMaxRow() == null || itemSize > rule.getInvoiceItemMaxRow();
    }

    private boolean forcePrintListFlag(SplitPreInvoiceInfo splitPreInvoiceInfo, SplitRule rule, int itemSize) {
        return this.isRedInvoice(splitPreInvoiceInfo.getPreInvoiceMain()) && itemSize > rule.getInvoiceItemMaxRow();
    }

    private boolean hasDiscount(PreInvoiceItem preInvoiceItem) {
        return preInvoiceItem.getDiscountWithoutTax() != null && preInvoiceItem.getDiscountWithoutTax().compareTo(BigDecimal.ZERO) > 0;
    }

    private PreInvoiceExt createPreInvoiceExt() {
        return null;
    }

    private PreInvoiceMain createPreInvoiceMain(BillInfo billInfo, SplitRule rule, String specialInvoiceFlag) {
        PreInvoiceMain preInvoiceMain = new PreInvoiceMain();
        BeanUtils.copyProperties((Object)billInfo, (Object)preInvoiceMain);
        preInvoiceMain.setRuleId(rule.getRuleId());
        preInvoiceMain.setDisplayPriceQuality(Byte.valueOf(rule.getUnitPriceAmountOps()));
        preInvoiceMain.setSpecialInvoiceFlag(specialInvoiceFlag);
        preInvoiceMain.setTemplateVersion(null != rule.getInvoiceItemMaxRow() && rule.getInvoiceItemMaxRow() > 5 ? PreInvoiceTemplateVersionStatus.EIGHT.getValue() : PreInvoiceTemplateVersionStatus.FIVE.getValue());
        return preInvoiceMain;
    }

    public static void negateBigDecimalField(Object object) {
        try {
            for (Field field : object.getClass().getDeclaredFields()) {
                if (field.getType() != BigDecimal.class) continue;
                field.setAccessible(true);
                BigDecimal bigDecimal = (BigDecimal)field.get(object);
                if (!Objects.nonNull(bigDecimal)) continue;
                field.set(object, bigDecimal.negate());
            }
        }
        catch (IllegalAccessException e) {
            logger.error("negateBigDecimalField error:{}", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<PreInvoiceItem> createPreInvoiceItems(List<BillItem> itemList, SplitRule rule, boolean isRedItem) {
        ArrayList<PreInvoiceItem> preInvoiceItems = new ArrayList<PreInvoiceItem>(itemList.size());
        int cargoNameLengthLimit = this.getCargoNameLengthLimit(rule);
        for (BillItem billItem : itemList) {
            PreInvoiceItem preInvoiceItem = new PreInvoiceItem();
            preInvoiceItems.add(preInvoiceItem);
            BeanUtils.copyProperties((Object)billItem, (Object)preInvoiceItem);
            billItem.setAmountWithoutTax(billItem.getAmountWithoutTax().setScale(2, 4));
            billItem.setAmountWithTax(billItem.getAmountWithTax().setScale(2, 4));
            billItem.setTaxAmount(billItem.getAmountWithTax().setScale(2, 4));
            billItem.setDiscountWithoutTax(billItem.getDiscountWithoutTax().setScale(2, 4));
            billItem.setDiscountWithTax(billItem.getDiscountWithTax().setScale(2, 4));
            billItem.setDiscountTax(billItem.getDiscountTax().setScale(2, 4));
            if (isRedItem) {
                PreInvoiceGenerateServiceImpl.negateBigDecimalField(preInvoiceItem);
            }
            preInvoiceItem.setUnitPrice(preInvoiceItem.getUnitPrice().abs());
            preInvoiceItem.setTaxRate(preInvoiceItem.getTaxRate().abs());
            preInvoiceItem.setCargoCode(billItem.getItemCode());
            this.setCargoName(billItem, preInvoiceItem);
            if (this.cargoNameGtLimit(preInvoiceItem.getCargoName(), cargoNameLengthLimit)) {
                preInvoiceItem.setCargoName(CommonTools.substring(preInvoiceItem.getCargoName(), cargoNameLengthLimit, GBK));
            }
            preInvoiceItem.setPrintContentFlag(this.getPrintContentFlag(rule, billItem));
            preInvoiceItem.setTaxItem("");
            preInvoiceItem.setDeduction(billItem.getDeductions());
            preInvoiceItem.setGoodsTaxNo(this.getStrOrDefaultStr(billItem.getGoodsTaxNo(), ""));
            preInvoiceItem.setTaxPre(this.getStrOrDefaultStr(billItem.getTaxPre(), DISABLE_LIST_OPTION));
            preInvoiceItem.setZeroTax(this.getStrOrDefaultStr(billItem.getZeroTax(), ""));
            preInvoiceItem.setPriceMethod(String.valueOf(rule.getPriceMethod().value()));
            if (!RemarkConstant.HBBM_SET.contains(preInvoiceItem.getGoodsTaxNo())) continue;
            Objects.requireNonNull(preInvoiceItem.getQuantity(), MESSAGE);
            Objects.requireNonNull(preInvoiceItem.getQuantityUnit(), MESSAGE);
            if (preInvoiceItem.getQuantity().compareTo(BigDecimal.ZERO) != 0) continue;
            throw new SplitBizException(MESSAGE);
        }
        return preInvoiceItems;
    }

    private String getStrOrDefaultStr(String str, String defaultStr) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return defaultStr;
        }
        return str;
    }

    private String getPrintContentFlag(SplitRule rule, BillItem billItem) {
        return BigDecimal.ZERO.compareTo(billItem.getQuantity()) == 0 && BigDecimal.ZERO.compareTo(billItem.getUnitPrice()) == 0 ? "1" : (StringUtils.isNotEmpty((CharSequence)rule.getUnitPriceAmountOps()) ? rule.getUnitPriceAmountOps() : DISABLE_LIST_OPTION);
    }

    private void setCargoName(BillItem billItem, PreInvoiceItem preInvoiceItem) {
        if (StringUtils.isNotBlank((CharSequence)billItem.getItemShortName())) {
            String cargoName = RemarkConstant.TAX_CODE_SHORT_NAME_JOINER_PREFIX + billItem.getItemShortName() + RemarkConstant.TAX_CODE_SHORT_NAME_JOINER_SUFFIX;
            cargoName = StringUtils.isNotBlank((CharSequence)billItem.getJoinName()) ? cargoName + billItem.getJoinName() : cargoName + billItem.getItemName();
            preInvoiceItem.setCargoName(cargoName);
        } else {
            preInvoiceItem.setCargoName(billItem.getItemName());
            if (StringUtils.isNotBlank((CharSequence)billItem.getJoinName())) {
                preInvoiceItem.setCargoName(billItem.getJoinName());
            }
        }
    }

    private int getCargoNameLengthLimit(SplitRule rule) {
        return rule.getCargoNameLength() == null ? this.cargoNameLengthLimit : (rule.getCargoNameLength() > this.cargoNameLengthLimit ? this.cargoNameLengthLimit : rule.getCargoNameLength());
    }

    private boolean cargoNameGtLimit(String cargoName, int cargoNameLengthLimit) {
        return cargoName.getBytes(GBK).length > cargoNameLengthLimit;
    }

    private String toLegalRemark(BillInfo billInfo, SplitRule rule) {
        String remark = this.remarkService.splice(billInfo, rule);
        Integer remarkSizeLimit = rule.getCustomRemarkSize();
        if (Objects.isNull(remarkSizeLimit)) {
            remarkSizeLimit = InvoiceType.ELECTRONIC.value().equals(billInfo.getInvoiceType()) ? Integer.valueOf(RemarkConstant.ELECTRONIC_SIZE) : Integer.valueOf(RemarkConstant.DEFAULT_SIZE);
        }
        return RemarkService.toLegalRemark(remark, remarkSizeLimit);
    }
}

