package com.xforceplus.phoenix.split.service;

import com.xforceplus.phoenix.split.model.SplitRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class SplitBillItemAmountServiceFactory {

    @Autowired
    @Qualifier("defaultSplitBillItemAmountServiceImpl")
    private SplitBillItemAmountService defaultSplitBillItemAmountService;

    @Autowired
    @Qualifier("splitBillItemByAmountWithTaxServiceImpl")
    private SplitBillItemAmountService splitBillItemByAmountWithTaxServiceImpl;


    public SplitBillItemAmountService getByRule(SplitRule rule) {
        if (rule.isLimitIsAmountWithTax()) {
            return splitBillItemByAmountWithTaxServiceImpl;
        } else {
            return defaultSplitBillItemAmountService;
        }
    }

}
