package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.dataflow.AbstractBillItemGroupPlugin;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 红蓝业务单明细分组
 */
@Service
public class GroupItemByRedAndBluePlugin extends AbstractBillItemGroupPlugin {

    @Override
    protected String generateKey(BillItem billItem, SplitRule rule) {
        return isRedItem(billItem)? "red" : "blue";
    }

    private boolean isRedItem(BillItem billItem) {
        if (billItem.getAmountWithoutTax().compareTo(BigDecimal.ZERO) < 0) {
            billItem.setRedItem(true);
            return true;
        }
        return false;
    }

    @Override
    protected boolean support(SplitRule rule) {
        return true;
    }
}
