package com.xforceplus.phoenix.split.service.dataflow.impl;

import com.xforceplus.phoenix.split.domain.ItemGroup;
import com.xforceplus.phoenix.split.domain.RuleInfo;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.service.dataflow.DataProcessPlugin;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RedBillItemProcessPlugin implements DataProcessPlugin {

    @Override
    public List<ItemGroup> processData(List<ItemGroup> itemGroups, BillInfo billInfo, RuleInfo ruleInfo) {

        for (ItemGroup itemGroup : itemGroups) {
            List<BillItem> billItems = itemGroup.getBillItems();
            billItems.forEach(billItem -> {
                if (isRedItem(billItem)) {
                    amount2Positive(billItem);
                }
            });
        }

        return itemGroups;
    }

    private void amount2Positive(BillItem billItem) {
        billItem.setUnitPrice(billItem.getUnitPrice().abs());
        billItem.setOutterDiscountWithTax(billItem.getOutterDiscountWithTax().abs());
        billItem.setOutterDiscountWithoutTax(billItem.getOutterDiscountWithoutTax().abs());
        billItem.setOutterDiscountTax(billItem.getOutterDiscountTax().abs());
        billItem.setInnerDiscountWithTax(billItem.getInnerDiscountWithTax().abs());
        billItem.setInnerDiscountWithoutTax(billItem.getInnerDiscountWithoutTax().abs());
        billItem.setInnerDiscountTax(billItem.getInnerDiscountTax().abs());
        billItem.setInnerPrepayAmountWithTax(billItem.getInnerPrepayAmountWithTax().abs());
        billItem.setInnerPrepayAmountWithoutTax(billItem.getInnerPrepayAmountWithoutTax().abs());
        billItem.setInnerPrepayAmountTax(billItem.getInnerPrepayAmountTax().abs());
        billItem.setOutterPrepayAmountWithTax(billItem.getOutterPrepayAmountWithTax().abs());
        billItem.setOutterPrepayAmountWithoutTax(billItem.getOutterPrepayAmountWithoutTax().abs());
        billItem.setOutterPrepayAmountTax(billItem.getOutterPrepayAmountTax().abs());
        billItem.setQuantity(billItem.getQuantity().abs());
        billItem.setAmountWithTax(billItem.getAmountWithTax().abs());
        billItem.setAmountWithoutTax(billItem.getAmountWithoutTax().abs());
        billItem.setTaxAmount(billItem.getTaxAmount().abs());

        billItem.setDeductions(billItem.getDeductions().abs());

    }

    private boolean isRedItem(BillItem billItem) {
        return billItem.isRedItem();
    }
}
