package com.xforceplus.phoenix.split.service.impl;

import com.xforceplus.phoenix.split.domain.ItemAmountInfo;
import com.xforceplus.phoenix.split.model.SplitRule;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;

import static java.math.BigDecimal.ROUND_HALF_UP;
import static java.math.BigDecimal.ZERO;
import static java.math.RoundingMode.HALF_UP;

@Service
public class SplitBillItemByAmountWithTaxServiceImpl extends DefaultSplitBillItemAmountServiceImpl {

    @Override
    protected void reCalculateAmount(BigDecimal limitAmount, SplitRule rule, ItemAmountInfo itemAmountInfo, ItemAmountInfo result) {
        result.setDiscountWithTax(itemAmountInfo.getDiscountWithTax());
        result.setDiscountWithoutTax(calculateAmountWithoutTaxByAmountWithTax(
                result.getDiscountWithTax(),
                result.getTaxRate(),
                ZERO));
        result.setDiscountTax(calculateTaxAmount(result.getDiscountWithTax(), result.getDiscountWithoutTax()));

        if (result.getAmountWithTax().subtract(result.getDiscountWithTax()).compareTo(limitAmount) > 0) {
            BigDecimal splitAmountWithTax = limitAmount.add(result.getDiscountWithTax()).setScale(2, ROUND_HALF_UP);
            BigDecimal splitAmountWithoutTax = calculateAmountWithoutTaxByAmountWithTax(splitAmountWithTax,
                    result.getTaxRate(), result.getDeductions());


            BigDecimal splitTaxAmount = calculateTaxAmount(splitAmountWithTax, splitAmountWithoutTax);

            result.setAmountWithTax(splitAmountWithTax);
            result.setAmountWithoutTax(splitAmountWithoutTax);
            result.setTaxAmount(splitTaxAmount);
            //todo 保单价拆数量时，单价比较大的情况需要处理
            processUnitPriceOrQuantity(rule, result);
        }
    }

    @Override
    protected boolean leftDiscountAmountLtSplitDiscountAmount(ItemAmountInfo itemAmountInfo, ItemAmountInfo result) {
        return itemAmountInfo.getDiscountWithTax().compareTo(result.getDiscountWithTax()) < 0;
    }

    @Override
    protected void processLastItemAmountInfo(ItemAmountInfo itemAmountInfo, boolean hasQuantity) {
        BigDecimal amountWithoutTax = calculateAmountWithoutTaxByAmountWithTax(itemAmountInfo.getAmountWithTax(),
                itemAmountInfo.getTaxRate(),
                itemAmountInfo.getDeductions());
        BigDecimal taxAmount = calculateTaxAmount(itemAmountInfo.getAmountWithTax(), amountWithoutTax);

        BigDecimal discountWithoutTax = calculateAmountWithoutTaxByAmountWithTax(itemAmountInfo.getDiscountWithTax(),
                itemAmountInfo.getTaxRate(),
                BigDecimal.ZERO);

        BigDecimal discountTax = calculateTaxAmount(itemAmountInfo.getDiscountWithTax(), discountWithoutTax);

        itemAmountInfo.setAmountWithoutTax(amountWithoutTax);
        itemAmountInfo.setTaxAmount(taxAmount);
        itemAmountInfo.setDiscountWithoutTax(discountWithoutTax);
        itemAmountInfo.setDiscountTax(discountTax);

        super.processLastItemAmountInfo(itemAmountInfo, hasQuantity);
    }

    private BigDecimal calculateTaxAmount(BigDecimal amountWithTax, BigDecimal amountWithoutTax) {
        return amountWithTax.subtract(amountWithoutTax);
    }

    private BigDecimal calculateAmountWithoutTaxByAmountWithTax(BigDecimal amountWithTax, BigDecimal taxRate, BigDecimal deductions) {
        return amountWithTax.add(deductions.multiply(taxRate)).divide(BigDecimal.ONE.add(taxRate), 2, HALF_UP);
    }

    @Override
    protected void processErrorAmount(List<ItemAmountInfo> itemAmountInfoList) {
        //nothing
    }


    @Override
    protected ItemAmountInfo splitFirstItemAmountInfo(SplitRule rule, ItemAmountInfo itemAmountInfo, BigDecimal limitAmount) {
        return itemAmountInfo.createItemAmountByAmountWithTax(rule, limitAmount);
    }

    @Override
    protected boolean gtLimitAmount(ItemAmountInfo itemAmountInfo, BigDecimal limitAmount) {
        return itemAmountInfo.getAmountWithTax()
                .subtract(itemAmountInfo.getDiscountWithTax())
                .compareTo(limitAmount) > 0;
    }

    @Override
    protected void calculateAmountByPriceMethod(ItemAmountInfo splitAmountInfo) {
        //nothing
    }
}
