package com.xforceplus.phoenix.split.util;

import com.google.common.base.Stopwatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.util.StringUtils;

import javax.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.util.List;
import java.util.UUID;
import java.util.zip.Deflater;

public class CommonTools {


    private static final Logger logger = LoggerFactory.getLogger(CommonTools.class);

    public static String format(String format, Object... args) {
        return MessageFormatter.arrayFormat(format, args).getMessage();
    }

    public static boolean isEdit(Long id) {
        return id != null && id > 0;
    }

//    public static MapperFacade getMapper() {
//        MapperFactory mapperFactory = new DefaultMapperFactory.Builder().build();
//        MapperFacade mapper = mapperFactory.getMapperFacade();
//        return mapper;
//    }

    /**
     * Get string real length.
     *
     * @param str
     * @return
     */
    public static int getStringRealLength(String str) {
        int strLength = 0;
        char[] strChars = str.trim().toCharArray();
        for (char c : strChars) {
            if (isChinese(c)) {
                strLength += 2;
            } else if (isEnglishWord(c + "")) {
                strLength += 1;
            } else if (isNumeric(c)) {
                strLength += 1;
            } else if (isEnglishSymbol(c + "")) {
                strLength += 1;
            } else {
                strLength += 1;
            }
        }
        return strLength;
    }

    /**
     * Judgment whether Chinese.
     *
     * @param c
     * @return
     */
    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS
                || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS
                || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A
                || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B
                || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION
                || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS
                || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION) {
            return true;
        }
        return false;
    }

    /**
     * Judgment whether English symbol.
     *
     * @param charaString
     * @return
     */
    public static boolean isEnglishSymbol(String charaString) {
        return charaString.matches("^[%&',;=?$_\\-\\(\\)\\[\\]\\*]*");
    }

    /**
     * Judgment whether English word.
     *
     * @param charaString
     * @return
     */
    public static boolean isEnglishWord(String charaString) {
        return charaString.matches("^[a-zA-Z]*");
    }

    /**
     * Judgment whether number.
     *
     * @param num
     * @return
     */
    public static boolean isNumeric(char num) {
        return Character.isDigit(num);
    }

    /**
     * 字符串补全位数
     *
     * @param str
     * @param length
     * @return
     */
    public static String fill(String str, int length) {
        String backStr = str;
        while (backStr.length() < length) {
            backStr = "0" + backStr;
        }
        return backStr;
    }

    /**
     * 补全5位字符串
     *
     * @param i
     * @return
     */
    public static String fill5(int i) {
        return fill(i + "", 5);
    }

    public static boolean isEmpty(String s) {
        return !StringUtils.hasText(s);
    }

    public static boolean isEmpty(List list) {
        if (list == null) {
            return true;
        }
        if (list.size() == 0) {
            return true;
        }
        return false;
    }

    public static String createOssObjName(@Nullable String key) {
        if (!StringUtils.hasText(key)) {
            key = UUID.randomUUID().toString().replaceAll("-", "").toLowerCase();
        }
        LocalDate now = LocalDate.now();
        return now.getYear() +
                "/" +
                now.getMonthValue() +
                "/" +
                now.getDayOfMonth() +
                "/" +
                key;
    }


    public static byte[] compress(byte[] inputByte) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        int len = 0;
        Deflater defl = new Deflater();
        defl.setInput(inputByte);
        defl.finish();
        byte[] outputByte = new byte[1024];
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream()) {
            while (!defl.finished()) {
                len = defl.deflate(outputByte);
                bos.write(outputByte, 0, len);
            }
            defl.end();
            logger.info("compress time = {}", stopwatch.elapsed().toMillis());
            return bos.toByteArray();
        } catch (IOException e) {
            throw new IllegalStateException("compress fail!");
        }
    }

    /**
     * @param text    目标字符串
     * @param length    截取长度
     * @param charset    采用的编码方式
     * @return
     */

    public static String substring(String text, int length, Charset charset){
        if (text == null) {
            return null;
        }
        if (text.getBytes(charset).length < length){
            return text;
        }
        StringBuilder sb = new StringBuilder();
        int currentLength = 0;
        for (char c : text.toCharArray()) {
            currentLength += String.valueOf(c).getBytes(charset).length;
            if (currentLength <= length) {
                sb.append(c);
            } else {
                break;
            }
        }
        return sb.toString();
    }
}
