/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@ConfigurationProperties(prefix="rule")
public class DataProcessPluginConfig
implements InitializingBean {
    private Map<String, List<String>> pluginBeanNames;

    public Map<String, List<String>> getPluginBeanNames() {
        return this.pluginBeanNames;
    }

    public void setPluginBeanNames(Map<String, List<String>> pluginBeanNames) {
        this.pluginBeanNames = pluginBeanNames;
    }

    public List<String> getBeanNamesByRuleCode(String ruleCode) {
        return this.pluginBeanNames.get(ruleCode);
    }

    public void afterPropertiesSet() {
        if (CollectionUtils.isEmpty(this.pluginBeanNames)) {
            this.pluginBeanNames = new HashMap<String, List<String>>(4);
            ArrayList<String> plugins = new ArrayList<String>();
            plugins.add("fieldProcessPlugin");
            plugins.add("groupItemByZeroTaxPlugin");
            plugins.add("groupItemByRedAndBluePlugin");
            plugins.add("groupItemBySplitCodePlugin");
            plugins.add("groupItemBySplitFieldPlugin");
            plugins.add("redBillItemProcessPlugin");
            plugins.add("splitBillItemPlugin");
            plugins.add("billItemDiscountAmountProcessPlugin");
            plugins.add("invoiceLimitProcessPlugin");
            this.pluginBeanNames.put("default", plugins);
        }
    }
}

