/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.impl;

import com.google.common.base.Strings;
import com.xforceplus.phoenix.split.constant.InvoiceType;
import com.xforceplus.phoenix.split.model.BillInfo;
import com.xforceplus.phoenix.split.model.BillItem;
import com.xforceplus.phoenix.split.model.FieldOfObj;
import com.xforceplus.phoenix.split.model.PriceMethod;
import com.xforceplus.phoenix.split.model.RemarkFieldMetadata;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.RemarkService;
import com.xforceplus.phoenix.split.util.CommonTools;
import com.xforceplus.phoenix.split.util.FiledUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.reflection.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RemarkServiceImpl
implements RemarkService {
    private static final Logger logger = LoggerFactory.getLogger(RemarkServiceImpl.class);

    @Override
    public String splice(BillInfo billInfo, SplitRule rule) {
        List remarkFiledMetadataBeanList;
        StringBuilder sb = new StringBuilder();
        PriceMethod priceMethod = rule.getPriceMethod();
        List billItems = billInfo.getBillItems();
        if (InvoiceType.SPECIAL.value().equals(billInfo.getInvoiceType())) {
            if (StringUtils.isNotBlank((CharSequence)billInfo.getRedNotificationNo())) {
                sb.append(CommonTools.format("\u5f00\u5177\u7ea2\u5b57\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968\u4fe1\u606f\u8868\u7f16\u53f7{}", billInfo.getRedNotificationNo()));
            }
        } else if (InvoiceType.NORMAL.value().equals(billInfo.getInvoiceType()) || InvoiceType.ELECTRONIC.value().equals(billInfo.getInvoiceType())) {
            if (StringUtils.isNotBlank((CharSequence)billInfo.getOriginInvoiceCode())) {
                sb.append("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968").append(CommonTools.format("\u4ee3\u7801:{}", billInfo.getOriginInvoiceCode()));
                if (StringUtils.isNotBlank((CharSequence)billInfo.getOriginInvoiceNo())) {
                    sb.append(CommonTools.format("\u53f7\u7801:{}", billInfo.getOriginInvoiceNo()));
                }
            } else if (StringUtils.isNotBlank((CharSequence)billInfo.getOriginInvoiceNo())) {
                sb.append("\u5bf9\u5e94\u6b63\u6570\u53d1\u7968").append(CommonTools.format("\u53f7\u7801:{}", billInfo.getOriginInvoiceNo()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(remarkFiledMetadataBeanList = rule.getRemarkFiledMetadataBeanList()))) {
            long size = remarkFiledMetadataBeanList.stream().filter(remarkFieldMetadata -> "remark".equalsIgnoreCase(remarkFieldMetadata.getFieldName())).count();
            if (size > 0L) {
                this.appendSpace(sb);
                sb.append(Objects.toString(billInfo.getRemark(), ""));
            }
            this.appendSpace(sb);
            for (RemarkFieldMetadata metadataBean : remarkFiledMetadataBeanList) {
                if (metadataBean.getFieldGroupIndex() == FieldOfObj.BILL_INFO) {
                    if (StringUtils.equals((CharSequence)metadataBean.getFieldName(), (CharSequence)"remark")) continue;
                    if (StringUtils.equals((CharSequence)metadataBean.getFieldName(), (CharSequence)"fixedRemark")) {
                        sb.append(Strings.nullToEmpty((String)rule.getFixedRemarkText()));
                    } else if (StringUtils.equals((CharSequence)metadataBean.getFieldName(), (CharSequence)"priceMethod")) {
                        sb.append(metadataBean.getFieldDisplayName()).append("[").append(this.getPriceMethod(priceMethod)).append("]");
                    } else {
                        sb.append(metadataBean.getFieldDisplayName()).append("[").append(this.getReMark(billInfo, metadataBean.getFieldName())).append("]");
                    }
                } else {
                    String fieldValue = "";
                    fieldValue = StringUtils.equals((CharSequence)metadataBean.getFieldName(), (CharSequence)"taxPre") ? billItems.stream().map(billItem -> this.getTaxPre(billItem.getTaxPre())).distinct().collect(Collectors.joining("\u3001")) : (StringUtils.equals((CharSequence)metadataBean.getFieldName(), (CharSequence)"zeroTax") ? billItems.stream().map(billItem -> this.getZeroTaxMark(billItem.getZeroTax())).distinct().collect(Collectors.joining("\u3001")) : billItems.stream().map(billItem -> this.getReMark((BillItem)billItem, metadataBean.getFieldName())).distinct().collect(Collectors.joining("\u3001")));
                    sb.append(metadataBean.getFieldDisplayName()).append("[").append(fieldValue).append("]");
                }
                this.appendSpace(sb);
            }
        }
        this.appendSpace(sb);
        if (StringUtils.isNotBlank((CharSequence)rule.getExtRemark())) {
            sb.append(rule.getExtRemark());
        }
        return sb.toString();
    }

    private void appendSpace(StringBuilder sb) {
        if (StringUtils.isNotBlank((CharSequence)sb.toString()) && !StringUtils.endsWith((CharSequence)sb.toString(), (CharSequence)" ")) {
            sb.append(" ");
        }
    }

    private String getReMark(BillInfo billInfo, String fieldName) {
        try {
            return Objects.toString(FiledUtils.getFieldValue((Object)billInfo, fieldName), "");
        }
        catch (ReflectionException e) {
            logger.warn("\u5143\u6570\u636e\u83b7\u53d6\u5b57\u6bb5\u503c\u9519\u8bef:{}", (Object)e.getMessage());
            return "";
        }
    }

    private String getReMark(BillItem billItem, String fieldName) {
        try {
            return Objects.toString(FiledUtils.getFieldValue((Object)billItem, fieldName), "");
        }
        catch (ReflectionException e) {
            logger.warn("\u5143\u6570\u636e\u83b7\u53d6\u5b57\u6bb5\u503c\u9519\u8bef:{}", (Object)e.getMessage());
            return "";
        }
    }

    private String getTaxPre(String taxPre) {
        return StringUtils.equals((CharSequence)taxPre, (CharSequence)"1") ? "\u4eab\u53d7" : "\u4e0d\u4eab\u53d7";
    }

    private String getZeroTaxMark(String zeroTax) {
        return StringUtils.equals((CharSequence)zeroTax, (CharSequence)"0") ? "\u51fa\u53e3\u9000\u7a0e" : (StringUtils.equals((CharSequence)zeroTax, (CharSequence)"1") ? "\u514d\u7a0e" : (StringUtils.equals((CharSequence)zeroTax, (CharSequence)"2") ? "\u4e0d\u5f81\u7a0e" : (StringUtils.equals((CharSequence)zeroTax, (CharSequence)"3") ? "\u666e\u901a\u96f6\u7a0e\u7387" : "\u975e\u96f6\u7a0e\u7387")));
    }

    private String getPriceMethod(PriceMethod priceMethod) {
        return priceMethod == PriceMethod.WITH_TAX ? "\u542b\u7a0e" : "\u4e0d\u542b\u7a0e";
    }
}

