/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.phoenix.split.service.impl;

import com.xforceplus.phoenix.split.domain.ItemAmountInfo;
import com.xforceplus.phoenix.split.model.SplitRule;
import com.xforceplus.phoenix.split.service.impl.DefaultSplitBillItemAmountServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class SplitBillItemByAmountWithTaxServiceImpl
extends DefaultSplitBillItemAmountServiceImpl {
    @Override
    protected void reCalculateAmount(BigDecimal limitAmount, SplitRule rule, ItemAmountInfo itemAmountInfo, ItemAmountInfo result) {
        result.setDiscountWithTax(itemAmountInfo.getDiscountWithTax());
        result.setDiscountWithoutTax(this.calculateAmountWithoutTaxByAmountWithTax(result.getDiscountWithTax(), result.getTaxRate(), BigDecimal.ZERO));
        result.setDiscountTax(this.calculateTaxAmount(result.getDiscountWithTax(), result.getDiscountWithoutTax()));
        if (result.getAmountWithTax().subtract(result.getDiscountWithTax()).compareTo(limitAmount) > 0) {
            BigDecimal splitAmountWithTax = limitAmount.add(result.getDiscountWithTax()).setScale(2, 4);
            BigDecimal splitAmountWithoutTax = this.calculateAmountWithoutTaxByAmountWithTax(splitAmountWithTax, result.getTaxRate(), result.getDeductions());
            BigDecimal splitTaxAmount = this.calculateTaxAmount(splitAmountWithTax, splitAmountWithoutTax);
            result.setAmountWithTax(splitAmountWithTax);
            result.setAmountWithoutTax(splitAmountWithoutTax);
            result.setTaxAmount(splitTaxAmount);
            this.processUnitPriceOrQuantity(rule, result);
        }
    }

    @Override
    protected boolean leftDiscountAmountLtSplitDiscountAmount(ItemAmountInfo itemAmountInfo, ItemAmountInfo result) {
        return itemAmountInfo.getDiscountWithTax().compareTo(result.getDiscountWithTax()) < 0;
    }

    @Override
    protected void processLastItemAmountInfo(ItemAmountInfo itemAmountInfo, boolean hasQuantity) {
        BigDecimal amountWithoutTax = this.calculateAmountWithoutTaxByAmountWithTax(itemAmountInfo.getAmountWithTax(), itemAmountInfo.getTaxRate(), itemAmountInfo.getDeductions());
        BigDecimal taxAmount = this.calculateTaxAmount(itemAmountInfo.getAmountWithTax(), amountWithoutTax);
        BigDecimal discountWithoutTax = this.calculateAmountWithoutTaxByAmountWithTax(itemAmountInfo.getDiscountWithTax(), itemAmountInfo.getTaxRate(), BigDecimal.ZERO);
        BigDecimal discountTax = this.calculateTaxAmount(itemAmountInfo.getDiscountWithTax(), discountWithoutTax);
        itemAmountInfo.setAmountWithoutTax(amountWithoutTax);
        itemAmountInfo.setTaxAmount(taxAmount);
        itemAmountInfo.setDiscountWithoutTax(discountWithoutTax);
        itemAmountInfo.setDiscountTax(discountTax);
        super.processLastItemAmountInfo(itemAmountInfo, hasQuantity);
    }

    private BigDecimal calculateTaxAmount(BigDecimal amountWithTax, BigDecimal amountWithoutTax) {
        return amountWithTax.subtract(amountWithoutTax);
    }

    private BigDecimal calculateAmountWithoutTaxByAmountWithTax(BigDecimal amountWithTax, BigDecimal taxRate, BigDecimal deductions) {
        return amountWithTax.add(deductions.multiply(taxRate)).divide(BigDecimal.ONE.add(taxRate), 2, RoundingMode.HALF_UP);
    }

    @Override
    protected void processErrorAmount(List<ItemAmountInfo> itemAmountInfoList) {
    }

    @Override
    protected ItemAmountInfo splitFirstItemAmountInfo(SplitRule rule, ItemAmountInfo itemAmountInfo, BigDecimal limitAmount) {
        return itemAmountInfo.createItemAmountByAmountWithTax(rule, limitAmount);
    }

    @Override
    protected boolean gtLimitAmount(ItemAmountInfo itemAmountInfo, BigDecimal limitAmount) {
        return itemAmountInfo.getAmountWithTax().subtract(itemAmountInfo.getDiscountWithTax()).compareTo(limitAmount) > 0;
    }

    @Override
    protected void calculateAmountByPriceMethod(ItemAmountInfo splitAmountInfo) {
    }
}

