/*
 * Decompiled with CFR 0.152.
 */
package com.jx.test;

import com.jx.test.MockAutoConfiguration;
import com.jx.test.MockIdGenerator;
import com.jx.test.MockInterceptor;
import java.util.ServiceLoader;
import javax.sql.DataSource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.NONE)
@ContextConfiguration(classes={MockAutoConfiguration.class})
public abstract class AbsSpringContextTest {
    private static final Logger log = LoggerFactory.getLogger(AbsSpringContextTest.class);
    @Autowired
    @Qualifier(value="h2DataSource")
    protected DataSource dataSource;
    @Autowired
    protected MockIdGenerator mockIdGenerator;

    @BeforeAll
    static void init() {
        log.info("init test mock");
        ServiceLoader.load(MockInterceptor.class).forEach(MockInterceptor::preHandler);
    }

    @AfterAll
    static void after() {
        log.info("after test mock");
        ServiceLoader.load(MockInterceptor.class).forEach(MockInterceptor::afterHandler);
    }
}

