/*
 * Decompiled with CFR 0.152.
 */
package com.jx.test;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.jx.test.MockIdGenerator;
import com.jx.test.util.MockUtil;
import java.io.IOException;
import java.util.Properties;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.init.DataSourceInitializer;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.util.StringUtils;

public class MockAutoConfiguration {
    private static final Properties MOCK_PROPERTIES = MockUtil.loadProperties("mock.properties");

    @Bean(name={"h2DataSource"}, destroyMethod="dispose")
    @ConditionalOnMissingBean(value={JdbcConnectionPool.class})
    public JdbcConnectionPool jdbcConnectionPool() {
        return JdbcConnectionPool.create((String)"jdbc:h2:mem:test;MODE=MySql;DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=FALSE;", (String)"sa", (String)"");
    }

    @Primary
    @Bean(name={"sqlSessionFactoryH2"})
    public MybatisSqlSessionFactoryBean sqlSessionFactoryBean(JdbcConnectionPool h2DataSource) throws IOException {
        MybatisSqlSessionFactoryBean sqlSessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sqlSessionFactoryBean.setDataSource((DataSource)h2DataSource);
        sqlSessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(MOCK_PROPERTIES.getProperty("mapperLocations")));
        sqlSessionFactoryBean.setTypeAliasesPackage(MOCK_PROPERTIES.getProperty("typeAliasesPackage"));
        return sqlSessionFactoryBean;
    }

    @Bean
    @ConditionalOnMissingBean(value={MapperScannerConfigurer.class})
    public MapperScannerConfigurer mapperScannerConfigurer() {
        MapperScannerConfigurer mapperScannerConfigurer = new MapperScannerConfigurer();
        mapperScannerConfigurer.setBasePackage(MOCK_PROPERTIES.getProperty("baseMapper"));
        mapperScannerConfigurer.setSqlSessionFactoryBeanName("sqlSessionFactoryH2");
        return mapperScannerConfigurer;
    }

    @Bean
    @ConditionalOnMissingBean(value={MybatisPlusProperties.class})
    public MybatisPlusProperties mybatisPlusProperties() {
        MybatisPlusProperties mybatisPlusProperties = new MybatisPlusProperties();
        mybatisPlusProperties.setTypeAliasesPackage(MOCK_PROPERTIES.getProperty("typeAliasesPackage"));
        mybatisPlusProperties.setMapperLocations(StringUtils.split((String)MOCK_PROPERTIES.getProperty("mapperLocations"), (String)","));
        return mybatisPlusProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={MockIdGenerator.class})
    public MockIdGenerator mockIdGenerator() {
        return new MockIdGenerator();
    }

    @Bean
    public DataSourceInitializer dataSourceInitializer(DataSource dataSource) {
        DataSourceInitializer initializer = new DataSourceInitializer();
        initializer.setDataSource(dataSource);
        initializer.setDatabasePopulator(this.databasePopulator());
        return initializer;
    }

    private DatabasePopulator databasePopulator() {
        ResourceDatabasePopulator popular = new ResourceDatabasePopulator();
        popular.addScripts(new Resource[]{new PathMatchingResourcePatternResolver().getResource(MOCK_PROPERTIES.getProperty("initScript"))});
        popular.setSqlScriptEncoding("UTF-8");
        popular.setIgnoreFailedDrops(true);
        popular.setContinueOnError(false);
        return popular;
    }
}

