/*
 * Decompiled with CFR 0.152.
 */
package com.jx.test.util;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.jx.test.util.ReflectUtil;
import com.ninja_squad.dbsetup.DbSetup;
import com.ninja_squad.dbsetup.DbSetupTracker;
import com.ninja_squad.dbsetup.Operations;
import com.ninja_squad.dbsetup.destination.DataSourceDestination;
import com.ninja_squad.dbsetup.destination.Destination;
import com.ninja_squad.dbsetup.operation.Operation;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public final class MockUtil {
    private static final Logger log = LoggerFactory.getLogger(MockUtil.class);
    private static final DbSetupTracker DB_SETUP_TRACKER = new DbSetupTracker();

    public static <T> void mockData(DataSource h2DataSource, List<T> models) {
        DB_SETUP_TRACKER.launchIfNecessary(new DbSetup((Destination)new DataSourceDestination(h2DataSource), Operations.sequenceOf((Operation[])MockUtil.genInsertSqlOperations(models))));
    }

    public static <T> void mockData(DataSource h2DataSource, T model) {
        MockUtil.mockData(h2DataSource, Collections.singletonList(model));
    }

    public static <T> void mockDataWithOperations(DataSource h2DataSource, List<Operation> operations) {
        DB_SETUP_TRACKER.launchIfNecessary(new DbSetup((Destination)new DataSourceDestination(h2DataSource), Operations.sequenceOf((Operation[])operations.toArray(new Operation[operations.size()]))));
    }

    public static Properties loadAllProperties(String resource) {
        Properties props = new Properties();
        try {
            props = PropertiesLoaderUtils.loadAllProperties((String)resource);
        }
        catch (IOException e) {
            log.error("loadAllProperties {} err", (Object)resource, (Object)e);
        }
        return props;
    }

    public static Properties loadProperties(String resource) {
        Properties props = new Properties();
        try {
            props = PropertiesLoaderUtils.loadProperties((Resource)new PathMatchingResourcePatternResolver().getResource(resource));
        }
        catch (IOException e) {
            log.error("loadAllProperties {} err", (Object)resource, (Object)e);
        }
        return props;
    }

    public static <T> Operation genInsertSql(T model) {
        TableName tableName = model.getClass().getAnnotation(TableName.class);
        if (null == tableName) {
            return null;
        }
        Operations.deleteAllFrom((String)tableName.value());
        Field[] fields = model.getClass().getDeclaredFields();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Field field : fields) {
            Object value;
            if (Modifier.isStatic(field.getModifiers()) || null == (value = ReflectUtil.getFieldValue(model, field.getName()))) continue;
            TableField tableField = field.getAnnotation(TableField.class);
            if (null != tableField) {
                columns.add(tableField.value());
            } else {
                columns.add(field.getName());
            }
            values.add(value);
        }
        return CollectionUtils.isNotEmpty(columns) ? Operations.insertInto((String)tableName.value()).columns(columns.toArray(new String[columns.size()])).values(values.toArray(new Object[values.size()])).build() : null;
    }

    public static <T> Operation[] genInsertSqlOperations(List<T> models) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        for (T model : models) {
            operations.add(MockUtil.genInsertSql(model));
        }
        return operations.toArray(new Operation[operations.size()]);
    }

    private MockUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

