/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entity.TDxRecordInvoice;
import com.reportfrom.wapp.mapper.first.TDxRecordInvoiceMapper;
import com.reportfrom.wapp.request.RecordInvoiceDetailsReq;
import com.reportfrom.wapp.request.RecordInvoiceReq;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.TDxRecordInvoiceService;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TDxRecordInvoiceServiceImpl
extends ServiceImpl<TDxRecordInvoiceMapper, TDxRecordInvoice>
implements TDxRecordInvoiceService {
    @Autowired
    private TDxRecordInvoiceMapper tDxRecordInvoiceMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public PageUtils queryPageRecordInvoice(RecordInvoiceReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        List voList = this.tDxRecordInvoiceMapper.selectRecordInvoiceByParam(map);
        Integer count = this.tDxRecordInvoiceMapper.selectRecordInvoiceCountByParam(map);
        PageUtils rpage = new PageUtils();
        rpage.setList(voList);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void recordInvoiceExport(RecordInvoiceReq params, String token) {
        String fileName = "\u975e\u5546\u4f20\u7968\u6e05\u5355.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List voList = this.tDxRecordInvoiceMapper.selectRecordInvoiceByParam(map);
        String path = this.ftpConfig.getServerSavePath() + new SimpleDateFormat("yyyyMMddhhmmss").format(new Date());
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.FS_INVOICE, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils queryPageRecordInvoiceDeatils(RecordInvoiceDetailsReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        List voList = this.tDxRecordInvoiceMapper.selectDetailsByParam(map);
        Integer count = this.tDxRecordInvoiceMapper.selectDetailsCountByParam(map);
        PageUtils rpage = new PageUtils();
        rpage.setList(voList);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void recordInvoiceDeatilsExport(RecordInvoiceDetailsReq params, String token) {
        String fileName = "\u975e\u5546\u53d1\u7968\u660e\u7ec6.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List voList = this.tDxRecordInvoiceMapper.selectDetailsByParam(map);
        String path = this.ftpConfig.getServerSavePath() + new SimpleDateFormat("yyyyMMddhhmmss").format(new Date());
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.FS_INVOICE_DETAILS, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }
}

