/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entity.TDxRecordInvoice;
import com.reportfrom.wapp.mapper.first.TDxRecordInvoiceMapper;
import com.reportfrom.wapp.request.RecordInvoiceDetailsReq;
import com.reportfrom.wapp.request.RecordInvoicePurcherTaxReq;
import com.reportfrom.wapp.request.RecordInvoiceReq;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.TDxRecordInvoiceService;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TDxRecordInvoiceServiceImpl
extends ServiceImpl<TDxRecordInvoiceMapper, TDxRecordInvoice>
implements TDxRecordInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(TDxRecordInvoiceServiceImpl.class);
    @Autowired
    private TDxRecordInvoiceMapper tDxRecordInvoiceMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public PageUtils queryPageRecordInvoice(RecordInvoiceReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        List voList = this.tDxRecordInvoiceMapper.selectRecordInvoiceByParam(map);
        Integer count = this.tDxRecordInvoiceMapper.selectRecordInvoiceCountByParam(map);
        PageUtils rpage = new PageUtils();
        rpage.setList(voList);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void recordInvoiceExport(RecordInvoiceReq params, String token) {
        String fileName = "\u975e\u5546\u4f20\u7968\u6e05\u5355.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        log.info("\u67e5\u8be2\u5bfc\u51fa\u6570\u636e>>>>>");
        List voList = this.tDxRecordInvoiceMapper.selectRecordInvoiceByParam(map);
        log.info("\u5bfc\u51fa\u6570\u636e\u5171{}\u6761>>>>>", (Object)voList.size());
        String path = this.ftpConfig.getServerSavePath() + new SimpleDateFormat("yyyyMMddhhmmss").format(new Date());
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.FS_INVOICE, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        log.info("\u3010{}\u3011\u6587\u4ef6\u5bfc\u51fa\u8bb0\u5f55\u5f00\u59cb\u540c\u6b65\u5c0f\u94c3\u94db>>>>>", (Object)fileName);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils queryPageRecordInvoiceDeatils(RecordInvoiceDetailsReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        List voList = this.tDxRecordInvoiceMapper.selectDetailsByParam(map);
        Integer count = this.tDxRecordInvoiceMapper.selectDetailsCountByParam(map);
        PageUtils rpage = new PageUtils();
        rpage.setList(voList);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void recordInvoiceDeatilsExport(RecordInvoiceDetailsReq params, String token) {
        String fileName = "\u975e\u5546\u53d1\u7968\u660e\u7ec6.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List voList = this.tDxRecordInvoiceMapper.selectDetailsByParam(map);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.FS_INVOICE_DETAILS, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils purcherTaxQuery(RecordInvoicePurcherTaxReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        List voList = this.tDxRecordInvoiceMapper.selectPurcherTaxByParam(map);
        List countList = this.tDxRecordInvoiceMapper.selectPurcherTaxCountByParam(map);
        int count = countList.size();
        PageUtils rpage = new PageUtils();
        rpage.setList(voList);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count);
        return rpage;
    }

    public void purcherTaxExport(RecordInvoicePurcherTaxReq params, String token) {
        String fileName = "\u8fdb\u9879\u7a0e\u91d1\u6c47\u603b(\u672a\u8ba4\u8bc1).xlsx";
        if ("1".equals(params.getRzhYesorno())) {
            fileName = "\u8fdb\u9879\u7a0e\u91d1\u6c47\u603b(\u5df2\u8ba4\u8bc1).xlsx";
        }
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List voList = this.tDxRecordInvoiceMapper.selectPurcherTaxByParam(map);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.PURCHER_TAX, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }
}

