/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entity.OptionEntity;
import com.reportfrom.wapp.entity.TDxRecordInvoice;
import com.reportfrom.wapp.entityVO.PurcherTaxVO;
import com.reportfrom.wapp.entityVO.RecordInvoiceVO;
import com.reportfrom.wapp.mapper.first.TDxRecordInvoiceMapper;
import com.reportfrom.wapp.request.RecordInvoiceDetailsReq;
import com.reportfrom.wapp.request.RecordInvoicePurcherTaxReq;
import com.reportfrom.wapp.request.RecordInvoiceReq;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.TDxRecordInvoiceService;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import io.micrometer.core.instrument.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TDxRecordInvoiceServiceImpl
extends ServiceImpl<TDxRecordInvoiceMapper, TDxRecordInvoice>
implements TDxRecordInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(TDxRecordInvoiceServiceImpl.class);
    @Autowired
    private TDxRecordInvoiceMapper tDxRecordInvoiceMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public PageUtils queryPageRecordInvoice(RecordInvoiceReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        List voList = this.tDxRecordInvoiceMapper.selectRecordInvoiceByParam(map);
        for (RecordInvoiceVO vo : voList) {
            String taxRate = this.formatPoint(vo.getTaxRate());
            String bussinessType = vo.getBussinessType();
            String taxCodeShow = this.tDxRecordInvoiceMapper.getFeiShangTaxCode(bussinessType + "_" + taxRate);
            if (StringUtils.isEmpty((String)taxCodeShow)) {
                log.info("\u5339\u914d\u5230\u975e\u5546\u4f20\u7968\u7a0e\u7801:{}", (Object)taxCodeShow);
            }
            vo.setTaxCode(taxCodeShow);
            vo.setTaxRate(taxRate);
            HashMap businessInfo = this.tDxRecordInvoiceMapper.getBusinessInfo(vo.getBussinessType());
            if (businessInfo == null) continue;
            vo.setClassA(businessInfo.get("class_a").toString());
            vo.setFunctionGroup(businessInfo.get("function_group").toString());
        }
        Integer count = this.tDxRecordInvoiceMapper.selectRecordInvoiceCountByParam(map);
        PageUtils rpage = new PageUtils();
        rpage.setList(voList);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void recordInvoiceExport(RecordInvoiceReq params, String token) {
        String fileName = "\u975e\u5546\u4f20\u7968\u6e05\u5355.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        log.info("\u67e5\u8be2\u5bfc\u51fa\u6570\u636e>>>>>");
        List voList = this.tDxRecordInvoiceMapper.selectRecordInvoiceByParam(map);
        log.info("\u5bfc\u51fa\u6570\u636e\u5171{}\u6761>>>>>", (Object)voList.size());
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.FS_INVOICE, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        log.info("\u3010{}\u3011\u6587\u4ef6\u5bfc\u51fa\u8bb0\u5f55\u5f00\u59cb\u540c\u6b65\u5c0f\u94c3\u94db>>>>>", (Object)fileName);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils queryPageRecordInvoiceDeatils(RecordInvoiceDetailsReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        List voList = this.tDxRecordInvoiceMapper.selectDetailsByParam(map);
        Integer count = this.tDxRecordInvoiceMapper.selectDetailsCountByParam(map);
        PageUtils rpage = new PageUtils();
        rpage.setList(voList);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void recordInvoiceDeatilsExport(RecordInvoiceDetailsReq params, String token) {
        String fileName = "\u975e\u5546\u53d1\u7968\u660e\u7ec6.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List voList = this.tDxRecordInvoiceMapper.selectDetailsByParam(map);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.FS_INVOICE_DETAILS, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils purcherTaxQuery(RecordInvoicePurcherTaxReq params) {
        List countList;
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        List voList = new ArrayList();
        Integer count = 0;
        if ("1".equals(params.getRzhYesorno())) {
            voList = this.tDxRecordInvoiceMapper.selectPurcherTaxByParam(map);
            countList = this.tDxRecordInvoiceMapper.selectPurcherTaxCountByParam(map);
            count = countList.size();
        } else {
            voList = this.tDxRecordInvoiceMapper.selectPurcherTaxByParam2(map);
            countList = this.tDxRecordInvoiceMapper.selectPurcherTaxCountByParam2(map);
            count = countList.size();
        }
        PageUtils rpage = new PageUtils();
        rpage.setList(voList);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void purcherTaxExport(RecordInvoicePurcherTaxReq params, String token) {
        String fileName = "\u8fdb\u9879\u7a0e\u91d1\u6c47\u603b(\u672a\u8ba4\u8bc1).xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List voList = new ArrayList();
        if ("1".equals(params.getRzhYesorno())) {
            fileName = "\u8fdb\u9879\u7a0e\u91d1\u6c47\u603b(\u5df2\u8ba4\u8bc1).xlsx";
            voList = this.tDxRecordInvoiceMapper.selectPurcherTaxByParam(map);
        } else {
            voList = this.tDxRecordInvoiceMapper.selectPurcherTaxByParam2(map);
        }
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel(voList, (String)ExcelTypeConfig.PURCHER_TAX, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    private String formatTaxCode(PurcherTaxVO entity) {
        String orgType;
        String invoiceType = entity.getInvoiceType();
        if ("1".equals(entity.getFlowType()) && entity.getTaxRate() != null && invoiceType != null) {
            String hostTaxRate = entity.getTaxRate().substring(0, entity.getTaxRate().indexOf(46));
            if (hostTaxRate.isEmpty()) {
                return "";
            }
            String value = invoiceType + '_' + hostTaxRate;
            OptionEntity optionEntity = this.tDxRecordInvoiceMapper.queryHostTaxRate(value);
            if (optionEntity != null && optionEntity.getLabel() != null && StringUtils.isNotEmpty((String)optionEntity.getLabel())) {
                return optionEntity.getLabel();
            }
            return "";
        }
        if ("6".equals(entity.getFlowType())) {
            return entity.getTaxCode();
        }
        if ("7".equals(entity.getFlowType()) && StringUtils.isNotEmpty((String)(orgType = this.tDxRecordInvoiceMapper.selectOrgType(entity.getXfTaxNo(), entity.getXfName()))) && orgType.equals("5") && entity.getTaxRate() != null && invoiceType != null) {
            String hostTaxRate = entity.getTaxRate().substring(0, entity.getTaxRate().indexOf(46));
            if (hostTaxRate.isEmpty()) {
                return "";
            }
            String value = invoiceType + '_' + hostTaxRate;
            OptionEntity optionEntity = this.tDxRecordInvoiceMapper.queryHostTaxRate(value);
            if (optionEntity != null && optionEntity.getLabel() != null && StringUtils.isNotEmpty((String)optionEntity.getLabel())) {
                return optionEntity.getLabel();
            }
            return "";
        }
        if ("2".equals(entity.getFlowType())) {
            String uuid = entity.getInvoiceCode() + entity.getInvoiceNo();
            List costTaxCode = this.tDxRecordInvoiceMapper.getCostTaxCode(uuid);
            if (costTaxCode.size() > 0 && StringUtils.isBlank((String)entity.getTaxRate())) {
                ArrayList<String> listNew = new ArrayList<String>();
                String taxCode = "";
                for (OptionEntity oe : costTaxCode) {
                    if (listNew.contains(oe.getLabel())) continue;
                    listNew.add(oe.getLabel());
                }
                for (String taxCodes : listNew) {
                    taxCode = taxCode + taxCodes + ",";
                }
                if (!taxCode.equals("")) {
                    taxCode = taxCode.substring(0, taxCode.length() - 1);
                }
                return taxCode;
            }
            if (costTaxCode.size() > 0 && ((OptionEntity)costTaxCode.get(0)).getLabel() != null) {
                return ((OptionEntity)costTaxCode.get(0)).getLabel();
            }
            return "";
        }
        return "";
    }

    public void setTaxCode() {
        List datas = this.tDxRecordInvoiceMapper.selectEntityByNull();
        for (PurcherTaxVO vo : datas) {
            vo.setTaxCode(this.formatTaxCode(vo));
            if (StringUtils.isEmpty((String)vo.getTaxCode())) {
                vo.setTaxCode("-1");
            }
            TDxRecordInvoice tDxRecordInvoice = (TDxRecordInvoice)JSON.parseObject((String)JSON.toJSONString((Object)vo), TDxRecordInvoice.class);
            this.tDxRecordInvoiceMapper.updateById((Object)tDxRecordInvoice);
        }
    }

    public String formatPoint(String stringDecimal) {
        BigDecimal aa = new BigDecimal(stringDecimal);
        if (-1 == aa.compareTo(BigDecimal.ONE)) {
            aa = aa.multiply(BigDecimal.valueOf(100L));
        }
        String bigDecimal = aa.setScale(0).toString();
        return bigDecimal;
    }
}

