/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.reportfrom.wapp.entity.OptionEntity;
import com.reportfrom.wapp.entity.QueryRedStatisticDomain;
import com.reportfrom.wapp.entity.ReportClaimRedStatistic;
import com.reportfrom.wapp.entity.ReportClaimStatistic;
import com.reportfrom.wapp.entity.ReportClaimStatisticBeanWithTaxRate;
import com.reportfrom.wapp.entity.TDxRecordInvoice;
import com.reportfrom.wapp.entityVO.PurcherTaxVO;
import com.reportfrom.wapp.mapper.first.ReportClaimRedStatisticMapper;
import com.reportfrom.wapp.mapper.first.ReportClaimStatisticMapper;
import com.reportfrom.wapp.mapper.first.TDxRecordInvoiceMapper;
import com.reportfrom.wapp.mapper.first.TXfBillDeductMapper;
import com.reportfrom.wapp.util.DateUtils;
import io.micrometer.core.instrument.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuartZService {
    private static final Logger log = LoggerFactory.getLogger(QuartZService.class);
    @Autowired
    private TDxRecordInvoiceMapper tDxRecordInvoiceMapper;
    @Autowired
    private ReportClaimStatisticMapper reportClaimStatisticMapper;
    @Autowired
    private ReportClaimRedStatisticMapper reportClaimRedStatisticMapper;
    @Autowired
    private TXfBillDeductMapper tXfBillDeductMapper;

    public void setTaxCode() {
        List datas = this.tDxRecordInvoiceMapper.selectEntityByNull();
        for (PurcherTaxVO vo : datas) {
            vo.setTaxCode(this.formatTaxCode(vo));
            if (StringUtils.isEmpty((String)vo.getTaxCode())) {
                vo.setTaxCode("-1");
            }
            TDxRecordInvoice tDxRecordInvoice = (TDxRecordInvoice)JSON.parseObject((String)JSON.toJSONString((Object)vo), TDxRecordInvoice.class);
            this.tDxRecordInvoiceMapper.updateById((Object)tDxRecordInvoice);
        }
    }

    public void calculation() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_count", (Object)Character.valueOf('0'));
        List datas = this.reportClaimStatisticMapper.selectList((Wrapper)queryWrapper);
        for (ReportClaimStatistic reportClaimStatistic : datas) {
            log.info("\u5f00\u59cb\u8ba1\u7b97\u7d22\u8d54\u7a0e\u52a1\u62a5\u8868\u6e05\u5355.......");
            BigDecimal standardCurrencyAmount = reportClaimStatistic.getStandardCurrencyAmount();
            String dateMonth = reportClaimStatistic.getDateMonth();
            if (dateMonth.length() == 6) {
                ReportClaimStatisticBeanWithTaxRate unsettledDemo;
                ReportClaimStatisticBeanWithTaxRate zeroDemo;
                Map fistAndLastByStringMap = DateUtils.getFistAndLastByString((String)dateMonth, (String)"yyyyMM", (String)"String", null);
                fistAndLastByStringMap.put("blueInvoiceNo", reportClaimStatistic.getBlueInvoiceNo());
                fistAndLastByStringMap.put("supplierNo", reportClaimStatistic.getSupplierNo());
                ReportClaimStatisticBeanWithTaxRate demo = this.tXfBillDeductMapper.selectSumByParams(fistAndLastByStringMap);
                if (demo != null) {
                    reportClaimStatistic.setClaimAmountWithTax(demo.getClaimAmountWithTax());
                    reportClaimStatistic.setClaimTaxAmount(demo.getClaimTaxAmount());
                    reportClaimStatistic.setDifferenceTaxAmount(standardCurrencyAmount.subtract(demo.getClaimTaxAmount()));
                }
                if ((zeroDemo = this.tXfBillDeductMapper.selecetZeroSumByParams(fistAndLastByStringMap)) != null) {
                    reportClaimStatistic.setZeroClaimTaxAmount(zeroDemo.getZeroClaimTaxAmount());
                    reportClaimStatistic.setZeroClaimAmountWithTax(zeroDemo.getZeroClaimAmountWithTax());
                }
                if ((unsettledDemo = this.tXfBillDeductMapper.selectUnsettledSumByParams(fistAndLastByStringMap)) != null) {
                    reportClaimStatistic.setUnsettledTaxAmount(unsettledDemo.getUnsettledTaxAmount());
                    reportClaimStatistic.setUnsettledAmountWithTax(unsettledDemo.getUnsettledAmountWithTax());
                }
                List list = this.tXfBillDeductMapper.selectRedStatisticOrderByMonth(fistAndLastByStringMap);
                for (QueryRedStatisticDomain queryRedDomin : list) {
                    QueryWrapper wrapper = new QueryWrapper();
                    ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"date_month", (Object)DateUtils.format((Date)queryRedDomin.getDeductDate(), (String)"yyyyMM"))).eq((Object)"blue_invoice_no", (Object)reportClaimStatistic.getBlueInvoiceNo())).eq((Object)"supplier_no", (Object)reportClaimStatistic.getSupplierNo());
                    ReportClaimRedStatistic redStatistic = (ReportClaimRedStatistic)this.reportClaimRedStatisticMapper.selectOne((Wrapper)wrapper);
                    if (redStatistic == null) {
                        ReportClaimRedStatistic reportClaimRedStatistic = new ReportClaimRedStatistic();
                        reportClaimRedStatistic.setSupplierNo(reportClaimStatistic.getSupplierNo());
                        reportClaimRedStatistic.setBlueInvoiceNo(reportClaimStatistic.getBlueInvoiceNo());
                        reportClaimRedStatistic.setDateMonth(DateUtils.format((Date)queryRedDomin.getDeductDate(), (String)"yyyyMM"));
                        reportClaimRedStatistic.setApplyRedNotificationTaxAmount(queryRedDomin.getApplyRedNotificationTaxAmount());
                        reportClaimRedStatistic.setApplyRedNotificationAmountWithTax(queryRedDomin.getApplyRedNotificationAmountWithTax());
                        this.reportClaimRedStatisticMapper.insert((Object)reportClaimRedStatistic);
                        continue;
                    }
                    redStatistic.setApplyRedNotificationTaxAmount(queryRedDomin.getApplyRedNotificationTaxAmount());
                    redStatistic.setApplyRedNotificationAmountWithTax(queryRedDomin.getApplyRedNotificationAmountWithTax());
                    this.reportClaimRedStatisticMapper.updateById((Object)redStatistic);
                }
                List queryList = this.tXfBillDeductMapper.selectDelSumByParams(fistAndLastByStringMap);
                for (QueryRedStatisticDomain queryRedDomin : queryList) {
                    QueryWrapper wrapper = new QueryWrapper();
                    ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"date_month", (Object)DateUtils.format((Date)queryRedDomin.getDeductDate(), (String)"yyyyMM"))).eq((Object)"blue_invoice_no", (Object)reportClaimStatistic.getBlueInvoiceNo())).eq((Object)"supplier_no", (Object)reportClaimStatistic.getSupplierNo());
                    ReportClaimRedStatistic redStatistic = (ReportClaimRedStatistic)this.reportClaimRedStatisticMapper.selectOne((Wrapper)wrapper);
                    if (redStatistic == null) {
                        ReportClaimRedStatistic reportClaimRedStatistic = new ReportClaimRedStatistic();
                        reportClaimRedStatistic.setSupplierNo(reportClaimStatistic.getSupplierNo());
                        reportClaimRedStatistic.setBlueInvoiceNo(reportClaimStatistic.getBlueInvoiceNo());
                        reportClaimRedStatistic.setDateMonth(DateUtils.format((Date)queryRedDomin.getDeductDate(), (String)"yyyyMM"));
                        reportClaimRedStatistic.setReverseRedNotificationTaxAmount(queryRedDomin.getReverseRedNotificationTaxAmount());
                        reportClaimRedStatistic.setReverseRedNotificationAmountWithTax(queryRedDomin.getReverseRedNotificationAmountWithTax());
                        this.reportClaimRedStatisticMapper.insert((Object)reportClaimRedStatistic);
                        continue;
                    }
                    redStatistic.setReverseRedNotificationTaxAmount(queryRedDomin.getReverseRedNotificationTaxAmount());
                    redStatistic.setReverseRedNotificationAmountWithTax(queryRedDomin.getReverseRedNotificationAmountWithTax());
                    this.reportClaimRedStatisticMapper.updateById((Object)redStatistic);
                }
            }
            reportClaimStatistic.setIsCount("1");
            this.reportClaimStatisticMapper.updateById((Object)reportClaimStatistic);
        }
    }

    private String formatTaxCode(PurcherTaxVO entity) {
        String orgType;
        String invoiceType = entity.getInvoiceType();
        if ("1".equals(entity.getFlowType()) && entity.getTaxRate() != null && invoiceType != null) {
            String hostTaxRate = entity.getTaxRate().substring(0, entity.getTaxRate().indexOf(46));
            if (hostTaxRate.isEmpty()) {
                return "";
            }
            String value = invoiceType + '_' + hostTaxRate;
            OptionEntity optionEntity = this.tDxRecordInvoiceMapper.queryHostTaxRate(value);
            if (optionEntity != null && optionEntity.getLabel() != null && StringUtils.isNotEmpty((String)optionEntity.getLabel())) {
                return optionEntity.getLabel();
            }
            return "";
        }
        if ("6".equals(entity.getFlowType())) {
            return entity.getTaxCode();
        }
        if ("7".equals(entity.getFlowType()) && StringUtils.isNotEmpty((String)(orgType = this.tDxRecordInvoiceMapper.selectOrgType(entity.getXfTaxNo(), entity.getXfName()))) && orgType.equals("5") && entity.getTaxRate() != null && invoiceType != null) {
            String hostTaxRate = entity.getTaxRate().substring(0, entity.getTaxRate().indexOf(46));
            if (hostTaxRate.isEmpty()) {
                return "";
            }
            String value = invoiceType + '_' + hostTaxRate;
            OptionEntity optionEntity = this.tDxRecordInvoiceMapper.queryHostTaxRate(value);
            if (optionEntity != null && optionEntity.getLabel() != null && StringUtils.isNotEmpty((String)optionEntity.getLabel())) {
                return optionEntity.getLabel();
            }
            return "";
        }
        if ("2".equals(entity.getFlowType())) {
            String uuid = entity.getInvoiceCode() + entity.getInvoiceNo();
            List costTaxCode = this.tDxRecordInvoiceMapper.getCostTaxCode(uuid);
            if (costTaxCode.size() > 0 && StringUtils.isBlank((String)entity.getTaxRate())) {
                ArrayList<String> listNew = new ArrayList<String>();
                String taxCode = "";
                for (OptionEntity oe : costTaxCode) {
                    if (listNew.contains(oe.getLabel())) continue;
                    listNew.add(oe.getLabel());
                }
                for (String taxCodes : listNew) {
                    taxCode = taxCode + taxCodes + ",";
                }
                if (!taxCode.equals("")) {
                    taxCode = taxCode.substring(0, taxCode.length() - 1);
                }
                return taxCode;
            }
            if (costTaxCode.size() > 0 && ((OptionEntity)costTaxCode.get(0)).getLabel() != null) {
                return ((OptionEntity)costTaxCode.get(0)).getLabel();
            }
            return "";
        }
        return "";
    }
}

