/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.mapper.second.ReportChcJvInvoiceMapper;
import com.reportfrom.wapp.request.ReportChcJvInvoiceRequest;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.ReportChcJvInvoiceService;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DS(value="second")
public class ReportChcJvInvoiceServiceImpl
implements ReportChcJvInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(ReportChcJvInvoiceServiceImpl.class);
    @Autowired
    private ReportChcJvInvoiceMapper reportChcJvInvoiceMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public PageUtils queryPage(ReportChcJvInvoiceRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        if (!StringUtils.isEmpty((String)params.getBatch())) {
            String batch = params.getBatch() + "01";
            map.put("startTime", LocalDate.parse(batch, DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.firstDayOfMonth()) + " 00:00:00.000");
            map.put("endTime", LocalDate.parse(batch, DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.lastDayOfMonth()) + " 23:59:59.999");
        }
        Integer count = this.reportChcJvInvoiceMapper.selectAllCountByParam(map);
        List reportChcJvInvoices = null;
        reportChcJvInvoices = null != count && count > 0 ? this.reportChcJvInvoiceMapper.selectMapsByParams(map) : new ArrayList(0);
        PageUtils rpage = new PageUtils();
        rpage.setList(reportChcJvInvoices);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void produceReportChcJvInvoice(ReportChcJvInvoiceRequest params, String token) {
        String fileName = "CHC&JV\u84dd\u5b57\u53d1\u7968\u6e05\u5355_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")) + ".xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        if (!StringUtils.isEmpty((String)params.getBatch())) {
            String batch = params.getBatch() + "01";
            map.put("startTime", LocalDate.parse(batch, DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.firstDayOfMonth()) + " 00:00:00.000");
            map.put("endTime", LocalDate.parse(batch, DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.lastDayOfMonth()) + " 23:59:59.999");
        }
        List rList = this.reportChcJvInvoiceMapper.selectMapsByParams(map);
        ArrayList<List> list = new ArrayList<List>();
        list.add(rList);
        List cjiList = this.reportChcJvInvoiceMapper.queryInvoice(map);
        list.add(cjiList);
        String path = this.ftpConfig.getServerSavePath() + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + "/";
        ExcelUtils.createExcel(list, (String)ExcelTypeConfig.REPORT_CHC_JV_INVOICE_QUERY, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("token", token);
        parmMap.put("condition", condition);
        parmMap.put("path", path);
        parmMap.put("fileName", fileName);
        String s = JSON.toJSONString(parmMap);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }
}

