/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entityVO.ReportJvChcInterInvoiceVO;
import com.reportfrom.wapp.mapper.first.ReportJvChcInterInvoiceMapper;
import com.reportfrom.wapp.request.ReportJvChcInterInvoiceRequest;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.ReportJvChcInterInvoiceService;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@DS(value="first")
public class ReportJvChcInterInvoiceServiceImpl
implements ReportJvChcInterInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(ReportJvChcInterInvoiceServiceImpl.class);
    @Autowired
    private ReportJvChcInterInvoiceMapper reportJvChcInterInvoiceMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public PageUtils queryPage(ReportJvChcInterInvoiceRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        if (!StringUtils.isEmpty((String)params.getInvoiceDate())) {
            map.put("startInvoiceDate", LocalDate.parse(params.getInvoiceDate(), DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.firstDayOfMonth()) + " 00:00:00.000");
            map.put("endInvoiceDate", LocalDate.parse(params.getInvoiceDate(), DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.lastDayOfMonth()) + " 23:59:59.999");
        }
        if (!StringUtils.isEmpty((String)params.getAuthDate())) {
            map.put("startAuthDate", LocalDate.parse(params.getAuthDate(), DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.firstDayOfMonth()) + " 00:00:00.000");
            map.put("endAuthDate", LocalDate.parse(params.getAuthDate(), DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.lastDayOfMonth()) + " 23:59:59.999");
        }
        if (!StringUtils.isEmpty((String)params.getRemark())) {
            map.put("remark", "%" + params.getRemark() + "%");
        }
        Integer count = this.reportJvChcInterInvoiceMapper.selectAllCountByParam(map);
        List reportInvoices = null;
        reportInvoices = null != count && count > 0 ? this.reportJvChcInterInvoiceMapper.selectMapsByParams(map) : new ArrayList(0);
        PageUtils rpage = new PageUtils();
        rpage.setList(reportInvoices);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void produceReportJvChcInterInvoice(ReportJvChcInterInvoiceRequest params, String token) {
        String fileName = "JV-CHC\u5185\u90e8\u53d1\u7968\u62a5\u8868_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")) + ".xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        if (!StringUtils.isEmpty((String)params.getInvoiceDate())) {
            map.put("startInvoiceDate", LocalDate.parse(params.getInvoiceDate(), DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.firstDayOfMonth()) + " 00:00:00.000");
            map.put("endInvoiceDate", LocalDate.parse(params.getInvoiceDate(), DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.lastDayOfMonth()) + " 23:59:59.999");
        }
        if (!StringUtils.isEmpty((String)params.getAuthDate())) {
            map.put("startAuthDate", LocalDate.parse(params.getAuthDate(), DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.firstDayOfMonth()) + " 00:00:00.000");
            map.put("endAuthDate", LocalDate.parse(params.getAuthDate(), DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.lastDayOfMonth()) + " 23:59:59.999");
        }
        if (!StringUtils.isEmpty((String)params.getRemark())) {
            map.put("remark", "%" + params.getRemark() + "%");
        }
        List list = this.reportJvChcInterInvoiceMapper.selectMapsByParams(map);
        ReportJvChcInterInvoiceServiceImpl.dealReportJvChcInterInvoiceVOs((List)list);
        String path = this.ftpConfig.getServerSavePath() + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + "/";
        ExcelUtils.createExcel((List)list, (String)ExcelTypeConfig.REPORT_JV_CHC_INTER_INVOICE_QUERY, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("token", token);
        parmMap.put("condition", condition);
        parmMap.put("path", path);
        parmMap.put("fileName", fileName);
        String s = JSON.toJSONString(parmMap);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    private static void dealReportJvChcInterInvoiceVOs(List<ReportJvChcInterInvoiceVO> list) {
        if (list != null && list.size() > 0) {
            list.forEach(t -> {
                t.setInvoiceType(ReportJvChcInterInvoiceServiceImpl.getInvoiceTypeName((String)t.getInvoiceType()));
                t.setQsStatus(ReportJvChcInterInvoiceServiceImpl.getQsStatusName((String)t.getQsStatus()));
                t.setAuthStatus(ReportJvChcInterInvoiceServiceImpl.getAuthStatusName((String)t.getAuthStatus()));
                t.setInvoiceStatus(ReportJvChcInterInvoiceServiceImpl.getInvoiceStatusName((String)t.getInvoiceStatus()));
                if (!StringUtils.isEmpty((String)t.getInvoiceDate())) {
                    t.setInvoiceDate(t.getInvoiceDate().substring(0, 10));
                }
                if (!StringUtils.isEmpty((String)t.getQsDate())) {
                    t.setQsDate(t.getQsDate().substring(0, 10));
                }
                if (!StringUtils.isEmpty((String)t.getAuthDate())) {
                    t.setAuthDate(t.getAuthDate().substring(0, 10));
                }
            });
        }
    }

    private static String getInvoiceTypeName(String invoiceTypeCode) {
        if (!StringUtils.isEmpty((String)invoiceTypeCode)) {
            switch (invoiceTypeCode) {
                case "": {
                    return "";
                }
            }
        }
        return invoiceTypeCode;
    }

    private static String getQsStatusName(String qsStatusCode) {
        if (!StringUtils.isEmpty((String)qsStatusCode)) {
            switch (qsStatusCode) {
                case "0": {
                    return "\u672a\u7b7e\u6536";
                }
                case "1": {
                    return "\u5df2\u7b7e\u6536";
                }
            }
        }
        return "\u672a\u7b7e\u6536";
    }

    private static String getAuthStatusName(String authStatusCode) {
        if (!StringUtils.isEmpty((String)authStatusCode)) {
            switch (authStatusCode) {
                case "0": {
                    return "\u672a\u8ba4\u8bc1";
                }
                case "1": {
                    return "\u5df2\u52fe\u9009\u672a\u786e\u8ba4";
                }
                case "2": {
                    return "\u5df2\u786e\u8ba4";
                }
                case "3": {
                    return "\u5df2\u53d1\u9001\u8ba4\u8bc1";
                }
                case "4": {
                    return "\u8ba4\u8bc1\u6210\u529f";
                }
                case "5": {
                    return "\u8ba4\u8bc1\u5931\u8d25";
                }
            }
            return "\u672a\u8ba4\u8bc1";
        }
        return "\u672a\u8ba4\u8bc1";
    }

    private static String getInvoiceStatusName(String invoiceStatusCode) {
        if (!StringUtils.isEmpty((String)invoiceStatusCode)) {
            switch (invoiceStatusCode) {
                case "0": {
                    return "\u6b63\u5e38";
                }
                case "1": {
                    return "\u5931\u63a7";
                }
                case "2": {
                    return "\u4f5c\u5e9f";
                }
                case "3": {
                    return "\u7ea2\u51b2";
                }
                case "4": {
                    return "\u5f02\u5e38";
                }
                case "5": {
                    return "\u84dd\u51b2";
                }
            }
            return "\u5f02\u5e38";
        }
        return "\u5f02\u5e38";
    }
}

