/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.fastjson.JSON;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entityVO.ReportMTRJvInterInvoiceVO;
import com.reportfrom.wapp.request.ReportMTRJvInterInvoiceRequest;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.ReportMTRJvInterInvoiceService;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportMTRJvInterInvoiceServiceImpl
implements ReportMTRJvInterInvoiceService {
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public PageUtils queryPage(ReportMTRJvInterInvoiceRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        Integer count = 1;
        ArrayList<ReportMTRJvInterInvoiceVO> list = new ArrayList<ReportMTRJvInterInvoiceVO>(1);
        list.add(new ReportMTRJvInterInvoiceVO());
        PageUtils rpage = new PageUtils();
        rpage.setList(list);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void produce(ReportMTRJvInterInvoiceRequest params, String token) {
        String fileName = "MTR JV-JV\u5185\u90e8\u53d1\u7968\u62a5\u8868_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")) + ".xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        ArrayList<ReportMTRJvInterInvoiceVO> list = new ArrayList<ReportMTRJvInterInvoiceVO>(1);
        list.add(new ReportMTRJvInterInvoiceVO());
        String path = this.ftpConfig.getServerSavePath() + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + "/";
        ExcelUtils.createExcel(list, (String)ExcelTypeConfig.REPORT_MTR_JV_INTER_INVOICE_QUERY, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("token", token);
        parmMap.put("condition", condition);
        parmMap.put("path", path);
        parmMap.put("fileName", fileName);
        String s = JSON.toJSONString(parmMap);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }
}

