/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entity.TDxRecordInvoice;
import com.reportfrom.wapp.entity.TXfBillDeduct;
import com.reportfrom.wapp.entity.TXfBlueRelation;
import com.reportfrom.wapp.entity.TXfRedNotification;
import com.reportfrom.wapp.entityVO.ClaimantVO;
import com.reportfrom.wapp.mapper.first.TDxRecordInvoiceMapper;
import com.reportfrom.wapp.mapper.first.TXfBillDeductMapper;
import com.reportfrom.wapp.mapper.first.TXfRedNotificationMapper;
import com.reportfrom.wapp.request.ClaimantQueryReq;
import com.reportfrom.wapp.request.EDPQueryReq;
import com.reportfrom.wapp.request.ProtocolQueryReq;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.TXfBillDeductService;
import com.reportfrom.wapp.util.DateUtils;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TXfBillDeductServiceImpl
extends ServiceImpl<TXfBillDeductMapper, TXfBillDeduct>
implements TXfBillDeductService {
    @Autowired
    private TXfBillDeductMapper tXfBillDeductMapper;
    @Autowired
    private TXfRedNotificationMapper tXfRedNotificationMapper;
    @Autowired
    private TDxRecordInvoiceMapper tDxRecordInvoiceMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public PageUtils queryPageByParamsType3(EDPQueryReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        List list = this.tXfBillDeductMapper.selectByParamsType3(map);
        Integer count = this.tXfBillDeductMapper.selectCountByParamsType3(map);
        PageUtils rpage = new PageUtils();
        rpage.setList(list);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void exportByParamsType3(EDPQueryReq params, String token) {
        String fileName = "EPD\u7efc\u5408\u67e5\u8be2\u62a5\u8868.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List list = this.tXfBillDeductMapper.selectByParamsType3(map);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)list, (String)ExcelTypeConfig.EPD_REPORT, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils queryPageByParamsType2(ProtocolQueryReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        List list = this.tXfBillDeductMapper.selectByParamsType2(map);
        Integer count = this.tXfBillDeductMapper.selectCountByParamsType2(map);
        PageUtils rpage = new PageUtils();
        rpage.setList(list);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void exportByParamsType2(ProtocolQueryReq params, String token) {
        String fileName = "\u534f\u8bae\u7efc\u5408\u67e5\u8be2\u62a5\u8868.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List list = this.tXfBillDeductMapper.selectByParamsType2(map);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)list, (String)ExcelTypeConfig.PROTOCOL_QUERY, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils queryPageByParamsType1(ClaimantQueryReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        if (StringUtils.isNotEmpty((String)params.getDeductDate())) {
            List<String> strings = Arrays.asList(params.getDeductDate().split(","));
            map.put("startDeductDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(0), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            map.put("endDeductDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(1), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
        }
        List list = this.tXfBillDeductMapper.selectByParamsType1(map);
        int count = this.tXfBillDeductMapper.selectCountByParamsType1(map);
        for (ClaimantVO vo : list) {
            List redNotifications = this.tXfBillDeductMapper.selectRedNotificationBySettlementNo(vo.getRefSettlementNo());
            if (CollectionUtils.isEmpty((Collection)redNotifications)) continue;
            Set applyingStatusList = redNotifications.stream().filter(Objects::nonNull).map(TXfRedNotification::getApplyingStatus).collect(Collectors.toSet());
            Set redNotificationNoList = redNotifications.stream().filter(Objects::nonNull).map(TXfRedNotification::getRedNotificationNo).collect(Collectors.toSet());
            Set createDateList = redNotifications.stream().filter(Objects::nonNull).map(TXfRedNotification::getCreateDate).collect(Collectors.toSet());
            Set rpproveStatusList = redNotifications.stream().filter(Objects::nonNull).map(TXfRedNotification::getApproveStatus).collect(Collectors.toSet());
            Set updateDateList = redNotifications.stream().filter(Objects::nonNull).map(TXfRedNotification::getUpdateDate).collect(Collectors.toSet());
            vo.setApplyingStatus(String.join((CharSequence)",", applyingStatusList.stream().map(String::valueOf).collect(Collectors.toList())));
            vo.setCreateDate(String.join((CharSequence)",", createDateList.stream().map(String::valueOf).collect(Collectors.toList())));
            vo.setUpdateDate(String.join((CharSequence)",", updateDateList.stream().map(String::valueOf).collect(Collectors.toList())));
            if (CollectionUtils.isEmpty(rpproveStatusList) && rpproveStatusList.contains("4")) {
                vo.setIsRed("1");
            } else {
                vo.setIsRed("0");
            }
            if (CollectionUtils.isEmpty(redNotificationNoList)) continue;
            vo.setRedNotificationNo(String.join((CharSequence)",", redNotificationNoList.stream().map(String::valueOf).collect(Collectors.toList())));
            List dxRecordInvoices = this.tXfBillDeductMapper.selectRecordInvoiceByRedNotificationNo(redNotificationNoList);
            if (CollectionUtils.isEmpty((Collection)dxRecordInvoices)) continue;
            Set redInvoiceNo = dxRecordInvoices.stream().filter(Objects::nonNull).map(TDxRecordInvoice::getInvoiceNo).collect(Collectors.toSet());
            vo.setRedInvoiceNo(String.join((CharSequence)",", redInvoiceNo.stream().map(String::valueOf).collect(Collectors.toList())));
            List blueRelations = this.tXfBillDeductMapper.selectBlueRelationByInvoiceNoCode(dxRecordInvoices);
            if (!CollectionUtils.isEmpty((Collection)blueRelations)) {
                vo.setIsBlue("1");
                Set invoiceNoList = blueRelations.stream().filter(Objects::nonNull).map(TXfBlueRelation::getBlueInvoiceNo).collect(Collectors.toSet());
                vo.setBlueInvoiceNo(String.join((CharSequence)",", invoiceNoList.stream().map(String::valueOf).collect(Collectors.toList())));
                continue;
            }
            vo.setIsBlue("0");
        }
        PageUtils rpage = new PageUtils();
        rpage.setList(list);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count);
        return rpage;
    }

    public void exportByParamsType1(ClaimantQueryReq params, String token) {
        String fileName = "\u7d22\u8d54\u7efc\u5408\u67e5\u8be2\u62a5\u8868.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        if (StringUtils.isNotEmpty((String)params.getDeductDate())) {
            List<String> strings = Arrays.asList(params.getDeductDate().split(","));
            map.put("startDeductDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(0), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            map.put("endDeductDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(1), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
        }
        List list = this.tXfBillDeductMapper.selectByParamsType1(map);
        for (ClaimantVO vo : list) {
            List redNotifications = this.tXfBillDeductMapper.selectRedNotificationBySettlementNo(vo.getRefSettlementNo());
            if (CollectionUtils.isEmpty((Collection)redNotifications)) continue;
            Set applyingStatusList = redNotifications.stream().filter(Objects::nonNull).map(TXfRedNotification::getApplyingStatus).collect(Collectors.toSet());
            Set redNotificationNoList = redNotifications.stream().filter(Objects::nonNull).map(TXfRedNotification::getRedNotificationNo).collect(Collectors.toSet());
            Set createDateList = redNotifications.stream().filter(Objects::nonNull).map(TXfRedNotification::getCreateDate).collect(Collectors.toSet());
            Set rpproveStatusList = redNotifications.stream().filter(Objects::nonNull).map(TXfRedNotification::getApproveStatus).collect(Collectors.toSet());
            Set updateDateList = redNotifications.stream().filter(Objects::nonNull).map(TXfRedNotification::getUpdateDate).collect(Collectors.toSet());
            vo.setApplyingStatus(String.join((CharSequence)",", applyingStatusList.stream().map(String::valueOf).collect(Collectors.toList())));
            vo.setCreateDate(String.join((CharSequence)",", createDateList.stream().map(String::valueOf).collect(Collectors.toList())));
            vo.setUpdateDate(String.join((CharSequence)",", updateDateList.stream().map(String::valueOf).collect(Collectors.toList())));
            if (CollectionUtils.isEmpty(rpproveStatusList) && rpproveStatusList.contains("4")) {
                vo.setIsRed("1");
            } else {
                vo.setIsRed("0");
            }
            if (CollectionUtils.isEmpty(redNotificationNoList)) continue;
            vo.setRedNotificationNo(String.join((CharSequence)",", redNotificationNoList.stream().map(String::valueOf).collect(Collectors.toList())));
            List dxRecordInvoices = this.tXfBillDeductMapper.selectRecordInvoiceByRedNotificationNo(redNotificationNoList);
            if (CollectionUtils.isEmpty((Collection)dxRecordInvoices)) continue;
            Set redInvoiceNo = dxRecordInvoices.stream().filter(Objects::nonNull).map(TDxRecordInvoice::getInvoiceNo).collect(Collectors.toSet());
            vo.setRedInvoiceNo(String.join((CharSequence)",", redInvoiceNo.stream().map(String::valueOf).collect(Collectors.toList())));
            List blueRelations = this.tXfBillDeductMapper.selectBlueRelationByInvoiceNoCode(dxRecordInvoices);
            if (!CollectionUtils.isEmpty((Collection)blueRelations)) {
                vo.setIsBlue("1");
                Set invoiceNoList = blueRelations.stream().filter(Objects::nonNull).map(TXfBlueRelation::getBlueInvoiceNo).collect(Collectors.toSet());
                vo.setBlueInvoiceNo(String.join((CharSequence)",", invoiceNoList.stream().map(String::valueOf).collect(Collectors.toList())));
                continue;
            }
            vo.setIsBlue("0");
        }
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)list, (String)ExcelTypeConfig.CLAIMANT_QUERY, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }
}

