/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entity.TXfSellerInvoice;
import com.reportfrom.wapp.mapper.second.TXfSellerInvoiceMapper;
import com.reportfrom.wapp.request.SellerInvoiceRequest;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.TXfSellerInvoiceService;
import com.reportfrom.wapp.util.DateUtils;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DS(value="second")
public class TXfSellerInvoiceServiceImpl
extends ServiceImpl<TXfSellerInvoiceMapper, TXfSellerInvoice>
implements TXfSellerInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(TXfSellerInvoiceServiceImpl.class);
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private TXfSellerInvoiceMapper tXfSellerInvoiceMapper;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public PageUtils querySuccessInvoicee(SellerInvoiceRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        if (StringUtils.isNotEmpty((String)params.getPaperDrewDate())) {
            List<String> strings = Arrays.asList(params.getPaperDrewDate().split(","));
            map.put("startTime", strings.get(0));
            map.put("endTime", strings.get(1));
        }
        List tXfSellerInvoices = this.tXfSellerInvoiceMapper.querySuccessInvoicee(map);
        Integer count = this.tXfSellerInvoiceMapper.querySuccessInvoiceCount(map);
        PageUtils page = new PageUtils();
        page.setList(tXfSellerInvoices);
        page.setCurrPage(params.getCurrPage().intValue());
        page.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        page.setTotalPage(totalpage);
        page.setTotalCount(count.intValue());
        return page;
    }

    public void exportSuccessInvoice(SellerInvoiceRequest params, String token) {
        String fileName = "CHC\u5f00\u7968\u6c47\u603b\u62a5\u8868.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        if (StringUtils.isNotEmpty((String)params.getPaperDrewDate())) {
            List<String> strings = Arrays.asList(params.getPaperDrewDate().split(","));
            map.put("startTime", strings.get(0));
            map.put("endTime", strings.get(1));
        }
        List tXfSellerInvoices = this.tXfSellerInvoiceMapper.querySuccessInvoicee(map);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)tXfSellerInvoices, (String)ExcelTypeConfig.CHC_SELLER_INVOICE, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils querySuccessRedInvoicee(SellerInvoiceRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        map.put("isRed", true);
        if (StringUtils.isNotEmpty((String)params.getPaperDrewDate())) {
            List<String> strings = Arrays.asList(params.getPaperDrewDate().split(","));
            map.put("startTime", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(0), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            map.put("endTime", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(1), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
        }
        List tXfSellerInvoices = this.tXfSellerInvoiceMapper.querySuccessInvoicee(map);
        Integer count = this.tXfSellerInvoiceMapper.querySuccessInvoiceCount(map);
        PageUtils page = new PageUtils();
        page.setList(tXfSellerInvoices);
        page.setCurrPage(params.getCurrPage().intValue());
        page.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        page.setTotalPage(totalpage);
        page.setTotalCount(count.intValue());
        return new PageUtils(tXfSellerInvoices);
    }

    public void exportSuccessRedInvoice(SellerInvoiceRequest params, String token) {
        String fileName = "CHC\u5f00\u5177\u7ea2\u7968\u62a5\u8868.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("isRed", true);
        if (StringUtils.isNotEmpty((String)params.getPaperDrewDate())) {
            List<String> strings = Arrays.asList(params.getPaperDrewDate().split(","));
            map.put("startTime", strings.get(0));
            map.put("endTime", strings.get(1));
        }
        List tXfSellerInvoices = this.tXfSellerInvoiceMapper.querySuccessInvoicee(map);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)tXfSellerInvoices, (String)ExcelTypeConfig.CHC_SELLER_RED_INVOICE, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils queryInvoiceItemMsg(SellerInvoiceRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        List list = this.tXfSellerInvoiceMapper.selectMapsByParams(map);
        Integer count = this.tXfSellerInvoiceMapper.selectCountByParams(map);
        PageUtils page = new PageUtils();
        page.setList(list);
        page.setCurrPage(params.getCurrPage().intValue());
        page.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        page.setTotalPage(totalpage);
        page.setTotalCount(count.intValue());
        return page;
    }

    public void exportExcelByTime(SellerInvoiceRequest params, String token) {
        String fileName = "\u52a0\u8ba1\u6263\u9664\u519c\u4ea7\u54c1\u5f00\u7968\u660e\u7ec6\u6e05\u5355.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List invoiceParams = this.tXfSellerInvoiceMapper.selectMapsByParams(map);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)invoiceParams, (String)ExcelTypeConfig.RECORD_INVOICE, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }
}

