/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.reportfrom.wapp.handler.ExportHandleerEnum;
import com.reportfrom.wapp.handler.IExportHandler;
import com.reportfrom.wapp.service.BaseReportExportService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Component;

@Component
public class ExceptionReportExportHandler
implements IExportHandler {
    private static final Logger log = LoggerFactory.getLogger(ExceptionReportExportHandler.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public void doExport(Message<String> message, String messageId) {
        String payload = (String)message.getPayload();
        try {
            Map map = (Map)this.objectMapper.readValue(payload, Map.class);
            this.baseReportExportService.doExport(map);
        }
        catch (Exception e) {
            log.error("\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public String handlerName() {
        return ExportHandleerEnum.EXCEPTION_REPORT.name();
    }
}

