/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.quartz;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.reportfrom.wapp.entity.ReportInvoice;
import com.reportfrom.wapp.mapper.first.JvChcInvoiceSyncMapper;
import com.reportfrom.wapp.mapper.first.ReportInvoiceDetailMapper;
import com.reportfrom.wapp.mapper.first.ReportInvoiceMapper;
import com.reportfrom.wapp.quartz.JvChcInvoiceSyncQuartz;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class JvChcInvoiceSyncQuartz {
    private static final Logger log = LoggerFactory.getLogger(JvChcInvoiceSyncQuartz.class);
    @Autowired
    private JvChcInvoiceSyncMapper jvChcInvoiceSyncMapper;
    @Autowired
    private ReportInvoiceMapper reportInvoiceMapper;
    @Autowired
    private ReportInvoiceDetailMapper reportInvoiceDetailMapper;
    @Value(value="${quartz.jv.chc.invoiceSyncQuartz.pageSize}")
    private int pageSize;
    private static final Pattern IC_SELLLER_STORE_NO_REGEX = Pattern.compile("[0-9]{2,}\u95e8?\u5e97");
    private static final Pattern IC_SELLLER_STORE_NO_REGEX1 = Pattern.compile("[0-9]+");

    @Scheduled(cron="${quartz.jv.chc.invoiceSyncQuartz.cron}")
    public void invoiceSync() {
        List invoiceList;
        log.info("\u540c\u6b65 t_dx_record_invoice \u5230 report_invoice \u5f00\u59cb");
        String startTimeStr = "";
        LocalDateTime startTime = null;
        if (!StringUtils.isEmpty((String)startTimeStr)) {
            startTime = LocalDateTime.parse(startTimeStr, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
        }
        LocalDateTime endTime = LocalDateTime.now().minusMinutes(2L);
        if (startTime != null && endTime.compareTo(startTime) <= 0) {
            log.warn("\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u5f02\u5e38\uff0c\u540c\u6b65\u63a5\u6536");
            return;
        }
        1 dateParams = new /* Unavailable Anonymous Inner Class!! */;
        int currPage = 0;
        do {
            log.info("\u540c\u6b65 t_dx_record_invoice \u5230 report_invoice \u7b2c {} \u9875\u5f00\u59cb", (Object)(++currPage));
            dateParams.put("currPage", currPage);
            invoiceList = this.jvChcInvoiceSyncMapper.queryInvoiceForPage((Map)dateParams);
            if (invoiceList == null) continue;
            log.info("\u540c\u6b65 t_dx_record_invoice \u5230 report_invoice \u7b2c {} \u9875\uff0c\u5171 {} \u6761\u8bb0\u5f55", (Object)currPage, (Object)invoiceList.size());
            this.saveBatch(invoiceList);
        } while (invoiceList != null && invoiceList.size() >= this.pageSize);
        log.info("\u540c\u6b65 t_dx_record_invoice \u5230 report_invoice \u7ed3\u675f");
    }

    private void saveBatch(List<ReportInvoice> invoiceList) {
        if (invoiceList != null && invoiceList.size() > 0) {
            invoiceList.forEach(t -> {
                try {
                    QueryWrapper delWrapper = new QueryWrapper();
                    delWrapper.eq((Object)"invoice_code", (Object)t.getInvoiceCode());
                    delWrapper.eq((Object)"invoice_no", (Object)t.getInvoiceNo());
                    if (!StringUtils.isEmpty((String)t.getRemark())) {
                        if (t.getRemark().indexOf("IC-") != -1) {
                            t.setCategory1("IC");
                            t.setSellerStoreNo(JvChcInvoiceSyncQuartz.getICSellerStoreNo((String)t.getRemark()));
                        } else if (t.getRemark().indexOf("MTR") != -1) {
                            t.setCategory1("MTR");
                            t.setSettlementNo(JvChcInvoiceSyncQuartz.getMTRSettlementNo((String)t.getRemark()));
                            t.setSellerStoreNo(JvChcInvoiceSyncQuartz.getMTRSellerStoreNo((String)t.getRemark()));
                            t.setSellerJv(JvChcInvoiceSyncQuartz.getMTRSellerJv((String)t.getRemark()));
                            t.setPurchaserStoreNo(JvChcInvoiceSyncQuartz.getMTRPurchaserStoreNo((String)t.getRemark()));
                            if (StringUtils.isEmpty((String)t.getJvcode())) {
                                t.setJvcode(JvChcInvoiceSyncQuartz.getMTRPurchaserJv((String)t.getRemark()));
                            }
                        }
                    }
                    System.out.println(JSONObject.toJSONString((Object)t));
                    this.reportInvoiceMapper.delete((Wrapper)delWrapper);
                    this.reportInvoiceMapper.insert(t);
                    this.reportInvoiceDetailMapper.delete((Wrapper)delWrapper);
                    this.jvChcInvoiceSyncMapper.insertReportInvoiceDetail(t);
                }
                catch (Exception e) {
                    log.error("\u63d2\u5165report_invoice\u5f02\u5e38\uff0c\u53d1\u7968\u4ee3\u7801\uff1a{}\u3001\u53f7\u7801\uff1a{}: {}", new Object[]{t.getInvoiceCode(), t.getInvoiceNo(), e.getMessage()});
                    e.printStackTrace();
                }
            });
        }
    }

    private static String getICSellerStoreNo(String remark) {
        if (remark.indexOf("\u5e97") != -1) {
            Matcher matcher = IC_SELLLER_STORE_NO_REGEX.matcher(remark);
            if (matcher.find()) {
                String temp = matcher.group();
                int end = temp.indexOf("\u95e8\u5e97");
                if (end == -1) {
                    end = temp.indexOf("\u5e97");
                }
                return temp.substring(0, end);
            }
            return "";
        }
        int start = remark.indexOf("IC-");
        Matcher matcher = IC_SELLLER_STORE_NO_REGEX1.matcher(remark.substring(start + 3));
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    private static String getMTRSettlementNo(String remark) {
        if (remark.indexOf("[") != -1 && remark.indexOf("]") != -1) {
            int start = remark.indexOf("[");
            int end = remark.indexOf("]");
            if (start != -1 && end != -1 && end > start + 1) {
                return remark.substring(start + 1, end);
            }
            return "";
        }
        if (remark.indexOf("\u5355\u53f7\u4e3a:") != -1 || remark.indexOf("\u5355\u53f7\u4e3a\uff1a") != -1) {
            int start = remark.indexOf("\u5355\u53f7\u4e3a");
            int end = remark.indexOf(" ", start + 4);
            if (end == -1) {
                end = remark.length();
            }
            return remark.substring(start + 4, end);
        }
        if (remark.indexOf("\u5355\u4e3a:") != -1 || remark.indexOf("\u5355\u4e3a\uff1a") != -1) {
            int start = remark.indexOf("\u5355\u4e3a");
            int end = remark.indexOf(" ", start + 3);
            if (end == -1) {
                end = remark.length();
            }
            return remark.substring(start + 3, end);
        }
        return "";
    }

    private static String getMTRSellerStoreNo(String remark) {
        if (remark.indexOf("\u53d1\u51fa\u65b9") != -1) {
            int start = remark.indexOf("\u53d1\u51fa\u65b9");
            int end = remark.indexOf(";", start);
            if (end == -1) {
                end = remark.indexOf("\uff1b", start);
            }
            if (start != -1 && end != -1 && end > start + 4) {
                return remark.substring(start + 4, end);
            }
            return "";
        }
        if (remark.indexOf("\u672c\u5730\u8ba2\u5355") != -1) {
            int start = remark.indexOf("\u4ece");
            int end = remark.indexOf("\u5e97", start);
            if (start != -1 && end != -1 && end > start + 1) {
                return remark.substring(start + 1, end);
            }
            return "";
        }
        return "";
    }

    private static String getMTRPurchaserStoreNo(String remark) {
        if (remark.indexOf("\u8d2d\u5165\u65b9") != -1) {
            int start = remark.indexOf("\u8d2d\u5165\u65b9");
            int end = remark.indexOf(";", start);
            if (end == -1) {
                end = remark.indexOf("\uff1b", start);
            }
            if (start != -1 && end != -1 && end > start + 4) {
                return remark.substring(start + 4, end);
            }
            return "";
        }
        if (remark.indexOf("\u672c\u5730\u8ba2\u5355") != -1) {
            int start = remark.indexOf("\u5230");
            int end = remark.indexOf("\u5e97", start);
            if (start != -1 && end != -1 && end > start + 1) {
                return remark.substring(start + 1, end);
            }
            return "";
        }
        return "";
    }

    private static String getMTRSellerJv(String remark) {
        int start = remark.indexOf("\u53d1\u51fa\u65b9");
        start = remark.indexOf(";", start);
        int end = remark.indexOf("/", start);
        if (start != -1 && end != -1 && end > start + 1) {
            return remark.substring(start + 1, end);
        }
        return "";
    }

    private static String getMTRPurchaserJv(String remark) {
        int start = remark.indexOf("\u8d2d\u5165\u65b9");
        start = remark.indexOf(";", start);
        int end = remark.indexOf(" ", start);
        if (start != -1 && end != -1 && end > start + 1) {
            return remark.substring(start + 1, end);
        }
        return "";
    }

    static /* synthetic */ int access$000(JvChcInvoiceSyncQuartz x0) {
        return x0.pageSize;
    }
}

