/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.reportfrom.wapp.entity.TDxExcelExportlog;
import com.reportfrom.wapp.entity.TDxMessagecontrol;
import com.reportfrom.wapp.entity.UserEntity;
import com.reportfrom.wapp.handler.ExportHandleerEnum;
import com.reportfrom.wapp.mq.ActiveMqProducer;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.CommonMessageService;
import com.reportfrom.wapp.service.TDxExcelExportlogService;
import com.reportfrom.wapp.util.Base64;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@DS(value="first")
public class BaseReportExportServiceImpl
implements BaseReportExportService {
    private static final Logger log = LoggerFactory.getLogger(BaseReportExportServiceImpl.class);
    @Autowired
    private TDxExcelExportlogService tDxExcelExportlogService;
    @Autowired
    private CommonMessageService commonMessageService;
    @Value(value="${activemq.queue-name.export-request}")
    private String exportQueue;
    @Autowired
    private ActiveMqProducer activeMqProducer;

    public void exportExcel(String token, String condition, String path, String fileName) {
        byte[] decode = Base64.decode((String)URLDecoder.decode(token));
        UserEntity userEntity = null;
        try {
            String s = new String(decode, "UTF-8");
            userEntity = (UserEntity)JSON.parseObject((String)s, UserEntity.class);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        log.info("token\u89e3\u6790\u6210\u529f>>>>suerAccount={}", (Object)userEntity.getUserid());
        TDxExcelExportlog excelExportlog = new TDxExcelExportlog();
        excelExportlog.setUserAccount(userEntity.getLoginname());
        excelExportlog.setUserName(userEntity.getUsername());
        excelExportlog.setConditions(condition);
        excelExportlog.setStartDate(new Date());
        excelExportlog.setExportStatus("1");
        excelExportlog.setServiceType(TDxExcelExportlogService.SERVICE_TYPE);
        excelExportlog.setFilepath(path + fileName);
        this.tDxExcelExportlogService.save((Object)excelExportlog);
        log.info("\u5165\u5e93\u6210\u529f\u3010tDxExcelExportlog\u3011\uff0clogid={},\u5f00\u59cb\u63a8\u9001MQ", (Object)excelExportlog.getId());
        HashMap<String, Object> heardrMap = new HashMap<String, Object>();
        heardrMap.put("type", "type");
        heardrMap.put("request", condition);
        heardrMap.put("userId", userEntity.getUserid());
        heardrMap.put("loginName", userEntity.getUsername());
        heardrMap.put("logId", excelExportlog.getId());
        heardrMap.put("fileName", fileName);
        this.activeMqProducer.send(this.exportQueue, JSON.toJSONString(heardrMap), Collections.singletonMap("handlerName", ExportHandleerEnum.EXCEPTION_REPORT.name()));
        log.info("MQ-queueName:{},\u63a8\u9001\u6210\u529f..", (Object)this.exportQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExport(Map map) {
        TDxExcelExportlog excelExportlog = (TDxExcelExportlog)this.tDxExcelExportlogService.getById((Serializable)((Integer)map.get("logId")));
        excelExportlog.setEndDate(new Date());
        excelExportlog.setExportStatus("2");
        TDxMessagecontrol tDxMessagecontrol = new TDxMessagecontrol();
        tDxMessagecontrol.setUserAccount(excelExportlog.getUserAccount());
        tDxMessagecontrol.setContent(this.getSuccContent(new Date()));
        try {
            tDxMessagecontrol.setUrl(this.getUrl(excelExportlog.getId().longValue()));
            tDxMessagecontrol.setTitle("\u6587\u4ef6\u3010" + map.get("fileName") + "\u3011\u5bfc\u51fa\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            excelExportlog.setExportStatus("3");
            excelExportlog.setErrmsg(e.getMessage());
            tDxMessagecontrol.setTitle("\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25\uff01");
            tDxMessagecontrol.setContent(this.getFileContent(e.getMessage()));
        }
        finally {
            this.tDxExcelExportlogService.updateById((Object)excelExportlog);
            this.commonMessageService.sendMessage(tDxMessagecontrol);
        }
    }

    public String getSuccContent(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String content = "\u7533\u8bf7\u65f6\u95f4\uff1a" + df.format(date) + "\u3002\u7533\u8bf7\u5bfc\u51fa\u6210\u529f\uff0c\u53ef\u4ee5\u4e0b\u8f7d\uff01";
        return content;
    }

    public String getFileContent(String errmsg) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String content = "\u7533\u8bf7\u65f6\u95f4:" + df.format(new Date()) + "\u3002\u7533\u8bf7\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u7533\u8bf7\uff01";
        return content;
    }

    public String getUrl(long id) {
        String url = "api/core/ftp/download?serviceType=2&downloadId=" + id;
        return url;
    }

    public String getFileName(long id) {
        String url = "api/core/ftp/download?serviceType=2&downloadId=" + id;
        return url;
    }
}

