/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entity.ReportAggrementEpdStatistic;
import com.reportfrom.wapp.mapper.first.ReportAggrementEpdStatisticMapper;
import com.reportfrom.wapp.request.ReportAggrementEpdStatisticRequest;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.ReportAggrementEpdStatisticService;
import com.reportfrom.wapp.service.impl.ReportAggrementEpdStatisticServiceImpl;
import com.reportfrom.wapp.util.DateUtils;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ReportAggrementEpdStatisticServiceImpl
extends ServiceImpl<ReportAggrementEpdStatisticMapper, ReportAggrementEpdStatistic>
implements ReportAggrementEpdStatisticService {
    private static final Logger log = LoggerFactory.getLogger(ReportAggrementEpdStatisticServiceImpl.class);
    @Autowired
    private ReportAggrementEpdStatisticMapper reportAggrementEpdStatisticMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public PageUtils queryRAESPage(ReportAggrementEpdStatisticRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        if (!StringUtils.isEmpty((String)params.getPostingDate())) {
            String[] postingDates = params.getPostingDate().split(",");
            map.put("startPostingDate", postingDates[0]);
            map.put("endPostingDate", postingDates[1]);
        }
        Integer count = this.reportAggrementEpdStatisticMapper.selectAllCountByParam(map);
        List reportChcChecks = null;
        reportChcChecks = null != count && count > 0 ? this.reportAggrementEpdStatisticMapper.selectMapsByParams(map) : new ArrayList(0);
        PageUtils rpage = new PageUtils();
        rpage.setList(reportChcChecks);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void uploadMain(InputStream is, HttpServletResponse response) {
        try {
            long startTime = System.currentTimeMillis();
            log.info("\u534f\u8bae\u548cEPD\u7a0e\u52a1\u62a5\u8868\u4e3b\u4fe1\u606f\u5bfc\u5165\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a" + startTime);
            List list = this.mainExcelToList(is);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.reportAggrementEpdStatisticMapper.insertReportAES((ReportAggrementEpdStatistic)iterator.next());
            }
            long one = System.currentTimeMillis() - startTime;
            log.info("\u534f\u8bae\u548cEPD\u7a0e\u52a1\u62a5\u8868\u4e3b\u4fe1\u606f\u5bfc\u5165,\u8017\u65f6\uff1a" + one);
        }
        catch (Exception e) {
            log.error("\u534f\u8bae\u548cEPD\u7a0e\u52a1\u62a5\u8868\u4e3b\u4fe1\u606f\u5bfc\u5165\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void uploadTax(InputStream is, HttpServletResponse response) {
        try {
            long startTime = System.currentTimeMillis();
            log.info("\u672a\u7ed3\u6b3e\u534f\u8bae\u7a0e\u91d1\u8868\u4fe1\u606f\u5bfc\u5165\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a" + startTime);
            List list = this.taxExcelToList(is);
            for (ReportAggrementEpdStatistic reportAggrementEpdStatistic : list) {
                if (reportAggrementEpdStatistic.getUnSettleAmount() == null || StringUtils.isEmpty((String)reportAggrementEpdStatistic.getLinkIndex())) {
                    log.warn("\u672a\u7ed3\u6b3e\u534f\u8bae\u7a0e\u91d1\u8868\u4fe1\u606f\u5bfc\u5165-----\u94fe\u63a5\u7d22\u5f15\uff08{}\uff09\u3001\u672a\u7ed3\u6b3e\u534f\u8bae\u7a0e\u91d1\uff08{}\uff09\u5b58\u5728\u7a7a\u503c", (Object)reportAggrementEpdStatistic.getLinkIndex(), (Object)reportAggrementEpdStatistic.getUnSettleAmount());
                    continue;
                }
                this.reportAggrementEpdStatisticMapper.updateReportAES(reportAggrementEpdStatistic);
            }
            long one = System.currentTimeMillis() - startTime;
            log.info("\u672a\u7ed3\u6b3e\u534f\u8bae\u7a0e\u91d1\u8868\u4fe1\u606f\u5bfc\u5165,\u8017\u65f6\uff1a" + one);
        }
        catch (Exception e) {
            log.error("\u672a\u7ed3\u6b3e\u534f\u8bae\u7a0e\u91d1\u8868\u4fe1\u606f\u5bfc\u5165,\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void uploadCheckTaxAmount(InputStream is, HttpServletResponse response) {
        try {
            long startTime = System.currentTimeMillis();
            log.info("\u8c03\u8d26\u7a0e\u989d\u8868\u4fe1\u606f\u5bfc\u5165\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a" + startTime);
            List list = this.taxAmountExcelToList(is);
            for (ReportAggrementEpdStatistic info : list) {
                if (info.getCheckBalanceTaxAmount() == null && info.getApplyTaxAmount() == null && StringUtils.isEmpty((String)info.getDealDate()) || StringUtils.isEmpty((String)info.getLinkIndex())) {
                    log.warn("\u8c03\u8d26\u7a0e\u989d\u8868\u4fe1\u606f\u5bfc\u5165-----\u94fe\u63a5\u7d22\u5f15\uff08{}\uff09\u3001\u635f\u76ca\u8c03\u8d26\u7a0e\u989d\uff08{}\uff09\u3001\u76f4\u63a5\u7533\u62a5\u7a0e\u989d\uff08{}\uff09\u3001\u5904\u7406\u65e5\u671f\uff08{}\uff09\u5b58\u5728\u7a7a\u503c", new Object[]{info.getLinkIndex(), info.getCheckBalanceTaxAmount(), info.getApplyTaxAmount(), info.getDealDate()});
                    continue;
                }
                this.reportAggrementEpdStatisticMapper.updateReportAES(info);
            }
            long one = System.currentTimeMillis() - startTime;
            log.info("\u8c03\u8d26\u7a0e\u989d\u8868\u4fe1\u606f\u5bfc\u5165,\u8017\u65f6\uff1a" + one);
        }
        catch (Exception e) {
            log.error("\u8c03\u8d26\u7a0e\u989d\u8868\u4fe1\u606f\u5bfc\u5165,\u5f02\u5e38\uff1a" + e.getMessage());
            e.printStackTrace();
        }
    }

    private List<ReportAggrementEpdStatistic> taxAmountExcelToList(InputStream inputStream) {
        ArrayList<ReportAggrementEpdStatistic> list = new ArrayList<ReportAggrementEpdStatistic>();
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)inputStream);
            inputStream.close();
            Sheet sheet = workbook.getSheetAt(0);
            int rowLength = sheet.getLastRowNum();
            for (int i = 1; i <= rowLength; ++i) {
                String applyTaxAmountStr;
                Row row = sheet.getRow(i);
                ReportAggrementEpdStatistic reportAggrementEpdStatistic = new ReportAggrementEpdStatistic();
                String certificateNo = ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(0));
                reportAggrementEpdStatistic.setCertificateNo(certificateNo);
                String reference = ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(1));
                reportAggrementEpdStatistic.setReference(reference);
                String postingDate = ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(2));
                reportAggrementEpdStatistic.setPostingDate(postingDate);
                reportAggrementEpdStatistic.setLinkIndex(certificateNo + reference + postingDate);
                String checkBalanceTaxAmountStr = ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(3));
                if (!StringUtils.isEmpty((String)checkBalanceTaxAmountStr)) {
                    BigDecimal checkBalanceTaxAmount = new BigDecimal(checkBalanceTaxAmountStr);
                    reportAggrementEpdStatistic.setCheckBalanceTaxAmount(checkBalanceTaxAmount);
                }
                if (!StringUtils.isEmpty((String)(applyTaxAmountStr = ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(4))))) {
                    BigDecimal applyTaxAmount = new BigDecimal(applyTaxAmountStr);
                    reportAggrementEpdStatistic.setApplyTaxAmount(applyTaxAmount);
                }
                reportAggrementEpdStatistic.setDealDate(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(5)));
                list.add(reportAggrementEpdStatistic);
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u8d26\u7a0e\u989d\u8868\u4fe1\u606f\u5bfc\u5165 - excel\u8f6cList\u5f02\u5e38:", (Throwable)e);
            e.printStackTrace();
        }
        return list;
    }

    private List<ReportAggrementEpdStatistic> taxExcelToList(InputStream inputStream) {
        ArrayList<ReportAggrementEpdStatistic> list = new ArrayList<ReportAggrementEpdStatistic>();
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)inputStream);
            inputStream.close();
            Sheet sheet = workbook.getSheetAt(0);
            int rowLength = sheet.getLastRowNum();
            for (int i = 1; i <= rowLength; ++i) {
                Row row = sheet.getRow(i);
                ReportAggrementEpdStatistic reportAggrementEpdStatistic = new ReportAggrementEpdStatistic();
                String certificateNo = ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(11));
                reportAggrementEpdStatistic.setCertificateNo(certificateNo);
                String reference = ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(1));
                reportAggrementEpdStatistic.setReference(reference);
                String postingDate = ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(8));
                reportAggrementEpdStatistic.setPostingDate(postingDate);
                reportAggrementEpdStatistic.setLinkIndex(certificateNo + reference + postingDate);
                String unSettleAmountStr = ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(13));
                if (!StringUtils.isEmpty((String)unSettleAmountStr)) {
                    BigDecimal unSettleAmount = new BigDecimal(unSettleAmountStr);
                    reportAggrementEpdStatistic.setUnSettleAmount(unSettleAmount);
                }
                list.add(reportAggrementEpdStatistic);
            }
        }
        catch (Exception e) {
            log.error("\u672a\u7ed3\u6b3e\u534f\u8bae\u7a0e\u91d1\u8868\u4fe1\u606f\u5bfc\u5165 - excel\u8f6cList\u5f02\u5e38:", (Throwable)e);
            e.printStackTrace();
        }
        return list;
    }

    private List<ReportAggrementEpdStatistic> mainExcelToList(InputStream inputStream) {
        ArrayList<ReportAggrementEpdStatistic> list = new ArrayList<ReportAggrementEpdStatistic>();
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)inputStream);
            inputStream.close();
            Sheet sheet = workbook.getSheetAt(0);
            int rowLength = sheet.getLastRowNum();
            for (int i = 1; i <= rowLength; ++i) {
                Row row = sheet.getRow(i);
                ReportAggrementEpdStatistic reportAggrementEpdStatistic = new ReportAggrementEpdStatistic();
                reportAggrementEpdStatistic.setCompanyCode(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(0)));
                reportAggrementEpdStatistic.setSubject(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(1)));
                reportAggrementEpdStatistic.setAllocation(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(2)));
                reportAggrementEpdStatistic.setCertificateNo(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(3)));
                reportAggrementEpdStatistic.setBusinessScope(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(4)));
                reportAggrementEpdStatistic.setCertificateType(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(5)));
                reportAggrementEpdStatistic.setPostingDate(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(6)));
                reportAggrementEpdStatistic.setCertificateDate(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(7)));
                reportAggrementEpdStatistic.setAccountingCode(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(8)));
                String standardCurrencyAmountStr = ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(9));
                if (!StringUtils.isEmpty((String)standardCurrencyAmountStr)) {
                    BigDecimal standardCurrencyAmount = new BigDecimal(standardCurrencyAmountStr);
                    reportAggrementEpdStatistic.setStandardCurrencyAmount(standardCurrencyAmount);
                }
                reportAggrementEpdStatistic.setStandardCurrency(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(10)));
                reportAggrementEpdStatistic.setTaxCode(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(11)));
                reportAggrementEpdStatistic.setClearCertificate(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(12)));
                reportAggrementEpdStatistic.setProfitCenter(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(13)));
                reportAggrementEpdStatistic.setDuan(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(14)));
                reportAggrementEpdStatistic.setTextContent(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(15)));
                reportAggrementEpdStatistic.setReverseSubjectType(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(16)));
                reportAggrementEpdStatistic.setReverseSubjectAccount(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(17)));
                reportAggrementEpdStatistic.setPartner(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(18)));
                reportAggrementEpdStatistic.setCertificateTitle(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(19)));
                reportAggrementEpdStatistic.setReferenceCodeBt1(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(20)));
                reportAggrementEpdStatistic.setReferenceCodeTt1(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(21)));
                reportAggrementEpdStatistic.setReferenceCode1(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(22)));
                reportAggrementEpdStatistic.setReferenceCode2(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(23)));
                reportAggrementEpdStatistic.setReference(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(24)));
                reportAggrementEpdStatistic.setInvoiceReference(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(25)));
                reportAggrementEpdStatistic.setSapCertificateDate(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(26), (Boolean)true));
                reportAggrementEpdStatistic.setJudge(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(27)));
                reportAggrementEpdStatistic.setDealMonth(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(28)));
                String taxAmountStr = ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(29));
                if (!StringUtils.isEmpty((String)taxAmountStr)) {
                    BigDecimal taxAmount = new BigDecimal(taxAmountStr);
                    reportAggrementEpdStatistic.setTaxAmount(taxAmount);
                }
                reportAggrementEpdStatistic.setLinkIndex(reportAggrementEpdStatistic.getCertificateNo() + reportAggrementEpdStatistic.getReference() + reportAggrementEpdStatistic.getPostingDate());
                reportAggrementEpdStatistic.setPreSpeDrawFirst(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(34)));
                reportAggrementEpdStatistic.setPreAdjustmentTaxAmountFirst(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(35)));
                reportAggrementEpdStatistic.setPrePaperDateFirst(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(36)));
                reportAggrementEpdStatistic.setPreSpeDrawSecond(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(37)));
                reportAggrementEpdStatistic.setPreAdjustmentTaxAmountSecond(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(38)));
                reportAggrementEpdStatistic.setPrePaperDateSecond(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(39)));
                reportAggrementEpdStatistic.setPreEpdSpeDraw(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(43)));
                reportAggrementEpdStatistic.setPreEpdAdjustmentTaxAmount(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(44)));
                reportAggrementEpdStatistic.setPreEpdPaperDate(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(45)));
                reportAggrementEpdStatistic.setPpa(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(46)));
                reportAggrementEpdStatistic.setPpaAdjustmentTaxAmount(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(47)));
                reportAggrementEpdStatistic.setPpaPaperDate(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(48)));
                reportAggrementEpdStatistic.setCkBkAmount(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(54)));
                reportAggrementEpdStatistic.setHAdjustmentTaxAmount(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(55)));
                reportAggrementEpdStatistic.setHPaperDate(ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)row.getCell(56)));
                list.add(reportAggrementEpdStatistic);
            }
        }
        catch (Exception e) {
            log.error("\u534f\u8bae\u548cEPD\u7a0e\u52a1\u62a5\u8868\u4e3b\u4fe1\u606f\u5bfc\u5165 - excel\u8f6cList\u5f02\u5e38:", (Throwable)e);
            e.printStackTrace();
        }
        return list;
    }

    public int queryRAESCount(ReportAggrementEpdStatisticRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        Integer count = this.reportAggrementEpdStatisticMapper.selectAllCountByParam(map);
        return count;
    }

    public void produceReportAES(ReportAggrementEpdStatisticRequest params, String token) {
        String fileName = "\u534f\u8bae\u548cEPD\u7a0e\u52a1\u62a5\u8868_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")) + ".xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        if (!StringUtils.isEmpty((String)params.getPostingDate())) {
            String[] postingDates = params.getPostingDate().split(",");
            map.put("startPostingDate", postingDates[0]);
            map.put("endPostingDate", postingDates[1]);
        }
        List voList = this.reportAggrementEpdStatisticMapper.selectMapsByParams(map);
        String path = this.ftpConfig.getServerSavePath() + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + "/";
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.REPORT_AGGREMENT_EPD_STATISTIC_QUERY, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("token", token);
        parmMap.put("condition", condition);
        parmMap.put("path", path);
        parmMap.put("fileName", fileName);
        String s = JSON.toJSONString(parmMap);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    private static String getCellValueByType(Cell cell, Boolean flag) {
        String returnValue = null;
        if (cell == null) {
            returnValue = "";
        } else {
            switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellTypeEnum().ordinal()]) {
                case 1: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date date = cell.getDateCellValue();
                        returnValue = DateUtils.format((Date)date, (String)"yyyyMMdd");
                        break;
                    }
                    double numericCellValue = cell.getNumericCellValue();
                    if (Double.isNaN(numericCellValue)) break;
                    if (flag.booleanValue()) {
                        long round = Math.round(cell.getNumericCellValue());
                        returnValue = round + "";
                        break;
                    }
                    returnValue = numericCellValue + "";
                    break;
                }
                case 2: {
                    returnValue = cell.getStringCellValue();
                    break;
                }
            }
        }
        return returnValue;
    }

    private static String getCellValueByType(Cell cell) {
        return ReportAggrementEpdStatisticServiceImpl.getCellValueByType((Cell)cell, (Boolean)false);
    }

    public int updateAggrementRedTaxAmount() {
        return this.reportAggrementEpdStatisticMapper.updateAggrementRedTaxAmount();
    }

    public int updateEpdRedTaxAmount() {
        return this.reportAggrementEpdStatisticMapper.updateEpdRedTaxAmount();
    }

    public int updateUnInvoiceAmount() {
        return this.reportAggrementEpdStatisticMapper.updateUnInvoiceAmount();
    }

    public int updateBlueOffsetAmount() {
        return this.reportAggrementEpdStatisticMapper.updateBlueOffsetAmount();
    }
}

