/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entity.ReportClaimStatistic;
import com.reportfrom.wapp.entity.ReportClaimStatisticBeanWithTaxRate;
import com.reportfrom.wapp.mapper.first.ReportClaimRedStatisticMapper;
import com.reportfrom.wapp.mapper.first.ReportClaimStatisticMapper;
import com.reportfrom.wapp.mapper.first.TXfBillDeductMapper;
import com.reportfrom.wapp.request.ReportClaimStatisticDetailsReq;
import com.reportfrom.wapp.request.ReportClaimStatisticReq;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.ReportClaimStatisticService;
import com.reportfrom.wapp.service.impl.ReportClaimStatisticServiceImpl;
import com.reportfrom.wapp.util.DateUtils;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ReportClaimStatisticServiceImpl
extends ServiceImpl<ReportClaimStatisticMapper, ReportClaimStatistic>
implements ReportClaimStatisticService {
    private static final Logger log = LoggerFactory.getLogger(ReportClaimStatisticServiceImpl.class);
    @Autowired
    private ReportClaimStatisticMapper reportClaimStatisticMapper;
    @Autowired
    private ReportClaimRedStatisticMapper reportClaimRedStatisticMapper;
    @Autowired
    private TXfBillDeductMapper tXfBillDeductMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    private static String getCellValueByType(Cell cell) {
        return ReportClaimStatisticServiceImpl.getCellValueByType((Cell)cell, (Boolean)true);
    }

    private static String getCellValueByType(Cell cell, Boolean flag) {
        String returnValue = null;
        if (cell == null) {
            returnValue = "";
        } else {
            switch (2.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellTypeEnum().ordinal()]) {
                case 1: {
                    short format = cell.getCellStyle().getDataFormat();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
                    if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                        returnValue = sdf.format(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()));
                        break;
                    }
                    if (format > 176 && format < 185) {
                        returnValue = sdf.format(HSSFDateUtil.getJavaDate((double)cell.getNumericCellValue()));
                        break;
                    }
                    double numericCellValue = cell.getNumericCellValue();
                    returnValue = NumberToTextConverter.toText((double)numericCellValue);
                    break;
                }
                case 2: {
                    returnValue = cell.getStringCellValue();
                    break;
                }
                case 3: {
                    NumberFormat nf = NumberFormat.getInstance();
                    String content = nf.format(cell.getNumericCellValue());
                    if (content.indexOf(",") >= 0) {
                        content = content.replace(",", "");
                    }
                    returnValue = content;
                }
            }
        }
        return returnValue;
    }

    public void uploadMain(MultipartFile file, HttpServletResponse response) {
        new Thread((Runnable)new /* Unavailable Anonymous Inner Class!! */).start();
        try {
            long startTime = System.currentTimeMillis();
            log.info("\u5f00\u59cb\u65f6\u95f4\uff1a" + startTime);
            List list = this.excelToList(file.getInputStream());
            for (ReportClaimStatistic next : list) {
                QueryWrapper wrapper = new QueryWrapper();
                ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"date_month", (Object)next.getDateMonth())).eq((Object)"blue_invoice_no", (Object)next.getBlueInvoiceNo())).eq((Object)"supplier_no", (Object)next.getSupplierNo());
                ReportClaimStatistic insertOrUpdateEn = (ReportClaimStatistic)this.reportClaimStatisticMapper.selectOne((Wrapper)wrapper);
                if (insertOrUpdateEn == null) {
                    ReportClaimStatisticBeanWithTaxRate unsettledDemo;
                    if (next.getDateMonth().length() != 6) continue;
                    BigDecimal standardCurrencyAmount = next.getStandardCurrencyAmount();
                    Map queryDeductMap = DateUtils.getFistAndLastByString((String)next.getDateMonth(), (String)"yyyyMM", (String)"String", null);
                    queryDeductMap.put("blueInvoiceNo", next.getBlueInvoiceNo());
                    queryDeductMap.put("supplierNo", next.getSupplierNo());
                    ReportClaimStatisticBeanWithTaxRate demo = this.tXfBillDeductMapper.selectSumByParams(queryDeductMap);
                    if (demo != null) {
                        next.setClaimAmountWithTax(demo.getClaimAmountWithTax());
                        next.setClaimTaxAmount(demo.getClaimTaxAmount());
                        next.setDifferenceTaxAmount(standardCurrencyAmount.subtract(demo.getClaimTaxAmount()));
                    }
                    if ((unsettledDemo = this.tXfBillDeductMapper.selectUnsettledSumByParams(queryDeductMap)) != null) {
                        next.setUnsettledTaxAmount(unsettledDemo.getUnsettledTaxAmount());
                        next.setUnsettledAmountWithTax(unsettledDemo.getUnsettledAmountWithTax());
                    }
                    this.reportClaimStatisticMapper.insert((Object)next);
                    continue;
                }
                next.setId(insertOrUpdateEn.getId());
                this.reportClaimStatisticMapper.updateById((Object)next);
            }
            long one = System.currentTimeMillis() - startTime;
            log.info("\u539f\u6587\u4ef6\u8bfb\u53d6\u81f3\u5185\u5b58\u7ed3\u675f\u65f6\u95f4,\u8017\u65f6\uff1a" + one);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startSelectZeroTaxRateForInsert() {
        log.info("\u5f00\u59cb\u67e5\u8be2\u4e0a\u67080\u7a0e\u7387\u5df2\u5339\u914d\u7ea2\u5b57\u5355\u636e\u7684\u7d22\u8d54\u5355...");
        String lastMonth = DateUtils.getLastMonth();
        Map queryDeductMap = DateUtils.getFistAndLastByString((String)lastMonth, (String)"yyyyMM", (String)"String", (String)"yyyy-MM-dd");
        List zeroDemo = this.tXfBillDeductMapper.selecetZeroSumByParams(queryDeductMap);
        for (ReportClaimStatistic report : zeroDemo) {
            report.setSubject("2226020");
            report.setSupplierDInvoice(report.getSupplierNo() + report.getBlueInvoiceNo());
            report.setDateMonth(lastMonth);
            QueryWrapper wrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"date_month", (Object)lastMonth)).eq((Object)"blue_invoice_no", (Object)report.getBlueInvoiceNo())).eq((Object)"supplier_no", (Object)report.getSupplierNo());
            ReportClaimStatistic insertOrUpdateEn = (ReportClaimStatistic)this.reportClaimStatisticMapper.selectOne((Wrapper)wrapper);
            if (insertOrUpdateEn == null) {
                this.reportClaimStatisticMapper.insert((Object)report);
                continue;
            }
            report.setId(insertOrUpdateEn.getId());
            this.reportClaimStatisticMapper.updateById((Object)report);
        }
    }

    private List<ReportClaimStatistic> excelToList(InputStream inputStream) {
        ArrayList<ReportClaimStatistic> list = new ArrayList<ReportClaimStatistic>();
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)inputStream);
            inputStream.close();
            Sheet sheet = workbook.getSheetAt(0);
            int rowLength = sheet.getLastRowNum();
            for (int i = 1; i <= rowLength; ++i) {
                Row row = sheet.getRow(i);
                Cell cell = row.getCell(26);
                if (cell == null || cell.getCellTypeEnum() == CellType._NONE || cell.getCellTypeEnum() == CellType.BLANK) continue;
                ReportClaimStatistic reportClaimStatistic = new ReportClaimStatistic();
                reportClaimStatistic.setCompanyCode(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(0)));
                reportClaimStatistic.setSubject(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(1)));
                reportClaimStatistic.setAllocation(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(2)));
                reportClaimStatistic.setCertificateNo(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(3)));
                reportClaimStatistic.setBusinessScope(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(4)));
                reportClaimStatistic.setCertificateType(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(5)));
                reportClaimStatistic.setPostingDate(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(6)));
                reportClaimStatistic.setCertificateDate(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(7)));
                reportClaimStatistic.setAccountingCode(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(8)));
                String cellValueByType = ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(9));
                if (!StringUtils.isEmpty((String)cellValueByType)) {
                    BigDecimal bigDecimal = new BigDecimal(cellValueByType);
                    reportClaimStatistic.setStandardCurrencyAmount(bigDecimal);
                }
                reportClaimStatistic.setStandardCurrency(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(10)));
                reportClaimStatistic.setTaxCode(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(11)));
                reportClaimStatistic.setClearCertificate(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(12)));
                reportClaimStatistic.setProfitCenter(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(13)));
                reportClaimStatistic.setDuan(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(14)));
                reportClaimStatistic.setTextContent(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(15)));
                reportClaimStatistic.setReverseSubjectType(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(16)));
                reportClaimStatistic.setReverseSubjectAccount(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(17)));
                reportClaimStatistic.setPartner(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(18)));
                reportClaimStatistic.setCertificateTitle(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(19)));
                reportClaimStatistic.setReferenceCodeBt1(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(20)));
                reportClaimStatistic.setReferenceCodeTt1(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(21)));
                reportClaimStatistic.setReferenceCode1(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(22)));
                reportClaimStatistic.setReferenceCode2(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(23)));
                reportClaimStatistic.setReference(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(24)));
                reportClaimStatistic.setInvoiceReference(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(25)));
                reportClaimStatistic.setDateMonth(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(26)));
                reportClaimStatistic.setBlueInvoiceNo(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(28)));
                reportClaimStatistic.setSupplierNo(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(29)));
                reportClaimStatistic.setSupplierName(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(30)));
                reportClaimStatistic.setSupplierDInvoice(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(31)));
                list.add(reportClaimStatistic);
            }
        }
        catch (Exception e) {
            log.error("parse excel file error :", (Throwable)e);
        }
        return list;
    }

    public void uploadChange(MultipartFile file, HttpServletResponse response) {
        try {
            long startTime = System.currentTimeMillis();
            log.info("\u5f00\u59cb\u65f6\u95f4\uff1a" + startTime);
            List list = this.excelChangeToList(file.getInputStream());
            for (ReportClaimStatistic next : list) {
                QueryWrapper wrapper = new QueryWrapper();
                ((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"date_month", (Object)next.getDateMonth())).eq((Object)"blue_invoice_no", (Object)next.getBlueInvoiceNo())).eq((Object)"supplier_no", (Object)next.getSupplierNo());
                ReportClaimStatistic reportClaimStatistic = (ReportClaimStatistic)this.reportClaimStatisticMapper.selectOne((Wrapper)wrapper);
                if (reportClaimStatistic == null) {
                    this.reportClaimStatisticMapper.insert((Object)next);
                    continue;
                }
                next.setId(reportClaimStatistic.getId());
                BigDecimal unsettledTaxAmount = reportClaimStatistic.getUnsettledTaxAmount();
                if (unsettledTaxAmount == null) {
                    unsettledTaxAmount = new BigDecimal(0);
                }
                BigDecimal add = unsettledTaxAmount.add(next.getCheckBalanceAmount());
                next.setUnsettledTaxAmount(add);
                this.reportClaimStatisticMapper.updateById((Object)next);
            }
            long one = System.currentTimeMillis() - startTime;
            log.info("\u539f\u6587\u4ef6\u8bfb\u53d6\u81f3\u5185\u5b58\u7ed3\u675f\u65f6\u95f4,\u8017\u65f6\uff1a" + one);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PageUtils queryList(ReportClaimStatisticReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        if (!StringUtils.isEmpty((String)params.getPostingDate())) {
            List<String> strings = Arrays.asList(params.getPostingDate().split(","));
            map.put("startPostingDate", strings.get(0));
            map.put("endPostingDate", strings.get(1));
        }
        List list = this.reportClaimStatisticMapper.selectListByParams(map);
        Integer count = this.reportClaimStatisticMapper.selectCountByParams(map);
        for (ReportClaimStatistic statistic : list) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("blueInvoiceNo", statistic.getBlueInvoiceNo());
            queryMap.put("supplierNo", statistic.getSupplierNo());
            queryMap.put("dateMonth", statistic.getDateMonth());
            List redStatistic = this.reportClaimRedStatisticMapper.selectDetailsList(queryMap);
            statistic.setRedStatisticsList(redStatistic);
        }
        PageUtils rpage = new PageUtils();
        rpage.setList(list);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void export(ReportClaimStatisticReq params, String token) {
        String fileName = "\u7d22\u8d54\u7a0e\u52a1\u62a5\u8868.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        if (!StringUtils.isEmpty((String)params.getPostingDate())) {
            List<String> strings = Arrays.asList(params.getPostingDate().split(","));
            map.put("startPostingDate", strings.get(0));
            map.put("endPostingDate", strings.get(1));
        }
        List voList = this.reportClaimStatisticMapper.selectListByParams(map);
        String path = this.ftpConfig.getServerSavePath();
        for (ReportClaimStatistic statistic : voList) {
            HashMap<String, String> queryMap = new HashMap<String, String>();
            queryMap.put("blueInvoiceNo", statistic.getBlueInvoiceNo());
            queryMap.put("supplierNo", statistic.getSupplierNo());
            queryMap.put("dateMonth", statistic.getDateMonth());
            List redStatistic = this.reportClaimRedStatisticMapper.selectDetailsList(queryMap);
            statistic.setRedStatisticsList(redStatistic);
        }
        ExcelUtils.createExcel((List)voList, (String)ExcelTypeConfig.CLAIM_TAX_STATEMENT, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils queryDetailsList(ReportClaimStatisticDetailsReq params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List RedStatistics = this.reportClaimRedStatisticMapper.selectDetailsList(map);
        Integer count = 0;
        if (!CollectionUtils.isEmpty((Collection)RedStatistics)) {
            count = RedStatistics.size();
        }
        PageUtils rpage = new PageUtils();
        rpage.setList(RedStatistics);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    private List<ReportClaimStatistic> excelChangeToList(InputStream inputStream) {
        ArrayList<ReportClaimStatistic> list = new ArrayList<ReportClaimStatistic>();
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)inputStream);
            inputStream.close();
            Sheet sheet = workbook.getSheetAt(0);
            int rowLength = sheet.getLastRowNum();
            for (int i = 0; i < rowLength; ++i) {
                Row row = sheet.getRow(i + 1);
                Cell cell = row.getCell(0);
                if (cell == null || cell.getCellTypeEnum() == CellType._NONE || cell.getCellTypeEnum() == CellType.BLANK) continue;
                ReportClaimStatistic reportClaimStatistic = new ReportClaimStatistic();
                reportClaimStatistic.setDateMonth(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(0)));
                reportClaimStatistic.setBlueInvoiceNo(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(1)));
                reportClaimStatistic.setSupplierNo(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(2)));
                reportClaimStatistic.setCheckBalanceAmount(new BigDecimal(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(3))));
                reportClaimStatistic.setApplyAmount(new BigDecimal(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(4))));
                reportClaimStatistic.setDealTime(ReportClaimStatisticServiceImpl.getCellValueByType((Cell)row.getCell(5)));
                list.add(reportClaimStatistic);
            }
        }
        catch (Exception e) {
            log.error("parse excel file error :", (Throwable)e);
        }
        return list;
    }
}

