/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entity.TXfBillDeduct;
import com.reportfrom.wapp.entity.TXfRedNotification;
import com.reportfrom.wapp.entityVO.ClaimantVO;
import com.reportfrom.wapp.entityVO.ProtocolQueryVO;
import com.reportfrom.wapp.entityVO.RedNotificationLogVO;
import com.reportfrom.wapp.entityVO.TDxRecordInvoiceVO;
import com.reportfrom.wapp.entityVO.invoiceNoBybusinessNoVO;
import com.reportfrom.wapp.mapper.first.TXfBillDeductItemMapper;
import com.reportfrom.wapp.mapper.first.TXfBillDeductMapper;
import com.reportfrom.wapp.mapper.first.TXfRedNotificationMapper;
import com.reportfrom.wapp.request.ClaimantQueryReq;
import com.reportfrom.wapp.request.ProtocolQueryReq;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.TXfBillDeductService;
import com.reportfrom.wapp.util.DateUtils;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import io.micrometer.core.instrument.util.StringUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TXfBillDeductServiceImpl
extends ServiceImpl<TXfBillDeductMapper, TXfBillDeduct>
implements TXfBillDeductService {
    private static final Logger log = LoggerFactory.getLogger(TXfBillDeductServiceImpl.class);
    @Autowired
    private TXfBillDeductMapper tXfBillDeductMapper;
    @Autowired
    private TXfRedNotificationMapper tXfRedNotificationMapper;
    @Autowired
    private TXfBillDeductItemMapper tXfBillDeductItemMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public PageUtils queryPageByParamsType1(ClaimantQueryReq params) {
        Map map = this.returnQueryMapType1(params, Boolean.valueOf(true));
        List list = this.returnType1(params, map);
        int count = this.tXfBillDeductMapper.selectCountByParamsType1(map);
        PageUtils rpage = new PageUtils();
        rpage.setList(list);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count);
        return rpage;
    }

    public void exportByParamsType1(ClaimantQueryReq params, String token) {
        String fileName = "\u7d22\u8d54\u7efc\u5408\u67e5\u8be2\u62a5\u8868.xlsx";
        Map map = this.returnQueryMapType1(params, Boolean.valueOf(false));
        List list = this.returnType1(params, map);
        Set idSet = list.stream().filter(Objects::nonNull).map(ClaimantVO::getId).collect(Collectors.toSet());
        List detailsVo = this.tXfBillDeductItemMapper.selectDetailsByIds(idSet);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)list, (List)detailsVo, (String)ExcelTypeConfig.CLAIMANT_QUERY, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils queryPageByParamsType2(ProtocolQueryReq params) {
        Map map = this.returnQueryMapType2(params, Boolean.valueOf(true));
        List volist = this.returnType2(params, map);
        Integer count = this.tXfBillDeductMapper.selectCountByParamsType2(map);
        PageUtils rpage = new PageUtils();
        rpage.setList(volist);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void exportByParamsType2(ProtocolQueryReq params, String token) {
        String fileName = "\u534f\u8bae\u7efc\u5408\u67e5\u8be2\u62a5\u8868.xlsx";
        Map map = this.returnQueryMapType2(params, Boolean.valueOf(false));
        List volist = this.returnType2(params, map);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)volist, (String)ExcelTypeConfig.PROTOCOL_QUERY, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    private Map returnQueryMapType1(ClaimantQueryReq params, Boolean isPage) {
        List<String> strings;
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        if (isPage.booleanValue()) {
            map.put("tureOrfalse", true);
        }
        if ((StringUtils.isNotEmpty((String)params.getApplyingStatus()) || StringUtils.isNotEmpty((String)params.getCreateDate()) || StringUtils.isNotEmpty((String)params.getCxRedFlag()) || StringUtils.isNotEmpty((String)params.getRedNotificationNo()) || StringUtils.isNotEmpty((String)params.getBlueCxFlag()) || StringUtils.isNotEmpty((String)params.getBlueInvoiceNo())) && !"6".equals(params.getApplyingStatus())) {
            List settlementNoList;
            if (StringUtils.isNotEmpty((String)params.getCreateDate())) {
                strings = Arrays.asList(params.getCreateDate().split(","));
                map.put("firstDay", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(0), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
                map.put("lastDay", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(1), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            }
            if (!CollectionUtils.isEmpty((Collection)(settlementNoList = this.tXfRedNotificationMapper.selectRedByCXBlue(map)))) {
                map.put("settlementNoList", settlementNoList);
            } else {
                map.put("nullCode", true);
            }
        } else if ("6".equals(params.getApplyingStatus())) {
            map.put("noRedSettlementNo", true);
        }
        if (StringUtils.isNotEmpty((String)params.getDeductDate())) {
            strings = Arrays.asList(params.getDeductDate().split(","));
            map.put("startDeductDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(0), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            map.put("endDeductDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(1), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
        }
        return map;
    }

    private List<ClaimantVO> returnType1(ClaimantQueryReq params, Map map) {
        List list = this.tXfBillDeductMapper.selectByParamsType1(map);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return list;
        }
        Set businessSet = list.stream().map(ClaimantVO::getBusinessNo).collect(Collectors.toSet());
        businessSet.removeIf(o -> StringUtils.isEmpty((String)o));
        Set refSettlemeentNoSet = list.stream().map(ClaimantVO::getRefSettlementNo).collect(Collectors.toSet());
        refSettlemeentNoSet.removeIf(o -> StringUtils.isEmpty((String)o));
        Map<Object, Object> collect = new HashMap();
        Map<Object, Object> redNotifiBySettlementNo = new HashMap();
        Map<Object, Object> redInvoiceByRedNotifiNo = new HashMap();
        if (!CollectionUtils.isEmpty(businessSet)) {
            List invoiceNoList = this.tXfBillDeductMapper.selectInvoiceNoBybusinessNo(businessSet);
            collect = invoiceNoList.stream().collect(Collectors.groupingBy(invoiceNoBybusinessNoVO::getBusinessNo));
        }
        if (!CollectionUtils.isEmpty(refSettlemeentNoSet)) {
            List tDxRecordInvoiceVOS;
            List redNotificationsList = this.tXfBillDeductMapper.selectRedNotificationBySettlementNo(refSettlemeentNoSet);
            redNotifiBySettlementNo = redNotificationsList.stream().collect(Collectors.groupingBy(TXfRedNotification::getBillNo));
            Set allRedNotificationSet = redNotificationsList.stream().map(TXfRedNotification::getRedNotificationNo).collect(Collectors.toSet());
            allRedNotificationSet.removeIf(o -> StringUtils.isEmpty((String)o));
            if (!CollectionUtils.isEmpty(allRedNotificationSet) && !CollectionUtils.isEmpty((Collection)(tDxRecordInvoiceVOS = this.tXfBillDeductMapper.selectAllRecordInvoiceByRedNotificationNo(allRedNotificationSet)))) {
                redInvoiceByRedNotifiNo = tDxRecordInvoiceVOS.stream().collect(Collectors.groupingBy(TDxRecordInvoiceVO::getRedNoticeNumber));
            }
        }
        for (ClaimantVO vo : list) {
            List testVOS;
            if (BigDecimal.ZERO.equals(vo.getTaxRate())) {
                vo.setTaxRate("0.00");
            }
            if (!CollectionUtils.isEmpty((Collection)(testVOS = (List)collect.get(vo.getBusinessNo())))) {
                String join = String.join((CharSequence)",", testVOS.stream().map(invoiceNoBybusinessNoVO::getInvoiceNo).collect(Collectors.toList()));
                vo.setInvoiceNo(join);
            }
            if (StringUtils.isNotEmpty((String)vo.getRefSettlementNo())) {
                List redNotifications = (List)redNotifiBySettlementNo.get(vo.getRefSettlementNo());
                if (CollectionUtils.isEmpty((Collection)redNotifications)) continue;
                TXfRedNotification redNotification = (TXfRedNotification)redNotifications.get(0);
                vo.setApplyingStatus(redNotification.getApplyingStatus() + "");
                if (redNotification.getApplyingStatus() == 3) {
                    vo.setCreateDate(redNotification.getUpdateDate());
                }
                if (redNotification.getApproveStatus() == 4) {
                    vo.setCxRedFlag("1");
                    vo.setUpdateDate(redNotification.getUpdateDate());
                } else {
                    vo.setCxRedFlag("0");
                }
                Set redNotificationNoList = redNotifications.stream().filter(Objects::nonNull).map(TXfRedNotification::getRedNotificationNo).collect(Collectors.toSet());
                redNotificationNoList.removeIf(o -> StringUtils.isEmpty((String)o));
                if (CollectionUtils.isEmpty(redNotificationNoList)) continue;
                String redNotificationNo = String.join((CharSequence)",", redNotificationNoList.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList()));
                vo.setRedNotificationNo(StringUtils.isNotEmpty((String)redNotificationNo) && !"null".equals(redNotificationNo) ? redNotificationNo : "");
                HashSet tDxRecordInvoiceVOSBySettlement = new HashSet();
                for (String key : redNotificationNoList) {
                    List tDxRecordInvoiceVOS = (List)redInvoiceByRedNotifiNo.get(key);
                    if (CollectionUtils.isEmpty((Collection)tDxRecordInvoiceVOS)) continue;
                    tDxRecordInvoiceVOSBySettlement.addAll(tDxRecordInvoiceVOS);
                }
                if (CollectionUtils.isEmpty(tDxRecordInvoiceVOSBySettlement)) continue;
                Set redInvoiceNo = tDxRecordInvoiceVOSBySettlement.stream().filter(Objects::nonNull).map(TDxRecordInvoiceVO::getInvoiceNo).collect(Collectors.toSet());
                Set invoiceStatusSet = tDxRecordInvoiceVOSBySettlement.stream().filter(Objects::nonNull).map(TDxRecordInvoiceVO::getInvoiceStatus).collect(Collectors.toSet());
                vo.setRedInvoiceNo(String.join((CharSequence)",", redInvoiceNo.stream().map(String::valueOf).collect(Collectors.toList())));
                if (CollectionUtils.isEmpty(invoiceStatusSet) || invoiceStatusSet.contains("5")) {
                    vo.setBlueCxFlag("1");
                    Set blueRelations = tDxRecordInvoiceVOSBySettlement.stream().filter(Objects::nonNull).map(TDxRecordInvoiceVO::getBlueInvoiceNo).collect(Collectors.toSet());
                    blueRelations.removeIf(s -> StringUtils.isEmpty((String)s));
                    if (!CollectionUtils.isEmpty(blueRelations)) {
                        vo.setBlueInvoiceNo(String.join((CharSequence)",", blueRelations.stream().map(String::valueOf).collect(Collectors.toList())));
                    }
                    Set blueUpdateTime = tDxRecordInvoiceVOSBySettlement.stream().filter(Objects::nonNull).map(TDxRecordInvoiceVO::getBlueUpdateTime).collect(Collectors.toSet());
                    blueUpdateTime.removeIf(s -> StringUtils.isEmpty((String)s));
                    if (CollectionUtils.isEmpty(blueUpdateTime)) continue;
                    vo.setBlueUploadTime(String.join((CharSequence)",", blueUpdateTime.stream().map(String::valueOf).collect(Collectors.toList())));
                    continue;
                }
                vo.setBlueCxFlag("0");
                continue;
            }
            vo.setApplyingStatus("6");
        }
        return list;
    }

    private Map returnQueryMapType2(ProtocolQueryReq params, Boolean isPage) {
        List<String> strings;
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        if (isPage.booleanValue()) {
            map.put("tureOrfalse", true);
        }
        if (StringUtils.isNotEmpty((String)params.getRedNotificationApplyDate())) {
            strings = Arrays.asList(params.getRedNotificationApplyDate().split(","));
            map.put("startApplyDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(0), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            map.put("endApplyDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(1), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isNotEmpty((String)params.getRedNotificationNo()) || StringUtils.isNotEmpty((String)params.getRedNotificationStatus()) || StringUtils.isNotEmpty((String)params.getRedNotificationApplyDate()) || StringUtils.isNotEmpty((String)params.getInvoiceStatus())) {
            List settlementNoList = this.tXfRedNotificationMapper.selectSettlementNoByMap(map);
            if (!CollectionUtils.isEmpty((Collection)settlementNoList)) {
                map.put("settlementNoList", settlementNoList);
            } else {
                map.put("nullCode", true);
            }
        }
        if (StringUtils.isNotEmpty((String)params.getDeductDate())) {
            strings = Arrays.asList(params.getDeductDate().split(","));
            map.put("startDeductDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(0), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            map.put("endDeductDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(1), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isNotEmpty((String)params.getCreateTime())) {
            strings = Arrays.asList(params.getCreateTime().split(","));
            map.put("startCreateTime", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(0), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            map.put("endCreateTime", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(1), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isNotEmpty((String)params.getVerdictDate())) {
            strings = Arrays.asList(params.getVerdictDate().split(","));
            map.put("startVerdictDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(0), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            map.put("endVerdictDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(1), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
        }
        return map;
    }

    private List<ProtocolQueryVO> returnType2(ProtocolQueryReq params, Map map) {
        List volist = this.tXfBillDeductMapper.selectByParamsType2(map);
        if (CollectionUtils.isEmpty((Collection)volist)) {
            return volist;
        }
        Map<Object, Object> redNotifiBySettlementNo = new HashMap();
        Map<Object, Object> redInvoiceByRedNotifiNo = new HashMap();
        Map<Object, Object> redNotifiTimeByettlementNo = new HashMap();
        Set refSettlemeentNoSet = volist.stream().map(ProtocolQueryVO::getRefSettlementNo).collect(Collectors.toSet());
        refSettlemeentNoSet.removeIf(o -> StringUtils.isEmpty((String)o));
        if (!CollectionUtils.isEmpty(refSettlemeentNoSet)) {
            List tDxRecordInvoiceVOS;
            List redNotificationsList = this.tXfBillDeductMapper.selectRedNotificationBySettlementNo(refSettlemeentNoSet);
            redNotifiBySettlementNo = redNotificationsList.stream().collect(Collectors.groupingBy(TXfRedNotification::getBillNo));
            Set idSet = redNotificationsList.stream().map(o -> o.getId()).collect(Collectors.toSet());
            List logVOS = this.tXfBillDeductMapper.selectLogByRedNotificationId(idSet);
            redNotifiTimeByettlementNo = logVOS.stream().collect(Collectors.groupingBy(o -> o.getBillNo() + "-" + o.getApplyType()));
            Set allRedNotificationSet = redNotificationsList.stream().map(TXfRedNotification::getRedNotificationNo).collect(Collectors.toSet());
            allRedNotificationSet.removeIf(o -> StringUtils.isEmpty((String)o));
            if (!CollectionUtils.isEmpty(allRedNotificationSet) && !CollectionUtils.isEmpty((Collection)(tDxRecordInvoiceVOS = this.tXfBillDeductMapper.selectAllRecordInvoiceByRedNotificationNo(allRedNotificationSet)))) {
                redInvoiceByRedNotifiNo = tDxRecordInvoiceVOS.stream().collect(Collectors.groupingBy(TDxRecordInvoiceVO::getRedNoticeNumber));
            }
        }
        for (ProtocolQueryVO vo : volist) {
            List cxTimeList;
            List redNotifications;
            if (!StringUtils.isNotEmpty((String)vo.getRefSettlementNo()) || CollectionUtils.isEmpty((Collection)(redNotifications = (List)redNotifiBySettlementNo.get(vo.getRefSettlementNo())))) continue;
            TXfRedNotification tXfRedNotification = (TXfRedNotification)redNotifications.get(0);
            Integer applyingStatus = tXfRedNotification.getApplyingStatus();
            Integer approveStatus = tXfRedNotification.getApproveStatus();
            if (approveStatus == 3) {
                vo.setRedNotificationStatus("6");
            } else if (approveStatus == 4) {
                vo.setRedNotificationStatus("5");
            } else if (applyingStatus == 4) {
                vo.setRedNotificationStatus("4");
            } else if (applyingStatus == 3) {
                vo.setRedNotificationStatus("3");
            } else if (applyingStatus == 2) {
                vo.setRedNotificationStatus("2");
            } else if (applyingStatus == 1) {
                vo.setRedNotificationStatus("1");
            }
            List sqTimeList = (List)redNotifiTimeByettlementNo.get(tXfRedNotification.getBillNo() + "-1");
            if (!CollectionUtils.isEmpty((Collection)sqTimeList)) {
                String usedate = ((RedNotificationLogVO)sqTimeList.get(0)).getUsedate();
                vo.setRedNotificationApplyDate(usedate);
            }
            if (!CollectionUtils.isEmpty((Collection)(cxTimeList = (List)redNotifiTimeByettlementNo.get(tXfRedNotification.getBillNo() + "-3")))) {
                String usedate = ((RedNotificationLogVO)cxTimeList.get(0)).getUsedate();
                vo.setRedNotificationApproveDate(usedate);
            }
            Set invoiceNoSet = redNotifications.stream().filter(Objects::nonNull).map(TXfRedNotification::getOriginInvoiceNo).collect(Collectors.toSet());
            HashSet<String> redNotificationNoSet = new HashSet<String>();
            HashSet<String> cheXiaoRedNotificationNoSet = new HashSet<String>();
            for (TXfRedNotification redNotification : redNotifications) {
                if (!"4".equals(redNotification.getApproveStatus())) {
                    if (!StringUtils.isNotEmpty((String)redNotification.getRedNotificationNo())) continue;
                    redNotificationNoSet.add(redNotification.getRedNotificationNo());
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)redNotification.getRedNotificationNo())) continue;
                cheXiaoRedNotificationNoSet.add(redNotification.getRedNotificationNo());
            }
            vo.setRedNotificationNo(String.join((CharSequence)",", redNotificationNoSet.stream().map(String::valueOf).collect(Collectors.toList())));
            vo.setRedNotificationNo2(String.join((CharSequence)",", cheXiaoRedNotificationNoSet.stream().map(String::valueOf).collect(Collectors.toList())));
            vo.setOriginInvoiceNo(String.join((CharSequence)",", invoiceNoSet.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList())));
            HashSet<String> allNotificationNo = new HashSet<String>();
            allNotificationNo.addAll(redNotificationNoSet);
            allNotificationNo.addAll(cheXiaoRedNotificationNoSet);
            allNotificationNo.removeIf(o -> StringUtils.isEmpty((String)o));
            if (CollectionUtils.isEmpty(allNotificationNo)) continue;
            HashSet tDxRecordInvoiceVOSBySettlement = new HashSet();
            for (String notificationNo : allNotificationNo) {
                List tDxRecordInvoiceVOS = (List)redInvoiceByRedNotifiNo.get(notificationNo);
                if (CollectionUtils.isEmpty((Collection)tDxRecordInvoiceVOS)) continue;
                tDxRecordInvoiceVOSBySettlement.addAll(tDxRecordInvoiceVOS);
            }
            if (CollectionUtils.isEmpty(tDxRecordInvoiceVOSBySettlement)) continue;
            Set invoiceStatusSet = tDxRecordInvoiceVOSBySettlement.stream().filter(Objects::nonNull).map(TDxRecordInvoiceVO::getInvoiceStatus).collect(Collectors.toSet());
            Set invoiceDateSet = tDxRecordInvoiceVOSBySettlement.stream().filter(Objects::nonNull).map(TDxRecordInvoiceVO::getInvoiceDate).collect(Collectors.toSet());
            if (invoiceStatusSet.contains("5")) {
                vo.setSettlementStatusNo("4");
            }
            vo.setRedInvoiceDate(String.join((CharSequence)",", invoiceDateSet.stream().map(String::valueOf).collect(Collectors.toList())));
            Set blueInvoiceNoList = tDxRecordInvoiceVOSBySettlement.stream().filter(Objects::nonNull).map(TDxRecordInvoiceVO::getBlueInvoiceNo).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(blueInvoiceNoList)) continue;
            vo.setBlueInvoiceNo(String.join((CharSequence)",", blueInvoiceNoList.stream().map(String::valueOf).collect(Collectors.toList())));
            vo.setBlueInvoiceDate(String.join((CharSequence)",", invoiceDateSet.stream().map(String::valueOf).collect(Collectors.toList())));
        }
        return volist;
    }
}

