/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entityVO.ReportJvChcInterInvoiceVO;
import com.reportfrom.wapp.mapper.first.ReportJvChcInterInvoiceMapper;
import com.reportfrom.wapp.request.ReportJvChcInterInvoiceRequest;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.ReportJvChcInterInvoiceService;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@DS(value="first")
public class ReportJvChcInterInvoiceServiceImpl
implements ReportJvChcInterInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(ReportJvChcInterInvoiceServiceImpl.class);
    @Autowired
    private ReportJvChcInterInvoiceMapper reportJvChcInterInvoiceMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    private void queryCondition(Map map, ReportJvChcInterInvoiceRequest params) {
        if (!StringUtils.isEmpty((String)params.getInvoiceDate())) {
            String[] invoiceDateStrs = params.getInvoiceDate().split(",");
            map.put("startInvoiceDate", LocalDate.parse(invoiceDateStrs[0], DateTimeFormatter.ofPattern("yyyyMMdd")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 00:00:00");
            map.put("endInvoiceDate", LocalDate.parse(invoiceDateStrs[1], DateTimeFormatter.ofPattern("yyyyMMdd")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 23:59:59");
        }
        if (!StringUtils.isEmpty((String)params.getAuthDate())) {
            String[] authDateStrs = params.getAuthDate().split(",");
            map.put("startAuthDate", LocalDate.parse(authDateStrs[0], DateTimeFormatter.ofPattern("yyyyMMdd")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 00:00:00");
            map.put("endAuthDate", LocalDate.parse(authDateStrs[1], DateTimeFormatter.ofPattern("yyyyMMdd")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 23:59:59");
        }
        if (!StringUtils.isEmpty((String)params.getRemark())) {
            map.put("remark", "%" + this.handleName(params.getRemark()) + "%");
        }
        if (!StringUtils.isEmpty((String)params.getGoodsName())) {
            map.put("goodsName", "%" + this.handleName(params.getGoodsName()) + "%");
        }
        if (!StringUtils.isEmpty((String)params.getExt1())) {
            map.put("ext1", "%" + this.handleName(params.getExt1()) + "%");
        }
        if (!StringUtils.isEmpty((String)params.getTaxCode())) {
            if ("PA".equals(params.getTaxCode())) {
                map.put("taxRate", "0.05");
            } else if ("P3".equals(params.getTaxCode())) {
                map.put("taxRate", "0.06");
            } else if ("S5".equals(params.getTaxCode())) {
                map.put("taxRate", "0.09");
            } else {
                map.put("taxRate", "AAA");
            }
        }
    }

    public PageUtils queryPage(ReportJvChcInterInvoiceRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        this.queryCondition(map, params);
        Integer count = this.reportJvChcInterInvoiceMapper.selectAllCountByParam(map);
        List reportInvoices = null;
        reportInvoices = null != count && count > 0 ? this.reportJvChcInterInvoiceMapper.selectMapsByParams(map) : new ArrayList(0);
        ReportJvChcInterInvoiceServiceImpl.dealReportJvChcInterInvoiceVOs(reportInvoices, (boolean)false);
        PageUtils rpage = new PageUtils();
        rpage.setList(reportInvoices);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void produceReportJvChcInterInvoice(ReportJvChcInterInvoiceRequest params, String token) {
        String fileName = "JV-CHC\u5185\u90e8\u53d1\u7968\u62a5\u8868_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")) + ".xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        this.queryCondition(map, params);
        List list = this.reportJvChcInterInvoiceMapper.selectMapsByParams(map);
        ReportJvChcInterInvoiceServiceImpl.dealReportJvChcInterInvoiceVOs((List)list, (boolean)true);
        String path = this.ftpConfig.getServerSavePath() + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + "/";
        ExcelUtils.createExcel((List)list, (String)ExcelTypeConfig.REPORT_JV_CHC_INTER_INVOICE_QUERY, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("token", token);
        parmMap.put("condition", condition);
        parmMap.put("path", path);
        parmMap.put("fileName", fileName);
        String s = JSON.toJSONString(parmMap);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    private static void dealReportJvChcInterInvoiceVOs(List<ReportJvChcInterInvoiceVO> list, boolean isDeal) {
        if (list != null && list.size() > 0) {
            list.forEach(t -> {
                t.setInvoiceType(ReportJvChcInterInvoiceServiceImpl.getInvoiceTypeName((String)t.getInvoiceType()));
                if (isDeal) {
                    t.setQsStatus(ReportJvChcInterInvoiceServiceImpl.getQsStatusName((String)t.getQsStatus()));
                    t.setAuthStatus(ReportJvChcInterInvoiceServiceImpl.getAuthStatusName((String)t.getAuthStatus()));
                }
                if (!StringUtils.isEmpty((String)t.getRemark())) {
                    // empty if block
                }
                t.setInvoiceStatus(ReportJvChcInterInvoiceServiceImpl.getInvoiceStatusName((String)t.getInvoiceStatus()));
                if (!StringUtils.isEmpty((String)t.getInvoiceDate())) {
                    t.setInvoiceDate(t.getInvoiceDate().substring(0, 10));
                }
                if (!StringUtils.isEmpty((String)t.getQsDate())) {
                    t.setQsDate(t.getQsDate().substring(0, 10));
                }
                if (!StringUtils.isEmpty((String)t.getAuthDate())) {
                    t.setAuthDate(t.getAuthDate().substring(0, 10));
                }
                if (!StringUtils.isEmpty((String)t.getTaxRate())) {
                    t.setTaxCode(ReportJvChcInterInvoiceServiceImpl.getTaxCode((String)t.getTaxRate()));
                }
            });
        }
    }

    private static String getTaxCode(String taxRate) {
        if (!StringUtils.isEmpty((String)taxRate)) {
            if (taxRate.indexOf("5") != -1) {
                return "PA";
            }
            if (taxRate.indexOf("6") != -1 && taxRate.indexOf("1") == -1) {
                return "P3";
            }
            if (taxRate.indexOf("9") != -1) {
                return "S5";
            }
        }
        return "";
    }

    private static String getInvoiceTypeName(String invoiceTypeCode) {
        if (!StringUtils.isEmpty((String)invoiceTypeCode)) {
            switch (invoiceTypeCode) {
                case "01": {
                    return "\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968";
                }
                case "03": {
                    return "\u673a\u52a8\u8f66\u9500\u552e\u7edf\u4e00\u53d1\u7968";
                }
                case "04": {
                    return "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968";
                }
                case "07": {
                    return "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968\uff08\u533a\u5757\u94fe\uff09";
                }
                case "08": {
                    return "\u589e\u503c\u7a0e\u7535\u5b50\u4e13\u7528\u53d1\u7968";
                }
                case "10": {
                    return "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968";
                }
                case "11": {
                    return "\u589e\u503c\u7a0e\u666e\u901a\u53d1\u7968\uff08\u5377\u7968\uff09";
                }
                case "14": {
                    return "\u589e\u503c\u7a0e\u7535\u5b50\u666e\u901a\u53d1\u7968\uff08\u901a\u884c\u8d39\uff09";
                }
            }
        }
        return invoiceTypeCode;
    }

    private static String getQsStatusName(String qsStatusCode) {
        if (!StringUtils.isEmpty((String)qsStatusCode)) {
            switch (qsStatusCode) {
                case "0": {
                    return "\u672a\u7b7e\u6536";
                }
                case "1": {
                    return "\u5df2\u7b7e\u6536";
                }
            }
        }
        return "\u672a\u7b7e\u6536";
    }

    private static String getAuthStatusName(String authStatusCode) {
        if (!StringUtils.isEmpty((String)authStatusCode)) {
            switch (authStatusCode) {
                case "0": {
                    return "\u672a\u8ba4\u8bc1";
                }
                case "1": {
                    return "\u5df2\u52fe\u9009\u672a\u786e\u8ba4";
                }
                case "2": {
                    return "\u5df2\u786e\u8ba4";
                }
                case "3": {
                    return "\u5df2\u53d1\u9001\u8ba4\u8bc1";
                }
                case "4": {
                    return "\u8ba4\u8bc1\u6210\u529f";
                }
                case "5": {
                    return "\u8ba4\u8bc1\u5931\u8d25";
                }
            }
            return "\u672a\u8ba4\u8bc1";
        }
        return "\u672a\u8ba4\u8bc1";
    }

    private static String getInvoiceStatusName(String invoiceStatusCode) {
        if (!StringUtils.isEmpty((String)invoiceStatusCode)) {
            switch (invoiceStatusCode) {
                case "0": {
                    return "\u6b63\u5e38";
                }
                case "1": {
                    return "\u5931\u63a7";
                }
                case "2": {
                    return "\u4f5c\u5e9f";
                }
                case "3": {
                    return "\u7ea2\u51b2";
                }
                case "4": {
                    return "\u5f02\u5e38";
                }
                case "5": {
                    return "\u84dd\u51b2";
                }
            }
            return "\u5f02\u5e38";
        }
        return "\u6b63\u5e38";
    }

    private String handleName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        return name.replace("_", "[_]").replace("%", "[%]").replace("[", "[[]").replace("^", "[^]");
    }
}

