/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.util;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.reportfrom.wapp.config.FtpConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class SFTPUtils {
    private static final Logger LOG = LogManager.getLogger(SFTPUtils.class);
    @Autowired
    FtpConfig ftpConfig;
    private static ChannelSftp sftp;
    private static SFTPUtils sftpUtils;

    private SFTPUtils() {
    }

    public static SFTPUtils getInstance() {
        if (sftp == null && sftp == null) {
            sftp = sftpUtils.connect(SFTPUtils.sftpUtils.ftpConfig.getHost(), SFTPUtils.sftpUtils.ftpConfig.getPort().intValue(), SFTPUtils.sftpUtils.ftpConfig.getUserName(), SFTPUtils.sftpUtils.ftpConfig.getPassWord());
        }
        return sftpUtils;
    }

    @PostConstruct
    public void init() {
        sftpUtils = this;
        SFTPUtils.sftpUtils.ftpConfig = this.ftpConfig;
    }

    public ChannelSftp connect(String host, int port, String username, String password) {
        ChannelSftp sftp = null;
        Channel channel = null;
        JSch jsch = new JSch();
        try {
            if ("private".equals(this.ftpConfig.getAuthMethod())) {
                if (StringUtils.isNotBlank((CharSequence)this.ftpConfig.getPrivateKey())) {
                    if ("".equals(this.ftpConfig.getPassphrase())) {
                        jsch.addIdentity(this.ftpConfig.getPrivateKey(), this.ftpConfig.getPassphrase());
                    } else {
                        jsch.addIdentity(this.ftpConfig.getPrivateKey());
                    }
                } else {
                    throw new JSchException(String.format("\u5bc6\u94a5\u9519\u8befprivateKey=%s,SFTP\u8fde\u63a5\u521d\u59cb\u5316\u5931\u8d25", this.ftpConfig.getPrivateKey()));
                }
            }
            Session session = jsch.getSession(username, host, port);
            if ("pwd".equals(this.ftpConfig.getAuthMethod())) {
                session.setPassword(password);
            }
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            sshConfig.put("PreferredAuthentications", "publickey,keyboard-interactive,password");
            session.setConfig(sshConfig);
            session.setTimeout(this.ftpConfig.getTimeout().intValue());
            session.connect();
            LOG.info("SFTP Session connected.");
            channel = session.openChannel("sftp");
            channel.connect();
            sftp = (ChannelSftp)channel;
            LOG.info("Connected to " + host);
        }
        catch (JSchException e) {
            e.printStackTrace();
        }
        return sftp;
    }

    public boolean upload(String directory, String uploadFile) throws Exception {
        try {
            sftp.cd(directory);
        }
        catch (SftpException e) {
            String[] dirs = directory.split("/");
            String tempPath = "";
            for (String dir : dirs) {
                if (null == dir || "".equals(dir)) continue;
                tempPath = tempPath + "/" + dir;
                try {
                    sftp.cd(tempPath);
                }
                catch (SftpException ex) {
                    sftp.mkdir(tempPath);
                    sftp.cd(tempPath);
                }
            }
        }
        try {
            File file = new File(uploadFile);
            FileInputStream fileInputStream = new FileInputStream(file);
            sftp.put((InputStream)fileInputStream, file.getName());
            fileInputStream.close();
            return true;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return false;
        }
    }

    public boolean upload(String pathName, String fileName, InputStream inputStream) throws Exception {
        try {
            sftp.cd(pathName);
        }
        catch (SftpException e) {
            String[] dirs = pathName.split("/");
            String tempPath = "";
            for (String dir : dirs) {
                if (null == dir || "".equals(dir)) continue;
                tempPath = tempPath + "/" + dir;
                try {
                    sftp.cd(tempPath);
                }
                catch (SftpException ex) {
                    sftp.mkdir(tempPath);
                    sftp.cd(tempPath);
                }
            }
        }
        try {
            sftp.put(inputStream, fileName);
            inputStream.close();
            LOG.debug("\u4e0a\u4f20\u6587\u4ef6\u6210\u529f");
            return true;
        }
        catch (Exception e) {
            LOG.error("\u9519\u8bef\u4fe1\u606f\uff1a{}", (Object)e.getMessage());
            return false;
        }
    }

    public File download(String directory, String downloadFile, String saveFile) {
        try {
            sftp.cd(directory);
            File file = new File(saveFile);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            sftp.get(downloadFile, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            return file;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return null;
        }
    }

    public File download(String downloadFilePath, String saveFile) {
        try {
            int i = downloadFilePath.lastIndexOf(47);
            if (i == -1) {
                return null;
            }
            sftp.cd(downloadFilePath.substring(0, i));
            File file = new File(saveFile);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            sftp.get(downloadFilePath.substring(i + 1), (OutputStream)fileOutputStream);
            fileOutputStream.close();
            return file;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return null;
        }
    }

    public void delete(String directory, String deleteFile) {
        try {
            sftp.cd(directory);
            sftp.rm(deleteFile);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }

    public void disconnect() {
        try {
            sftp.getSession().disconnect();
        }
        catch (JSchException e) {
            LOG.error(e.getMessage());
        }
        sftp.quit();
        sftp.disconnect();
    }

    public Vector<ChannelSftp.LsEntry> listFiles(String directory) throws SftpException {
        return sftp.ls(directory);
    }

    public static void main(String[] args) throws IOException {
        SFTPUtils sf = SFTPUtils.getInstance();
        File download = sf.download("/home/20220412test.xlsx", "/Users/wangjiajun/Downloads/SELLERREDINVOICE_test.xlsx");
        Vector files = null;
        for (ChannelSftp.LsEntry file : files) {
            System.out.println("###\t" + file.getFilename());
        }
        sf.disconnect();
    }
}

