/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.util.excelUtil;

import com.reportfrom.wapp.util.excelUtil.XssfDefaultHandler;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XssfDefaultHandler
extends DefaultHandler {
    private static final POILogger logger = POILogFactory.getLogger(XssfDefaultHandler.class);
    private final SheetContentsHandler output;
    private final DataFormatter formatter;
    private Styles stylesTable;
    private Comments comments;
    private SharedStrings sharedStringsTable;
    private boolean vIsOpen;
    private boolean fIsOpen;
    private boolean isIsOpen;
    private boolean hfIsOpen;
    private xssfDataType nextDataType;
    private short formatIndex;
    private String formatString;
    private int rowNum;
    private int nextRowNum;
    private boolean formulasNotResults;
    private StringBuilder value = new StringBuilder(64);
    private StringBuilder formula = new StringBuilder(64);
    private StringBuilder headerFooter = new StringBuilder(64);
    private Queue<CellAddress> commentCellRefs;
    private String lastIndex;
    private String preRef = null;
    private String cellRef = null;
    private String maxRef = null;
    private Integer totalRowCount;

    public XssfDefaultHandler(Styles styles, Comments comments, SharedStrings strings, SheetContentsHandler sheetContentsHandler, DataFormatter dataFormatter, boolean formulasNotResults) {
        this.stylesTable = styles;
        this.comments = comments;
        this.sharedStringsTable = strings;
        this.output = sheetContentsHandler;
        this.formulasNotResults = formulasNotResults;
        this.nextDataType = xssfDataType.NUMBER;
        this.formatter = dataFormatter;
        this.init(comments);
    }

    public XssfDefaultHandler(Styles styles, SharedStrings strings, SheetContentsHandler sheetContentsHandler, DataFormatter dataFormatter, boolean formulasNotResults) {
        this(styles, (Comments)null, strings, sheetContentsHandler, dataFormatter, formulasNotResults);
    }

    public XssfDefaultHandler(Styles styles, SharedStrings strings, SheetContentsHandler sheetContentsHandler, boolean formulasNotResults) {
        this(styles, strings, sheetContentsHandler, new DataFormatter(), formulasNotResults);
    }

    private void init(Comments commentsTable) {
        if (commentsTable != null) {
            this.commentCellRefs = new LinkedList();
            Iterator iter = commentsTable.getCellAddresses();
            while (iter.hasNext()) {
                System.out.println(iter.next());
                Object next = iter.next();
                this.commentCellRefs.add(new CellAddress(next.toString()));
            }
        }
    }

    private boolean isTextTag(String name) {
        if ("v".equals(name)) {
            return true;
        }
        if ("inlineStr".equals(name)) {
            return true;
        }
        return "t".equals(name) && this.isIsOpen;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri == null || uri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
            String cellType;
            if ("dimension".equals(qName)) {
                String dimensionStr = attributes.getValue("ref");
                try {
                    this.totalRowCount = Integer.parseInt(dimensionStr.substring(dimensionStr.indexOf(":") + 2)) - 1;
                }
                catch (NumberFormatException e) {
                    this.totalRowCount = Integer.parseInt(dimensionStr.substring(dimensionStr.indexOf(":") + 3)) - 1;
                }
            }
            if (this.isTextTag(localName)) {
                this.vIsOpen = true;
                this.value.setLength(0);
            } else if ("is".equals(localName)) {
                this.isIsOpen = true;
            } else if ("f".equals(localName)) {
                this.formula.setLength(0);
                if (this.nextDataType == xssfDataType.NUMBER) {
                    this.nextDataType = xssfDataType.FORMULA;
                }
                if ((cellType = attributes.getValue("t")) != null && cellType.equals("shared")) {
                    String cellStyleStr = attributes.getValue("ref");
                    String si = attributes.getValue("si");
                    if (cellStyleStr != null) {
                        this.fIsOpen = true;
                    } else if (this.formulasNotResults) {
                        logger.log(5, new Object[]{"shared formulas not yet supported!"});
                    }
                } else {
                    this.fIsOpen = true;
                }
            } else if (!("oddHeader".equals(localName) || "evenHeader".equals(localName) || "firstHeader".equals(localName) || "firstFooter".equals(localName) || "oddFooter".equals(localName) || "evenFooter".equals(localName))) {
                if ("row".equals(localName)) {
                    cellType = attributes.getValue("r");
                    this.rowNum = cellType != null ? Integer.parseInt(cellType) - 1 : this.nextRowNum;
                    this.output.startRow(this.rowNum);
                } else if ("c".equals(localName)) {
                    this.nextDataType = xssfDataType.NUMBER;
                    this.formatIndex = (short)-1;
                    this.formatString = null;
                    this.preRef = this.preRef == null ? attributes.getValue("r") : this.cellRef;
                    this.cellRef = attributes.getValue("r");
                    cellType = attributes.getValue("t");
                    String cellStyleStr = attributes.getValue("s");
                    if ("b".equals(cellType)) {
                        this.nextDataType = xssfDataType.BOOLEAN;
                    } else if ("e".equals(cellType)) {
                        this.nextDataType = xssfDataType.ERROR;
                    } else if ("inlineStr".equals(cellType)) {
                        this.nextDataType = xssfDataType.INLINE_STRING;
                    } else if ("s".equals(cellType)) {
                        this.nextDataType = xssfDataType.SST_STRING;
                    } else if ("str".equals(cellType)) {
                        this.nextDataType = xssfDataType.FORMULA;
                    } else {
                        XSSFCellStyle style = null;
                        if (this.stylesTable != null) {
                            if (cellStyleStr != null) {
                                int styleIndex = Integer.parseInt(cellStyleStr);
                                style = this.stylesTable.getStyleAt(styleIndex);
                            } else if (this.stylesTable.getNumCellStyles() > 0) {
                                style = this.stylesTable.getStyleAt(0);
                            }
                        }
                        if (style != null) {
                            this.formatIndex = style.getDataFormat();
                            this.formatString = style.getDataFormatString();
                            if (this.formatString == null) {
                                this.formatString = BuiltinFormats.getBuiltinFormat((int)this.formatIndex);
                            }
                        }
                    }
                }
            } else {
                this.hfIsOpen = true;
                this.headerFooter.setLength(0);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri == null || uri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
            String thisStr = null;
            if (this.isTextTag(localName)) {
                this.vIsOpen = false;
                switch (1.$SwitchMap$com$reportfrom$wapp$util$excelUtil$XssfDefaultHandler$xssfDataType[this.nextDataType.ordinal()]) {
                    case 1: {
                        char first = this.value.charAt(0);
                        thisStr = first == '0' ? "FALSE" : "TRUE";
                        break;
                    }
                    case 2: {
                        thisStr = "ERROR:" + this.value;
                        break;
                    }
                    case 3: {
                        if (this.formulasNotResults) {
                            thisStr = this.formula.toString();
                            break;
                        }
                        String fv = this.value.toString();
                        if (this.formatString != null) {
                            try {
                                double d = Double.parseDouble(fv);
                                thisStr = this.formatter.formatRawCellContents(d, (int)this.formatIndex, this.formatString);
                            }
                            catch (NumberFormatException var11) {
                                thisStr = fv;
                            }
                            break;
                        }
                        thisStr = fv;
                        break;
                    }
                    case 4: {
                        XSSFRichTextString rtsi = new XSSFRichTextString(this.value.toString());
                        thisStr = rtsi.toString();
                        break;
                    }
                    case 5: {
                        String sstIndex = this.value.toString();
                        try {
                            int idx = Integer.parseInt(sstIndex);
                            RichTextString rtss = this.sharedStringsTable.getItemAt(idx);
                            thisStr = rtss.toString();
                        }
                        catch (NumberFormatException var10) {
                            logger.log(7, new Object[]{"Failed to parse SST index '" + sstIndex, var10});
                        }
                        break;
                    }
                    case 6: {
                        if (this.formatString != null) {
                            thisStr = this.formatter.formatRawCellContents(Double.parseDouble(this.value.toString()), (int)this.formatIndex, this.formatString).trim();
                        } else if (this.value.toString().contains(".") && this.value.length() > 6) {
                            BigDecimal bd = new BigDecimal(this.value.toString()).setScale(2, 4);
                            thisStr = bd.toPlainString();
                        } else {
                            thisStr = this.value.toString();
                        }
                        thisStr = thisStr.replace("_", "").trim();
                        break;
                    }
                    case 7: {
                        thisStr = this.formatter.formatRawCellContents(Double.parseDouble(this.value.toString()), (int)this.formatIndex, this.formatString);
                        thisStr = thisStr.replace("T", "");
                        break;
                    }
                    case 8: {
                        thisStr = "";
                        break;
                    }
                    default: {
                        thisStr = "(TODO: Unexpected type: " + this.nextDataType + ")";
                    }
                }
                if (!this.cellRef.equals(this.preRef)) {
                    int len = this.countNullCell(this.cellRef, this.preRef);
                    for (int i = 0; i < len; ++i) {
                        this.output.cell(this.cellRef, "", null);
                    }
                }
                this.checkForEmptyCellComments(EmptyCellCommentsCheckType.CELL);
                XSSFComment comment = this.comments != null ? this.comments.findCellComment(new CellAddress(this.cellRef)) : null;
                this.output.cell(this.cellRef, thisStr, comment);
            } else if ("f".equals(localName)) {
                this.fIsOpen = false;
            } else if ("is".equals(localName)) {
                this.isIsOpen = false;
            } else if ("row".equals(localName)) {
                this.checkForEmptyCellComments(EmptyCellCommentsCheckType.END_OF_ROW);
                this.output.endRow(this.rowNum);
                this.nextRowNum = this.rowNum + 1;
            } else if ("sheetData".equals(localName)) {
                this.checkForEmptyCellComments(EmptyCellCommentsCheckType.END_OF_SHEET_DATA);
                this.output.endSheet();
            } else if (!("oddHeader".equals(localName) || "evenHeader".equals(localName) || "firstHeader".equals(localName))) {
                if ("oddFooter".equals(localName) || "evenFooter".equals(localName) || "firstFooter".equals(localName)) {
                    this.hfIsOpen = false;
                    this.output.headerFooter(this.headerFooter.toString(), false, localName);
                }
            } else {
                this.hfIsOpen = false;
                this.output.headerFooter(this.headerFooter.toString(), true, localName);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.vIsOpen) {
            this.value.append(ch, start, length);
        }
        if (this.fIsOpen) {
            this.formula.append(ch, start, length);
        }
        if (this.hfIsOpen) {
            this.headerFooter.append(ch, start, length);
        }
    }

    private void checkForEmptyCellComments(EmptyCellCommentsCheckType type) {
        if (this.commentCellRefs != null && !this.commentCellRefs.isEmpty()) {
            CellAddress nextCommentCellRef;
            if (type == EmptyCellCommentsCheckType.END_OF_SHEET_DATA) {
                while (!this.commentCellRefs.isEmpty()) {
                    this.outputEmptyCellComment((CellAddress)this.commentCellRefs.remove());
                }
                return;
            }
            if (this.cellRef == null) {
                if (type == EmptyCellCommentsCheckType.END_OF_ROW) {
                    while (!this.commentCellRefs.isEmpty()) {
                        if (((CellAddress)this.commentCellRefs.peek()).getRow() != this.rowNum) {
                            return;
                        }
                        this.outputEmptyCellComment((CellAddress)this.commentCellRefs.remove());
                    }
                    return;
                }
                throw new IllegalStateException("Cell ref should be null only if there are only empty cells in the row; rowNum: " + this.rowNum);
            }
            do {
                CellAddress cellRef = new CellAddress(this.cellRef);
                CellAddress peekCellRef = (CellAddress)this.commentCellRefs.peek();
                if (type == EmptyCellCommentsCheckType.CELL && cellRef.equals((Object)peekCellRef)) {
                    this.commentCellRefs.remove();
                    return;
                }
                int comparison = peekCellRef.compareTo(cellRef);
                if (comparison > 0 && type == EmptyCellCommentsCheckType.END_OF_ROW && peekCellRef.getRow() <= this.rowNum) {
                    nextCommentCellRef = (CellAddress)this.commentCellRefs.remove();
                    this.outputEmptyCellComment(nextCommentCellRef);
                    continue;
                }
                if (comparison < 0 && type == EmptyCellCommentsCheckType.CELL && peekCellRef.getRow() <= this.rowNum) {
                    nextCommentCellRef = (CellAddress)this.commentCellRefs.remove();
                    this.outputEmptyCellComment(nextCommentCellRef);
                    continue;
                }
                nextCommentCellRef = null;
            } while (nextCommentCellRef != null && !this.commentCellRefs.isEmpty());
        }
    }

    private void outputEmptyCellComment(CellAddress cellRef) {
        XSSFComment comment = this.comments.findCellComment(cellRef);
        this.output.cell(cellRef.formatAsString(), (String)null, comment);
    }

    public int countNullCell(String ref, String preRef) {
        String xfd = ref.replaceAll("\\d+", "");
        String xfd_1 = preRef.replaceAll("\\d+", "");
        xfd = this.fillChar(xfd, 3, '@', true);
        xfd_1 = this.fillChar(xfd_1, 3, '@', true);
        char[] letter = xfd.toCharArray();
        char[] letter_1 = xfd_1.toCharArray();
        int res = (letter[0] - letter_1[0]) * 26 * 26 + (letter[1] - letter_1[1]) * 26 + (letter[2] - letter_1[2]);
        return res - 1;
    }

    public String fillChar(String str, int len, char let, boolean isPre) {
        block4: {
            int len_1 = str.length();
            if (len_1 >= len) break block4;
            if (isPre) {
                for (int i = 0; i < len - len_1; ++i) {
                    str = let + str;
                }
            } else {
                for (int i = 0; i < len - len_1; ++i) {
                    str = str + let;
                }
            }
        }
        return str;
    }
}

