/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.quartz;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.reportfrom.wapp.entity.ReportInvoice;
import com.reportfrom.wapp.entity.ReportInvoiceDetail;
import com.reportfrom.wapp.mapper.first.JvChcInvoiceSyncMapper;
import com.reportfrom.wapp.mapper.first.ReportInvoiceDetailMapper;
import com.reportfrom.wapp.mapper.first.ReportInvoiceMapper;
import com.reportfrom.wapp.quartz.JvChcInvoiceSyncQuartz;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class JvChcInvoiceSyncQuartz {
    private static final Logger log = LoggerFactory.getLogger(JvChcInvoiceSyncQuartz.class);
    @Autowired
    private JvChcInvoiceSyncMapper jvChcInvoiceSyncMapper;
    @Autowired
    private ReportInvoiceMapper reportInvoiceMapper;
    @Autowired
    private ReportInvoiceDetailMapper reportInvoiceDetailMapper;
    @Value(value="${quartz.jv.chc.invoiceSyncQuartz.pageSize}")
    private int pageSize;
    @Value(value="${quartz.jv.chc.invoiceSyncQuartz.taxNoGroup}")
    private String taxNoGroup;
    private static JSONObject taxNoGroupJson = null;
    private static final Pattern IC_SELLLER_STORE_NO_REGEX = Pattern.compile("[0-9]{2,}[ -]{0,}\u95e8?\u5e97");
    private static final Pattern MUM_PRE_REGEX = Pattern.compile("[0-9]+");
    private static final Pattern MTR_SELLER_jv_REGEX = Pattern.compile("\u53d1\u51fa\u65b9[0-9;\uff1b:\uff1a]{2,}[A-Z]{1,}");
    private static final Pattern MTR_PURCHASER_jv_REGEX = Pattern.compile("\u8d2d\u5165\u65b9[0-9;\uff1b:\uff1a]{2,}[A-Z]{1,}");
    private static final Pattern LETTER_REGEX = Pattern.compile("[A-Z]{1,}");

    public static void main(String[] args) {
        String remark = "MTR#270120002120012/\u53d1\u51fa\u65b9\uff1a0120\uff1bAK/\u8d2d\u5165\u65b9\uff1a117\uff1bXE\u8ba2\u5355\u53f7\u3010120-117-202202-270120002120012-12\u3011   \u8ba2\u5355\u53f7[]";
        System.out.println("\u8ba2\u5355\u53f7\uff1a" + JvChcInvoiceSyncQuartz.getMTRSettlementNo((String)remark));
        System.out.println("\u9500\u65b9\u5e97\u53f7\uff1a" + JvChcInvoiceSyncQuartz.getMTRSellerStoreNo((String)remark));
        System.out.println("\u9500\u65b9JV\uff1a" + JvChcInvoiceSyncQuartz.getMTRSellerJv((String)remark));
        System.out.println("\u8d2d\u65b9\u5e97\u53f7\uff1a" + JvChcInvoiceSyncQuartz.getMTRPurchaserStoreNo((String)remark));
        System.out.println("\u8d2d\u65b9JV\uff1a" + JvChcInvoiceSyncQuartz.getMTRPurchaserJv((String)remark, (String)"AABBCCDD"));
    }

    @Scheduled(cron="${quartz.jv.chc.invoiceSyncQuartz.cron}")
    public void invoiceSync() {
        List invoiceList;
        log.info("\u540c\u6b65 t_dx_record_invoice \u5230 report_invoice \u5f00\u59cb");
        LocalDateTime endTime = LocalDateTime.now().minusMinutes(2L);
        String startTimeStr = this.jvChcInvoiceSyncMapper.getMaxSyncTime();
        LocalDateTime startTime = null;
        if (!StringUtils.isEmpty((String)startTimeStr)) {
            if (startTimeStr.length() > 23) {
                startTimeStr = startTimeStr.substring(0, 23);
            } else if (startTimeStr.length() < 23) {
                String[] startTimeStrs = startTimeStr.split("\\.");
                if (startTimeStrs[1].length() == 0) {
                    startTimeStrs[1] = "000";
                } else if (startTimeStrs[1].length() == 1) {
                    startTimeStrs[1] = "00" + startTimeStrs[1];
                } else if (startTimeStrs[1].length() == 2) {
                    startTimeStrs[1] = "0" + startTimeStrs[1];
                }
                startTimeStr = startTimeStrs[0] + "." + startTimeStrs[1];
            }
            startTime = LocalDateTime.parse(startTimeStr, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
            if (startTime != null && endTime.compareTo(startTime) <= 0) {
                log.warn("\u5f00\u59cb\u65f6\u95f4\u4e0e\u7ed3\u675f\u65f6\u95f4\u5f02\u5e38\uff0c\u540c\u6b65\u63a5\u6536");
                return;
            }
        }
        1 dateParams = new /* Unavailable Anonymous Inner Class!! */;
        dateParams.put("startDate", startTimeStr);
        int currPage = 0;
        do {
            log.info("\u540c\u6b65 t_dx_record_invoice \u5230 report_invoice \u7b2c {} \u9875\u5f00\u59cb", (Object)(++currPage));
            dateParams.put("currPage", currPage);
            invoiceList = this.jvChcInvoiceSyncMapper.queryInvoiceForPage((Map)dateParams);
            if (invoiceList == null || invoiceList.size() <= 0) continue;
            log.info("\u540c\u6b65 t_dx_record_invoice \u5230 report_invoice \u7b2c {} \u9875\uff0c\u5171 {} \u6761\u8bb0\u5f55", (Object)currPage, (Object)invoiceList.size());
            this.saveBatch(invoiceList);
        } while (invoiceList != null && invoiceList.size() >= this.pageSize);
        log.info("\u540c\u6b65 t_dx_record_invoice \u5230 report_invoice \u7ed3\u675f");
        this.jvChcInvoiceSyncMapper.insertSyncLog((Map)dateParams);
    }

    private void saveBatch(List<ReportInvoice> invoiceList) {
        if (invoiceList != null && invoiceList.size() > 0) {
            for (ReportInvoice t : invoiceList) {
                try {
                    if (StringUtils.isEmpty((String)t.getRemark())) continue;
                    String remark = t.getRemark().toUpperCase();
                    if (remark.indexOf("IC-") != -1) {
                        t.setCategory1("IC");
                        t.setSellerStoreNo(JvChcInvoiceSyncQuartz.getICSellerStoreNo((String)remark));
                        t.setJvcode(this.getICPurchaserJv(t.getGfTaxNo(), t.getJvcode()));
                    } else {
                        if (remark.indexOf("MTR#") == -1) continue;
                        String settlementNo = JvChcInvoiceSyncQuartz.getMTRSettlementNo((String)remark);
                        t.setCategory1("MTR");
                        t.setSettlementNo(settlementNo);
                        t.setSellerStoreNo(JvChcInvoiceSyncQuartz.getMTRSellerStoreNo((String)remark));
                        t.setSellerJv(JvChcInvoiceSyncQuartz.getMTRSellerJv((String)remark));
                        t.setPurchaserStoreNo(JvChcInvoiceSyncQuartz.getMTRPurchaserStoreNo((String)remark));
                        t.setJvcode(JvChcInvoiceSyncQuartz.getMTRPurchaserJv((String)remark, (String)t.getJvcode()));
                    }
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"invoice_code", (Object)t.getInvoiceCode());
                    queryWrapper.eq((Object)"invoice_no", (Object)t.getInvoiceNo());
                    if (this.reportInvoiceMapper.selectCount((Wrapper)queryWrapper) > 0) {
                        this.reportInvoiceMapper.update((Object)t, (Wrapper)queryWrapper);
                        continue;
                    }
                    this.reportInvoiceMapper.insert((Object)t);
                    List detailList = this.jvChcInvoiceSyncMapper.queryInvoiceDetail(t);
                    if (detailList == null || detailList.size() <= 0) continue;
                    for (ReportInvoiceDetail detail : detailList) {
                        if (detail.getGoodsName().indexOf("\u9500\u8d27\u6e05\u5355") != -1 || detail.getGoodsName().indexOf("\u539f\u4ef7\u5408\u8ba1") != -1 || detail.getGoodsName().indexOf("\u6298\u6263\u989d\u5408\u8ba1") != -1) continue;
                        detail.setTaxRate(JvChcInvoiceSyncQuartz.getTaxRate((String)detail.getTaxRate()));
                        this.reportInvoiceDetailMapper.insert((Object)detail);
                    }
                }
                catch (Exception e) {
                    log.error("\u63d2\u5165report_invoice\u5f02\u5e38\uff0c\u53d1\u7968\u4ee3\u7801\uff1a{}\u3001\u53f7\u7801\uff1a{}: {}", new Object[]{t.getInvoiceCode(), t.getInvoiceNo(), e.getMessage()});
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String getICPurchaserJv(String taxNo, String jv) {
        if (taxNoGroupJson == null) {
            Class<JvChcInvoiceSyncQuartz> clazz = JvChcInvoiceSyncQuartz.class;
            // MONITORENTER : com.reportfrom.wapp.quartz.JvChcInvoiceSyncQuartz.class
            if (taxNoGroupJson == null) {
                taxNoGroupJson = (JSONObject)JSON.parse((String)this.taxNoGroup);
            }
            // MONITOREXIT : clazz
        }
        if (taxNoGroupJson == null) return jv;
        if (!taxNoGroupJson.containsKey((Object)taxNo)) return jv;
        return taxNoGroupJson.getString(taxNo);
    }

    private static String getTaxRate(String taxRateStr) {
        if (StringUtils.isEmpty((String)taxRateStr)) {
            return "";
        }
        if (!StringUtils.isNumber((String)taxRateStr)) {
            return taxRateStr;
        }
        double taxRate = Double.parseDouble(taxRateStr);
        if (taxRate >= 1.0) {
            taxRate /= 100.0;
        }
        return String.valueOf(taxRate);
    }

    private static String getICSellerStoreNo(String remark) {
        if (remark.indexOf("\u5e97") != -1) {
            Matcher matcher = IC_SELLLER_STORE_NO_REGEX.matcher(remark);
            if (matcher.find()) {
                String temp = matcher.group();
                int end = temp.indexOf("\u95e8\u5e97");
                if (end == -1) {
                    end = temp.indexOf("\u5e97");
                }
                if ((matcher = MUM_PRE_REGEX.matcher(temp = temp.substring(0, end))).find()) {
                    return matcher.group();
                }
            }
            return "";
        }
        int start = remark.indexOf("IC-");
        Matcher matcher = MUM_PRE_REGEX.matcher(remark.substring(start + 3));
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    private static String getMTRSettlementNo(String remark) {
        int end;
        int start;
        if (remark.indexOf("[") != -1 && remark.indexOf("]") != -1) {
            start = remark.indexOf("[");
            end = remark.indexOf("]");
            if (start != -1 && end != -1 && end > start + 1) {
                return remark.substring(start + 1, end);
            }
        }
        if (remark.indexOf("\u3010") != -1 && remark.indexOf("\u3011") != -1) {
            start = remark.indexOf("\u3010");
            end = remark.indexOf("\u3011");
            if (start != -1 && end != -1 && end > start + 1) {
                return remark.substring(start + 1, end);
            }
        } else {
            if (remark.indexOf("\u5355\u53f7\u4e3a:") != -1 || remark.indexOf("\u5355\u53f7\u4e3a\uff1a") != -1) {
                start = remark.indexOf("\u5355\u53f7\u4e3a");
                end = remark.indexOf(" ", start + 4);
                if (end == -1) {
                    end = remark.length();
                }
                return remark.substring(start + 4, end);
            }
            if (remark.indexOf("\u5355\u4e3a:") != -1 || remark.indexOf("\u5355\u4e3a\uff1a") != -1) {
                start = remark.indexOf("\u5355\u4e3a");
                end = remark.indexOf(" ", start + 3);
                if (end == -1) {
                    end = remark.length();
                }
                return remark.substring(start + 3, end);
            }
        }
        return "";
    }

    private static String getMTRSellerStoreNo(String remark) {
        int end;
        int start;
        if (remark.indexOf("\u53d1\u51fa\u65b9") != -1) {
            start = remark.indexOf("\u53d1\u51fa\u65b9");
            end = remark.indexOf(";", start);
            if (end == -1) {
                end = remark.indexOf("\uff1b", start);
            }
            if (end != -1) {
                int s = 4;
                String temp = remark.substring(start, end);
                if (temp.indexOf(":") == -1 && temp.indexOf("\uff1a") == -1) {
                    s = 3;
                }
                if (start != -1 && end != -1 && end > start + s) {
                    return remark.substring(start + s, end).replace(" ", "");
                }
            } else {
                String temp = remark.substring(start + 3);
                Matcher matcher = MUM_PRE_REGEX.matcher(temp);
                if (matcher.find()) {
                    return matcher.group();
                }
            }
        }
        if (remark.indexOf("\u672c\u5730\u8ba2\u5355") != -1) {
            start = remark.indexOf("\u4ece");
            end = remark.indexOf("\u5e97", start);
            if (start != -1 && end != -1 && end > start + 1) {
                return remark.substring(start + 1, end);
            }
        }
        return "";
    }

    private static String getMTRPurchaserStoreNo(String remark) {
        int end;
        int start;
        if (remark.indexOf("\u8d2d\u5165\u65b9") != -1) {
            start = remark.indexOf("\u8d2d\u5165\u65b9");
            end = remark.indexOf(";", start);
            if (end == -1) {
                end = remark.indexOf("\uff1b", start);
            }
            if (end != -1) {
                int s = 4;
                String temp = remark.substring(start, end);
                if (temp.indexOf(":") == -1 && temp.indexOf("\uff1a") == -1) {
                    s = 3;
                }
                if (start != -1 && end != -1 && end > start + s) {
                    return remark.substring(start + s, end).replace(" ", "");
                }
            } else {
                String temp = remark.substring(start + 3);
                Matcher matcher = MUM_PRE_REGEX.matcher(temp);
                if (matcher.find()) {
                    return matcher.group();
                }
            }
        }
        if (remark.indexOf("\u672c\u5730\u8ba2\u5355") != -1) {
            start = remark.indexOf("\u5230");
            end = remark.indexOf("\u5e97", start);
            if (start != -1 && end != -1 && end > start + 1) {
                return remark.substring(start + 1, end);
            }
        }
        return "";
    }

    private static String getMTRSellerJv(String remark) {
        String temp;
        Matcher matcher;
        if (remark.indexOf("\u53d1\u51fa\u65b9") != -1 && (matcher = MTR_SELLER_jv_REGEX.matcher(remark)).find() && (matcher = LETTER_REGEX.matcher(temp = matcher.group())).find()) {
            return matcher.group();
        }
        return "";
    }

    private static String getMTRPurchaserJv(String remark, String jv) {
        String temp;
        Matcher matcher;
        if (remark.indexOf("\u8d2d\u5165\u65b9") != -1 && (matcher = MTR_PURCHASER_jv_REGEX.matcher(remark)).find() && (matcher = LETTER_REGEX.matcher(temp = matcher.group())).find()) {
            return matcher.group();
        }
        return jv;
    }

    static /* synthetic */ int access$000(JvChcInvoiceSyncQuartz x0) {
        return x0.pageSize;
    }
}

