/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entityEnum.AllType;
import com.reportfrom.wapp.entityVO.ReportMTRJvInterInvoiceVO;
import com.reportfrom.wapp.mapper.first.ReportMTRJvInterInvoiceMapper;
import com.reportfrom.wapp.request.ReportMTRJvInterInvoiceRequest;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.ReportMTRJvInterInvoiceService;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ReportMTRJvInterInvoiceServiceImpl
implements ReportMTRJvInterInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(ReportMTRJvInterInvoiceServiceImpl.class);
    @Autowired
    private ReportMTRJvInterInvoiceMapper reportMTRJvInterInvoiceMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    private void queryCondition(Map map, ReportMTRJvInterInvoiceRequest params) {
        if (!StringUtils.isEmpty((String)params.getInvoiceDate())) {
            String[] invoiceDateStrs = params.getInvoiceDate().split(",");
            map.put("startInvoiceDate", LocalDate.parse(invoiceDateStrs[0], DateTimeFormatter.ofPattern("yyyyMMdd")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 00:00:00");
            map.put("endInvoiceDate", LocalDate.parse(invoiceDateStrs[1], DateTimeFormatter.ofPattern("yyyyMMdd")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 23:59:59");
        }
        if (!StringUtils.isEmpty((String)params.getAuthDate())) {
            String[] authDateStrs = params.getAuthDate().split(",");
            map.put("startAuthDate", LocalDate.parse(authDateStrs[0], DateTimeFormatter.ofPattern("yyyyMMdd")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 00:00:00");
            map.put("endAuthDate", LocalDate.parse(authDateStrs[1], DateTimeFormatter.ofPattern("yyyyMMdd")).format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 23:59:59");
        }
        if (!StringUtils.isEmpty((String)params.getRemark())) {
            map.put("remark", "%" + this.handleName(params.getRemark().toUpperCase()) + "%");
        }
        if (!StringUtils.isEmpty((String)params.getExt1())) {
            map.put("ext1", "%" + this.handleName(params.getExt1()) + "%");
        }
        if (!StringUtils.isEmpty((String)params.getTaxCode())) {
            if ("P0".equals(params.getTaxCode())) {
                map.put("taxRate", "0.0");
            } else if ("S5".equals(params.getTaxCode())) {
                map.put("taxRate", "0.09");
            } else if ("S6".equals(params.getTaxCode())) {
                map.put("taxRate", "0.13");
            } else {
                map.put("taxRate", "AAA");
            }
        }
    }

    public PageUtils queryPage(ReportMTRJvInterInvoiceRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        this.queryCondition(map, params);
        Integer count = this.reportMTRJvInterInvoiceMapper.selectAllCountByParam(map);
        List list = null;
        if (count != null && count > 0) {
            list = this.reportMTRJvInterInvoiceMapper.selectMapsByParams(map);
            this.dealMTRJvInterInvoice(list, false);
        } else {
            list = new ArrayList(0);
        }
        PageUtils rpage = new PageUtils();
        rpage.setList(list);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void produce(ReportMTRJvInterInvoiceRequest params, String token) {
        String fileName = "MTR JV-JV\u5185\u90e8\u53d1\u7968\u62a5\u8868_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")) + ".xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        this.queryCondition(map, params);
        List list = this.reportMTRJvInterInvoiceMapper.selectMapsByParams(map);
        this.dealMTRJvInterInvoice(list, true);
        String path = this.ftpConfig.getServerSavePath() + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + "/";
        ExcelUtils.createExcel((List)list, (String)ExcelTypeConfig.REPORT_MTR_JV_INTER_INVOICE_QUERY, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("token", token);
        parmMap.put("condition", condition);
        parmMap.put("path", path);
        parmMap.put("fileName", fileName);
        String s = JSON.toJSONString(parmMap);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public void dealMTRJvInterInvoice(List<ReportMTRJvInterInvoiceVO> list, boolean flag) {
        if (list != null && list.size() > 0) {
            list.forEach(t -> {
                if (flag) {
                    t.setInvoiceType(AllType.InvoiceTypesEnum.getMsgByCode((String)t.getInvoiceType()));
                    t.setQsStatus(ReportMTRJvInterInvoiceServiceImpl.getQsStatusName((String)t.getQsStatus()));
                    t.setAuthStatus(AllType.AuthStatusEnum.getMsgByCode((String)t.getAuthStatus()));
                    t.setInvoiceStatus(ReportMTRJvInterInvoiceServiceImpl.getInvoiceStatusName((String)t.getInvoiceStatus()));
                }
                if (!StringUtils.isEmpty((String)t.getTaxRate())) {
                    t.setTaxCode(ReportMTRJvInterInvoiceServiceImpl.getTaxCode((String)t.getTaxRate()));
                }
            });
        }
    }

    private static String getInvoiceStatusName(String invoiceStatus) {
        if (!StringUtils.isEmpty((String)invoiceStatus)) {
            if (invoiceStatus.indexOf("0") != -1) {
                return "\u6b63\u5e38";
            }
            if (invoiceStatus.indexOf("1") != -1) {
                return "\u5931\u63a7";
            }
            if (invoiceStatus.indexOf("2") != -1) {
                return "\u4f5c\u5e9f";
            }
            if (invoiceStatus.indexOf("3") != -1) {
                return "\u7ea2\u51b2";
            }
            if (invoiceStatus.indexOf("4") != -1) {
                return "\u5f02\u5e38";
            }
            if (invoiceStatus.indexOf("5") != -1) {
                return "\u84dd\u51b2";
            }
        }
        return "";
    }

    private static String getQsStatusName(String qsStatus) {
        if (!StringUtils.isEmpty((String)qsStatus)) {
            if (qsStatus.indexOf("0") != -1) {
                return "\u672a\u7b7e\u6536";
            }
            if (qsStatus.indexOf("1") != -1) {
                return "\u5df2\u7b7e\u6536";
            }
        }
        return "";
    }

    private static String getTaxCode(String taxRate) {
        if (!StringUtils.isEmpty((String)taxRate)) {
            if (Double.parseDouble(taxRate) == 0.0) {
                return "P0";
            }
            if (taxRate.indexOf("9") != -1) {
                return "S5";
            }
            if (taxRate.indexOf("13") != -1) {
                return "S6";
            }
        }
        return "";
    }

    private String handleName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return null;
        }
        return name.replace("_", "[_]").replace("%", "[%]").replace("[", "[[]").replace("^", "[^]");
    }
}

