/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entity.TXfSellerInvoice;
import com.reportfrom.wapp.entity.TXfSellerInvoiceItem;
import com.reportfrom.wapp.entityVO.SellerInvoiceItemVO;
import com.reportfrom.wapp.entityVO.TXfSellerInvoiceVO;
import com.reportfrom.wapp.mapper.second.TXfSellerInvoiceMapper;
import com.reportfrom.wapp.request.SellerInvoiceRequest;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.TXfSellerInvoiceService;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
@DS(value="second")
public class TXfSellerInvoiceServiceImpl
extends ServiceImpl<TXfSellerInvoiceMapper, TXfSellerInvoice>
implements TXfSellerInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(TXfSellerInvoiceServiceImpl.class);
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private TXfSellerInvoiceMapper tXfSellerInvoiceMapper;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public PageUtils querySuccessInvoicee(SellerInvoiceRequest params) {
        if (StringUtils.isNotEmpty((String)params.getRemark())) {
            String remark = params.getRemark();
            String replace = remark.replace("[", "[[]");
            params.setRemark(replace);
        }
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        if (StringUtils.isNotEmpty((String)params.getPaperDrewDate())) {
            List<String> strings = Arrays.asList(params.getPaperDrewDate().split(","));
            map.put("startTime", strings.get(0));
            map.put("endTime", strings.get(1));
        }
        List tXfSellerInvoices = this.tXfSellerInvoiceMapper.querySuccessInvoicee(map);
        Set collect = tXfSellerInvoices.stream().map(TXfSellerInvoiceVO::getId).collect(Collectors.toSet());
        collect.removeIf(o -> o == null);
        List detailsList = this.tXfSellerInvoiceMapper.getDetailsByMainId(collect);
        Map<String, List<TXfSellerInvoiceItem>> detailsById = detailsList.stream().collect(Collectors.groupingBy(TXfSellerInvoiceItem::getInvoiceId));
        for (TXfSellerInvoiceVO vo : tXfSellerInvoices) {
            List<TXfSellerInvoiceItem> tXfSellerInvoiceItems;
            String paperDrewDate = vo.getPaperDrewDate();
            if (StringUtils.isNotEmpty((String)paperDrewDate)) {
                String substring = paperDrewDate.substring(0, 6);
                vo.setRelevancyPeriod(substring);
            }
            if (CollectionUtils.isEmpty(tXfSellerInvoiceItems = detailsById.get(String.valueOf(vo.getId())))) continue;
            vo.setCargoName(tXfSellerInvoiceItems.get(0).getCargoName());
        }
        Integer count = this.tXfSellerInvoiceMapper.querySuccessInvoiceCount(map);
        PageUtils page = new PageUtils();
        page.setList(tXfSellerInvoices);
        page.setCurrPage(params.getCurrPage().intValue());
        page.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        page.setTotalPage(totalpage);
        page.setTotalCount(count.intValue());
        return page;
    }

    public void exportSuccessInvoice(SellerInvoiceRequest params, String token) {
        if (StringUtils.isNotEmpty((String)params.getRemark())) {
            String remark = params.getRemark();
            String replace = remark.replace("[", "[[]");
            params.setRemark(replace);
        }
        String fileName = "chc\u84dd\u7968\u6e05\u5355.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        if (StringUtils.isNotEmpty((String)params.getPaperDrewDate())) {
            List<String> strings = Arrays.asList(params.getPaperDrewDate().split(","));
            map.put("startTime", strings.get(0));
            map.put("endTime", strings.get(1));
        }
        List tXfSellerInvoices = this.tXfSellerInvoiceMapper.querySuccessInvoicee(map);
        Set collect = tXfSellerInvoices.stream().map(TXfSellerInvoiceVO::getId).collect(Collectors.toSet());
        collect.removeIf(o -> o == null);
        List detailsList = this.tXfSellerInvoiceMapper.getDetailsByMainId(collect);
        Map<String, List<TXfSellerInvoiceItem>> detailsById = detailsList.stream().collect(Collectors.groupingBy(TXfSellerInvoiceItem::getInvoiceId));
        for (TXfSellerInvoiceVO vo : tXfSellerInvoices) {
            List<TXfSellerInvoiceItem> tXfSellerInvoiceItems;
            String paperDrewDate = vo.getPaperDrewDate();
            if (StringUtils.isNotEmpty((String)paperDrewDate)) {
                String substring = paperDrewDate.substring(0, 6);
                vo.setRelevancyPeriod(substring);
            }
            if (CollectionUtils.isEmpty(tXfSellerInvoiceItems = detailsById.get(String.valueOf(vo.getId())))) continue;
            vo.setCargoName(tXfSellerInvoiceItems.get(0).getCargoName());
        }
        log.info("\u5bfc\u51fa\u6570\u636e\u5171{}\u6761>>>>>", (Object)tXfSellerInvoices.size());
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)tXfSellerInvoices, (String)ExcelTypeConfig.CHC_SELLER_INVOICE, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        log.info("\u3010{}\u3011\u6587\u4ef6\u5bfc\u51fa\u8bb0\u5f55\u5f00\u59cb\u540c\u6b65\u5c0f\u94c3\u94db>>>>>", (Object)fileName);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils querySuccessRedInvoicee(SellerInvoiceRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        map.put("isRed", true);
        if (StringUtils.isNotEmpty((String)params.getPaperDrewDate())) {
            List<String> strings = Arrays.asList(params.getPaperDrewDate().split(","));
            map.put("startTime", strings.get(0));
            map.put("endTime", strings.get(1));
        }
        List tXfSellerInvoices = this.tXfSellerInvoiceMapper.querySuccessInvoicee(map);
        Set collect = tXfSellerInvoices.stream().map(TXfSellerInvoiceVO::getId).collect(Collectors.toSet());
        collect.removeIf(o -> o == null);
        Map<String, List<TXfSellerInvoiceItem>> detailsById = null;
        if (!CollectionUtils.isEmpty(collect)) {
            List detailsList = this.tXfSellerInvoiceMapper.getDetailsByMainId(collect);
            detailsById = detailsList.stream().collect(Collectors.groupingBy(TXfSellerInvoiceItem::getInvoiceId));
        }
        for (TXfSellerInvoiceVO vo : tXfSellerInvoices) {
            List<TXfSellerInvoiceItem> tXfSellerInvoiceItems;
            String paperDrewDate = vo.getPaperDrewDate();
            if (StringUtils.isNotEmpty((String)paperDrewDate)) {
                String substring = paperDrewDate.substring(0, 6);
                vo.setRelevancyPeriod(substring);
            }
            if (CollectionUtils.isEmpty(detailsById) || CollectionUtils.isEmpty(tXfSellerInvoiceItems = detailsById.get(String.valueOf(vo.getId())))) continue;
            vo.setCargoName(tXfSellerInvoiceItems.get(0).getCargoName());
        }
        Integer count = this.tXfSellerInvoiceMapper.querySuccessInvoiceCount(map);
        PageUtils page = new PageUtils();
        page.setList(tXfSellerInvoices);
        page.setCurrPage(params.getCurrPage().intValue());
        page.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        page.setTotalPage(totalpage);
        page.setTotalCount(count.intValue());
        return new PageUtils(tXfSellerInvoices);
    }

    public void exportSuccessRedInvoice(SellerInvoiceRequest params, String token) {
        String fileName = "chc\u7ea2\u7968\u6e05\u5355.xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("isRed", true);
        if (StringUtils.isNotEmpty((String)params.getPaperDrewDate())) {
            List<String> strings = Arrays.asList(params.getPaperDrewDate().split(","));
            map.put("startTime", strings.get(0));
            map.put("endTime", strings.get(1));
        }
        List tXfSellerInvoices = this.tXfSellerInvoiceMapper.querySuccessInvoicee(map);
        Set collect = tXfSellerInvoices.stream().map(TXfSellerInvoiceVO::getId).collect(Collectors.toSet());
        collect.removeIf(o -> o == null);
        Map<String, List<TXfSellerInvoiceItem>> detailsById = null;
        if (!CollectionUtils.isEmpty(collect)) {
            List detailsList = this.tXfSellerInvoiceMapper.getDetailsByMainId(collect);
            detailsById = detailsList.stream().collect(Collectors.groupingBy(TXfSellerInvoiceItem::getInvoiceId));
        }
        for (TXfSellerInvoiceVO vo : tXfSellerInvoices) {
            List<TXfSellerInvoiceItem> tXfSellerInvoiceItems;
            String paperDrewDate = vo.getPaperDrewDate();
            if (StringUtils.isNotEmpty((String)paperDrewDate)) {
                String substring = paperDrewDate.substring(0, 6);
                vo.setRelevancyPeriod(substring);
            }
            if (CollectionUtils.isEmpty(tXfSellerInvoiceItems = detailsById.get(String.valueOf(vo.getId())))) continue;
            vo.setCargoName(tXfSellerInvoiceItems.get(0).getCargoName());
        }
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)tXfSellerInvoices, (String)ExcelTypeConfig.CHC_SELLER_RED_INVOICE, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    public PageUtils queryInvoiceItemMsg(SellerInvoiceRequest params) {
        if (StringUtils.isNotEmpty((String)params.getRemark())) {
            String remark = params.getRemark();
            String replace = remark.replace("[", "[[]");
            params.setRemark(replace);
        }
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        List list = this.tXfSellerInvoiceMapper.selectMapsByParams(map);
        Integer count = this.tXfSellerInvoiceMapper.selectCountByParams(map);
        for (SellerInvoiceItemVO vo : list) {
            String paperDrewDate = vo.getPaperDrewDate();
            String substring = paperDrewDate.substring(0, 6);
            vo.setRelevancyPeriod(substring);
        }
        PageUtils page = new PageUtils();
        page.setList(list);
        page.setCurrPage(params.getCurrPage().intValue());
        page.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        page.setTotalPage(totalpage);
        page.setTotalCount(count.intValue());
        return page;
    }

    public void exportExcelByTime(SellerInvoiceRequest params, String token) {
        String fileName = "\u52a0\u8ba1\u6263\u9664.xlsx";
        if (StringUtils.isNotEmpty((String)params.getRemark())) {
            String remark = params.getRemark();
            String replace = remark.replace("[", "[[]");
            params.setRemark(replace);
        }
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        List invoiceParams = this.tXfSellerInvoiceMapper.selectMapsByParams(map);
        for (SellerInvoiceItemVO vo : invoiceParams) {
            String paperDrewDate = vo.getPaperDrewDate();
            String substring = paperDrewDate.substring(0, 6);
            vo.setRelevancyPeriod(substring);
        }
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)invoiceParams, (String)ExcelTypeConfig.RECORD_INVOICE, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }
}

