/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.quartz;

import com.reportfrom.wapp.service.ReportAggrementEpdStatisticService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ReportAggrementEpdStatisticQuartz {
    private static final Logger log = LoggerFactory.getLogger(ReportAggrementEpdStatisticQuartz.class);
    @Autowired
    private ReportAggrementEpdStatisticService reportAggrementEpdStatisticService;
    private final int DIFF_MONTH = -12;

    @Scheduled(cron="${quartz.AggrementStatisticQuartz.cron}")
    public void updateTask() {
        String yesterday = LocalDate.now().minusDays(1L).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        List postDateList = this.reportAggrementEpdStatisticService.getCalcPostDate(yesterday);
        if (postDateList == null || postDateList.size() == 0) {
            log.info("{} \u6ca1\u6709\u7ea2\u5b57\u4fe1\u606f\u8868\u7684\u8fc7\u8d26\u65e5\u671f", (Object)yesterday);
            return;
        }
        for (String lastMonth : postDateList) {
            log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 : {} \u8ba1\u7b97\u5f00\u59cb", (Object)lastMonth);
            this.updateAggrementEpdStatistic(lastMonth + "%");
            log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 : {} \u8ba1\u7b97\u7ed3\u675f", (Object)lastMonth);
        }
    }

    public void updateAggrementEpdStatistic(String lastMonth) {
        Long startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u91cd\u7f6e\u8ba1\u7b97\u4e3a\u7a7a \u5f00\u59cb");
        int updateLen = this.reportAggrementEpdStatisticService.updateNull(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u91cd\u7f6e\u8ba1\u7b97\u4e3a\u7a7a \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        this.updateZm(lastMonth);
        this.updateTotal(lastMonth);
    }

    public void updateZm(String lastMonth) {
        Long startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u4f9b\u5e94\u5546\u540d\u79f0\uff0c\u662f\u5426\u7ea2\u7968\u9879\u76ee\u7ec4 \u5f00\u59cb");
        int updateLen = this.reportAggrementEpdStatisticService.updateBillDeduct(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u4f9b\u5e94\u5546\u540d\u79f0\uff0c\u662f\u5426\u7ea2\u7968\u9879\u76ee\u7ec4 \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7ea2\u7968-AR \uff0c \u7a0e\u5dee\u8c03\u6574 \uff0c \u5f00\u5177\u65e5\u671f \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateAggrementRedTaxAmount(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7ea2\u7968-AR \uff0c \u7a0e\u5dee\u8c03\u6574 \uff0c \u5f00\u5177\u65e5\u671f \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7ea2\u7968\u9879\u76ee \uff0c \u7a0e\u5dee\u8c03\u6574 \uff0c \u5f00\u5177\u65e5\u671f \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateEpdRedTaxAmount(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7ea2\u7968\u9879\u76ee \uff0c \u7a0e\u5dee\u8c03\u6574 \uff0c \u5f00\u5177\u65e5\u671f \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7b2c\u4e00\u6b21\u64a4\u9500 \u7a0e\u989d\u3001\u65e5\u671f \uff0c \u5f00\u5177\u65e5\u671f \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateFirstReverse(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7b2c\u4e00\u6b21\u64a4\u9500 \u7a0e\u989d\u3001\u65e5\u671f \uff0c \u5f00\u5177\u65e5\u671f \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7b2c\u4e00\u6b21\u91cd\u5f00 \u7a0e\u989d\u3001\u7a0e\u5dee\u3001\u65e5\u671f \uff0c \u5f00\u5177\u65e5\u671f \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateFirstReopen(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7b2c\u4e00\u6b21\u91cd\u5f00 \u7a0e\u989d\u3001\u7a0e\u5dee\u3001\u65e5\u671f \uff0c \u5f00\u5177\u65e5\u671f \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7b2c\u4e8c\u6b21\u64a4\u9500 \u7a0e\u989d\u3001\u65e5\u671f \uff0c \u5f00\u5177\u65e5\u671f \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateSecondReverse(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7b2c\u4e8c\u6b21\u64a4\u9500 \u7a0e\u989d\u3001\u65e5\u671f \uff0c \u5f00\u5177\u65e5\u671f \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7b2c\u4e8c\u6b21\u91cd\u5f00 \u7a0e\u989d\u3001\u7a0e\u5dee\u3001\u65e5\u671f \uff0c \u5f00\u5177\u65e5\u671f \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateSecondReopen(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7b2c\u4e8c\u6b21\u91cd\u5f00 \u7a0e\u989d\u3001\u7a0e\u5dee\u3001\u65e5\u671f \uff0c \u5f00\u5177\u65e5\u671f \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7b2c\u4e09\u6b21\u64a4\u9500 \u7a0e\u989d\u3001\u65e5\u671f \uff0c \u5f00\u5177\u65e5\u671f \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateThirdReverse(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7b2c\u4e09\u6b21\u64a4\u9500 \u7a0e\u989d\u3001\u65e5\u671f \uff0c \u5f00\u5177\u65e5\u671f \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7b2c\u4e09\u6b21\u91cd\u5f00 \u7a0e\u989d\u3001\u7a0e\u5dee\u3001\u65e5\u671f \uff0c \u5f00\u5177\u65e5\u671f \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateThirdReopen(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u7b2c\u4e09\u6b21\u91cd\u5f00 \u7a0e\u989d\u3001\u7a0e\u5dee\u3001\u65e5\u671f \uff0c \u5f00\u5177\u65e5\u671f \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5df2\u7ed3\u6b3e\u672a\u5f00\u7968\u7a0e\u91d1 \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateUnInvoiceAmount(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5df2\u7ed3\u6b3e\u672a\u5f00\u7968\u7a0e\u91d1 \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5df2\u84dd\u51b2\u7a0e\u91d1 \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateBlueOffsetAmount(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5df2\u84dd\u51b2\u7a0e\u91d1 \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
    }

    public void updateTotal(String lastMonth) {
        Long startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u4f59\u989d \u5f00\u59cb");
        int updateLen = this.reportAggrementEpdStatisticService.updateBalance(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u4f59\u989d \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
        startTime = System.currentTimeMillis();
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5dee\u5f02 \u5f00\u59cb");
        updateLen = this.reportAggrementEpdStatisticService.updateDifferenceAmount(lastMonth);
        log.info("\u534f\u8bae\u7a0e\u52a1\u62a5\u8868 \u66f4\u65b0 \u5dee\u5f02 \u7ed3\u675f\uff0c\u5171\u66f4\u65b0{}\u6761\u8bb0\u5f55\u3002\u7528\u65f6\uff1a{}", (Object)updateLen, (Object)(System.currentTimeMillis() - startTime));
    }
}

