/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entity.TXfBillDeduct;
import com.reportfrom.wapp.entityEnum.ProtocolQueryEnum;
import com.reportfrom.wapp.entityVO.ClaimantVO;
import com.reportfrom.wapp.entityVO.ProtocolQueryExceptionVO;
import com.reportfrom.wapp.entityVO.ProtocolQueryRedNotifiVO;
import com.reportfrom.wapp.entityVO.RedNotificationLogVO;
import com.reportfrom.wapp.entityVO.TDxRecordInvoiceVO;
import com.reportfrom.wapp.mapper.first.TXfBillDeductItemMapper;
import com.reportfrom.wapp.mapper.first.TXfBillDeductMapper;
import com.reportfrom.wapp.mapper.first.TXfExceptionReportMapper;
import com.reportfrom.wapp.mapper.first.TXfRedNotificationMapper;
import com.reportfrom.wapp.request.ClaimantQueryReq;
import com.reportfrom.wapp.request.ProtocolQueryReq;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.TXfBillDeductService;
import com.reportfrom.wapp.util.DateUtils;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import io.micrometer.core.instrument.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TXfBillDeductServiceImpl
extends ServiceImpl<TXfBillDeductMapper, TXfBillDeduct>
implements TXfBillDeductService {
    private static final Logger log = LoggerFactory.getLogger(TXfBillDeductServiceImpl.class);
    @Autowired
    private TXfBillDeductMapper tXfBillDeductMapper;
    @Autowired
    private TXfRedNotificationMapper tXfRedNotificationMapper;
    @Autowired
    private TXfBillDeductItemMapper tXfBillDeductItemMapper;
    @Autowired
    private TXfExceptionReportMapper tXfExceptionReportMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public PageUtils queryPageByParamsType1(ClaimantQueryReq params) {
        Map map = this.returnQueryMapType1(params, Boolean.valueOf(true));
        List list = this.returnType1(params, map);
        int count = this.tXfBillDeductMapper.selectCountByParamsType1(map);
        PageUtils rpage = new PageUtils();
        rpage.setList(list);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count);
        return rpage;
    }

    public void exportByParamsType1(ClaimantQueryReq params, String token) {
        String fileName = "\u7d22\u8d54\u7efc\u5408\u67e5\u8be2\u62a5\u8868.xlsx";
        Map map = this.returnQueryMapType1(params, Boolean.valueOf(false));
        List list = this.returnType1(params, map);
        Set idSet = list.stream().filter(Objects::nonNull).map(ClaimantVO::getId).collect(Collectors.toSet());
        List detailsVo = this.tXfBillDeductItemMapper.selectDetailsByIds(idSet);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel((List)list, (List)detailsVo, (String)ExcelTypeConfig.CLAIMANT_QUERY, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    private Map returnQueryMapType1(ClaimantQueryReq params, Boolean isPage) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        if (isPage.booleanValue()) {
            map.put("tureOrfalse", true);
        }
        if (StringUtils.isNotEmpty((String)params.getDeductDate())) {
            List<String> strings = Arrays.asList(params.getDeductDate().split(","));
            map.put("startDeductDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(0), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            map.put("endDeductDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(1), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
        }
        return map;
    }

    private List<ClaimantVO> returnType1(ClaimantQueryReq params, Map map) {
        List list = this.tXfBillDeductMapper.selectByParamsType1(map);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return list;
        }
        Set billeIdSet = list.stream().map(ClaimantVO::getId).collect(Collectors.toSet());
        billeIdSet.removeIf(o -> o == null);
        Map<Object, Object> aboutSettlement = new HashMap();
        Map<Object, Object> aboutRedNotifi = new HashMap();
        if (!CollectionUtils.isEmpty(billeIdSet)) {
            List settlementCountByIdList = this.tXfBillDeductMapper.selectSettlementCountByIds(billeIdSet);
            aboutSettlement = settlementCountByIdList.stream().collect(Collectors.groupingBy(ClaimantVO::getId));
            List DeductRedNotificationByIdList = this.tXfBillDeductMapper.selectDeductRedNotification(billeIdSet);
            aboutRedNotifi = DeductRedNotificationByIdList.stream().collect(Collectors.groupingBy(ClaimantVO::getId));
        }
        for (ClaimantVO vo : list) {
            List aboutRedNotifiClaimantVOS;
            List aboutSettlementClaimantVOS = (List)aboutSettlement.get(vo.getId());
            if (!CollectionUtils.isEmpty((Collection)aboutSettlementClaimantVOS)) {
                vo.setSettlementCount(new BigDecimal(aboutSettlementClaimantVOS.size()));
                Set collect = aboutSettlementClaimantVOS.stream().map(o -> o.getSettlementNo()).collect(Collectors.toSet());
                String settlementNos = String.join((CharSequence)",", collect);
                vo.setSettlementNoSet(settlementNos);
            }
            if (!CollectionUtils.isEmpty((Collection)(aboutRedNotifiClaimantVOS = (List)aboutRedNotifi.get(vo.getId()))) && aboutRedNotifiClaimantVOS.size() > 0) {
                ClaimantVO vo1 = (ClaimantVO)aboutRedNotifiClaimantVOS.get(0);
                vo.setRedNotifiCount(vo1.getRedNotifiCount());
                vo.setSumRedNotifiAmountWithoutTax(vo1.getSumRedNotifiAmountWithoutTax());
                vo.setSumRedNotifiTaxAmount(vo1.getSumRedNotifiTaxAmount());
                vo.setNoneRedNotifiAmountWithoutTax(vo.getAmountWithoutTax().subtract(vo1.getSumRedNotifiAmountWithoutTax()));
                vo.setNoneRedNotifiTaxAmount(vo.getTaxAmount().subtract(vo1.getSumRedNotifiTaxAmount()));
                continue;
            }
            if (vo.getSumAmountWithoutTax() != null) {
                vo.setNoneRedNotifiAmountWithoutTax(vo.getSumAmountWithoutTax().subtract(BigDecimal.ZERO));
            }
            if (vo.getSumTaxAmount() == null) continue;
            vo.setNoneRedNotifiTaxAmount(vo.getSumTaxAmount().subtract(BigDecimal.ZERO));
        }
        return list;
    }

    public PageUtils queryPageByParamsType2(ProtocolQueryReq params) {
        Map map = this.returnQueryMapType2(params, Boolean.valueOf(true));
        List volist = this.tXfBillDeductMapper.selectByParamsType2(map);
        Integer count = this.tXfBillDeductMapper.selectCountByParamsType2(map);
        PageUtils rpage = new PageUtils();
        rpage.setList(volist);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    public void exportByParamsType2(ProtocolQueryReq params, String token) {
        String fileName = "\u534f\u8bae\u7efc\u5408\u67e5\u8be2\u62a5\u8868.xlsx";
        Map map = this.returnQueryMapType2(params, Boolean.valueOf(false));
        List volist = this.tXfBillDeductMapper.selectByParamsType2(map);
        Set idSet = volist.stream().map(o -> o.getId()).collect(Collectors.toSet());
        List protocolQueryRedNotifiVOS = this.protocolQueryRedNotifi(idSet);
        List protocolQueryExceptionVOS = this.protocolQueryException(idSet);
        ProtocolQueryEnum protocolQueryEnum = new ProtocolQueryEnum();
        protocolQueryEnum.setProtocolQueryVOs(volist);
        protocolQueryEnum.setProtocolQueryExceptionVOs(protocolQueryExceptionVOS);
        protocolQueryEnum.setProtocolQueryRedNotifiVOs(protocolQueryRedNotifiVOS);
        String path = this.ftpConfig.getServerSavePath();
        ArrayList<ProtocolQueryEnum> modelList = new ArrayList<ProtocolQueryEnum>();
        modelList.add(protocolQueryEnum);
        ExcelUtils.createExcel(modelList, (String)ExcelTypeConfig.PROTOCOL_QUERY, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }

    private Map returnQueryMapType2(ProtocolQueryReq params, Boolean isPage) {
        List<String> strings;
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        if (isPage.booleanValue()) {
            map.put("tureOrfalse", true);
        }
        if (StringUtils.isNotEmpty((String)params.getDeductDate())) {
            strings = Arrays.asList(params.getDeductDate().split(","));
            map.put("startDeductDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(0), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            map.put("endDeductDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(1), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isNotEmpty((String)params.getCreateTime())) {
            strings = Arrays.asList(params.getCreateTime().split(","));
            map.put("startCreateTime", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(0), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            map.put("endCreateTime", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(1), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
        }
        if (StringUtils.isNotEmpty((String)params.getVerdictDate())) {
            strings = Arrays.asList(params.getVerdictDate().split(","));
            map.put("startVerdictDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(0), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
            map.put("endVerdictDate", DateUtils.format((Date)DateUtils.stringToDate((String)strings.get(1), (String)"yyyyMMdd"), (String)"yyyy-MM-dd"));
        }
        return map;
    }

    public List<ProtocolQueryRedNotifiVO> protocolQueryRedNotifi(ProtocolQueryReq params) {
        HashSet<Long> ids = new HashSet<Long>();
        ids.add(params.getId());
        return this.protocolQueryRedNotifi(ids);
    }

    public List<ProtocolQueryRedNotifiVO> protocolQueryRedNotifi(Set<String> ids) {
        List tDxRecordInvoiceVOS;
        Map<Object, Object> redNotifiTimeByettlementNo = new HashMap();
        Map<Object, Object> redInvoiceByRedNotifiNo = new HashMap();
        List tXfExceptionReports = this.tXfRedNotificationMapper.selectSettlementAndRedNotifiByBillId(ids);
        Set idSet = tXfExceptionReports.stream().map(o -> o.getRedNotifiId()).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(idSet)) {
            List logVOS = this.tXfBillDeductMapper.selectLogByRedNotificationId(idSet);
            redNotifiTimeByettlementNo = logVOS.stream().collect(Collectors.groupingBy(o -> o.getRedNotifiId() + "-" + o.getApplyType()));
        }
        Set allRedNotificationSet = tXfExceptionReports.stream().map(ProtocolQueryRedNotifiVO::getRedNotificationNo).collect(Collectors.toSet());
        allRedNotificationSet.removeIf(o -> StringUtils.isEmpty((String)o));
        if (!CollectionUtils.isEmpty(allRedNotificationSet) && !CollectionUtils.isEmpty((Collection)(tDxRecordInvoiceVOS = this.tXfBillDeductMapper.selectAllRecordInvoiceByRedNotificationNo(allRedNotificationSet)))) {
            redInvoiceByRedNotifiNo = tDxRecordInvoiceVOS.stream().collect(Collectors.groupingBy(TDxRecordInvoiceVO::getRedNoticeNumber));
        }
        for (ProtocolQueryRedNotifiVO vo : tXfExceptionReports) {
            List tDxRecordInvoiceVOSBySettlement;
            List cxTimeList;
            List sqTimeList = (List)redNotifiTimeByettlementNo.get(vo.getRedNotifiId() + "-1");
            if (!CollectionUtils.isEmpty((Collection)sqTimeList)) {
                String usedate = ((RedNotificationLogVO)sqTimeList.get(0)).getUsedate();
                vo.setRedNotificationApplyDate(usedate);
            }
            if ("4".equals(vo.getApproveStatus()) && !CollectionUtils.isEmpty((Collection)(cxTimeList = (List)redNotifiTimeByettlementNo.get(vo.getRedNotifiId() + "-3")))) {
                String usedate = ((RedNotificationLogVO)cxTimeList.get(0)).getUsedate();
                vo.setRedNotificationApproveDate(usedate);
            }
            if (!CollectionUtils.isEmpty((Collection)(tDxRecordInvoiceVOSBySettlement = (List)redInvoiceByRedNotifiNo.get(vo.getRedNotificationNo())))) {
                Set invoiceStatusSet = tDxRecordInvoiceVOSBySettlement.stream().filter(Objects::nonNull).map(TDxRecordInvoiceVO::getInvoiceStatus).collect(Collectors.toSet());
                Set auditStatus = tDxRecordInvoiceVOSBySettlement.stream().filter(Objects::nonNull).map(TDxRecordInvoiceVO::getAuditStatus).collect(Collectors.toSet());
                Set invoiceDateSet = tDxRecordInvoiceVOSBySettlement.stream().filter(Objects::nonNull).map(TDxRecordInvoiceVO::getInvoiceDate).collect(Collectors.toSet());
                vo.setRedInvoiceDate(String.join((CharSequence)",", invoiceDateSet.stream().map(String::valueOf).collect(Collectors.toList())));
                auditStatus.removeIf(o -> StringUtils.isEmpty((String)o));
                vo.setAuditStatus(String.join((CharSequence)",", auditStatus.stream().map(String::valueOf).collect(Collectors.toList())));
                if (invoiceStatusSet.contains("5")) {
                    vo.setRedInvoiceStatus("5");
                    Set blueInvoiceNoList = tDxRecordInvoiceVOSBySettlement.stream().filter(Objects::nonNull).map(TDxRecordInvoiceVO::getBlueInvoiceNo).collect(Collectors.toSet());
                    Set blueInvoiceCodeList = tDxRecordInvoiceVOSBySettlement.stream().filter(Objects::nonNull).map(TDxRecordInvoiceVO::getBlueInvoiceCode).collect(Collectors.toSet());
                    if (!CollectionUtils.isEmpty(blueInvoiceNoList)) {
                        vo.setBlueInvoiceNo(String.join((CharSequence)",", blueInvoiceNoList.stream().map(String::valueOf).collect(Collectors.toList())));
                        vo.setBlueInvoiceCode(String.join((CharSequence)",", blueInvoiceCodeList.stream().map(String::valueOf).collect(Collectors.toList())));
                        vo.setBlueInvoiceDate(String.join((CharSequence)",", invoiceDateSet.stream().map(String::valueOf).collect(Collectors.toList())));
                    }
                } else {
                    vo.setRedInvoiceStatus("0");
                }
            }
            if ("3".equals(vo.getApproveStatus())) {
                vo.setRedNotificationStatus("6");
                continue;
            }
            if ("4".equals(vo.getApproveStatus())) {
                vo.setRedNotificationStatus("5");
                continue;
            }
            if ("5".equals(vo.getApproveStatus())) {
                vo.setRedNotificationStatus("4");
                continue;
            }
            if ("3".equals(vo.getApplyingStatus())) {
                vo.setRedNotificationStatus("3");
                continue;
            }
            if ("2".equals(vo.getApplyingStatus())) {
                vo.setRedNotificationStatus("2");
                continue;
            }
            if (!"1".equals(vo.getApplyingStatus())) continue;
            vo.setRedNotificationStatus("1");
        }
        return tXfExceptionReports;
    }

    public List<ProtocolQueryExceptionVO> protocolQueryException(ProtocolQueryReq params) {
        HashSet<Long> ids = new HashSet<Long>();
        ids.add(params.getId());
        return this.protocolQueryException(ids);
    }

    public List<ProtocolQueryExceptionVO> protocolQueryException(Set<String> ids) {
        List tXfExceptionReports = this.tXfExceptionReportMapper.selectExceptionByBillIds(ids);
        return tXfExceptionReports;
    }
}

