/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.mq;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.reportfrom.wapp.handler.IExportHandler;
import com.reportfrom.wapp.service.BaseReportExportService;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.stereotype.Component;

@Component
public class ExportRequestConsumer {
    private static final Logger log = LoggerFactory.getLogger(ExportRequestConsumer.class);
    final Map<String, IExportHandler> exportHandlers = new HashMap();
    @Value(value="${activemq.queue-name.export-request}")
    private String exportQueue;
    @Autowired
    private BaseReportExportService baseReportExportService;

    public ExportRequestConsumer(ApplicationContext applicationContext) {
        Map beanOfType = applicationContext.getBeansOfType(IExportHandler.class);
        beanOfType.forEach((k, v) -> this.exportHandlers.put(v.handlerName(), v));
    }

    @JmsListener(destination="${activemq.queue-name.export-request}")
    public void doListen(Message<String> message, TextMessage textMessage) {
        log.info("MQ_queueName={},\u76d1\u542c\u7ed3\u679c={}", (Object)this.exportQueue, (Object)JSON.toJSONString(message));
        MessageHeaders headers = message.getHeaders();
        String s = (String)headers.get((Object)"handlerName", String.class);
        String messageId = "";
        try {
            messageId = textMessage.getJMSMessageID();
        }
        catch (JMSException e) {
            log.error("\u83b7\u53d6\u6d88\u606fID\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isEmpty((String)s)) {
            log.info("\u5bfc\u51fa\u8bf7\u6c42:{},\u672a\u6307\u5b9a\u5bfc\u51fa\u5904\u7406\u5668\uff0cmessageId:{}", message.getPayload(), (Object)messageId);
        } else {
            IExportHandler iExportHandler = (IExportHandler)this.exportHandlers.get(s);
            if (iExportHandler != null) {
                iExportHandler.doExport(message, messageId);
            } else {
                log.info("\u5904\u7406\u5668\u540d\u79f0\uff1a[{}]\u672a\u5339\u914d\u5230\u76f8\u5e94\u5904\u7406\u5668", (Object)s);
            }
        }
    }

    @JmsListener(destination="Sql1ToSql2")
    public void doListenForSqlServer(Message<String> message, TextMessage textMessage) {
        log.info("MQ_queueName={},\u76d1\u542c\u7ed3\u679c={}", (Object)this.exportQueue, (Object)JSON.toJSONString(message));
        String payload = (String)message.getPayload();
        Map map = (Map)JSON.parseObject((String)payload, Map.class);
        this.baseReportExportService.exportExcel((String)map.get("token"), (String)map.get("condition"), (String)map.get("path"), (String)map.get("fileName"));
    }
}

