/*
 * Decompiled with CFR 0.152.
 */
package com.reportfrom.wapp.service.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.reportfrom.wapp.config.ExcelTypeConfig;
import com.reportfrom.wapp.config.FtpConfig;
import com.reportfrom.wapp.entityVO.ReportAgingStatisticVO;
import com.reportfrom.wapp.mapper.first.ReportAgingStatisticMapper;
import com.reportfrom.wapp.request.ReportAgingStatisticRequest;
import com.reportfrom.wapp.service.BaseReportExportService;
import com.reportfrom.wapp.service.ReportAgingStatisticService;
import com.reportfrom.wapp.util.ExcelUtils;
import com.reportfrom.wapp.util.PageUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReportAgingStatisticServiceImpl
implements ReportAgingStatisticService {
    private static final Logger log = LoggerFactory.getLogger(ReportAgingStatisticServiceImpl.class);
    @Autowired
    private ReportAgingStatisticMapper meportAgingStatisticMapper;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private BaseReportExportService baseReportExportService;

    private void queryCondition(Map<String, String> map, ReportAgingStatisticRequest params) {
        if (!StringUtils.isEmpty((String)params.getPeriod())) {
            String[] periods = params.getPeriod().split(",");
            map.put("startPeriod", periods[0]);
            map.put("endPeriod", periods[1]);
        }
    }

    public PageUtils queryPage(ReportAgingStatisticRequest params) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        map.put("tureOrfalse", true);
        this.queryCondition(map, params);
        Integer count = 0;
        List list = new ArrayList(0);
        if ("1".equals(params.getType())) {
            count = this.meportAgingStatisticMapper.selectClaimAllCountByParam(map);
            if (null != count && count > 0) {
                list = this.meportAgingStatisticMapper.selectClaimMapsByParams(map);
            }
        } else if ("2".equals(params.getType()) && null != (count = this.meportAgingStatisticMapper.selectAggrementAllCountByParam(map)) && count > 0) {
            list = this.meportAgingStatisticMapper.selectAggrementMapsByParams(map);
        }
        this.dealResult(params.getPeriod(), list);
        PageUtils rpage = new PageUtils();
        rpage.setList(list);
        rpage.setCurrPage(params.getCurrPage().intValue());
        rpage.setPageSize(params.getPageSize().intValue());
        int totalpage = (count + params.getPageSize() - 1) / params.getPageSize();
        rpage.setTotalPage(totalpage);
        rpage.setTotalCount(count.intValue());
        return rpage;
    }

    private void dealResult(String ym, List<ReportAgingStatisticVO> list) {
        if (list != null && list.size() > 0) {
            LocalDate lastymDate = LocalDate.parse(ym + "01", DateTimeFormatter.ofPattern("yyyyMMdd")).with(TemporalAdjusters.lastDayOfMonth());
            list.forEach(t -> {
                if (!StringUtils.isEmpty((String)t.getPostingDate())) {
                    String format = "yyyyMMdd";
                    if (!StringUtils.isNumber((String)t.getPostingDate())) {
                        format = "yyyy-MM-dd";
                    }
                    LocalDate postDate = LocalDate.parse(t.getPostingDate(), DateTimeFormatter.ofPattern(format));
                    int aging = Math.abs(postDate.compareTo(lastymDate));
                    t.setAging(String.valueOf(aging));
                    if (aging >= 0 && aging <= 30) {
                        t.setAging0To30(t.getUnsettledTaxAmount());
                    } else if (aging >= 31 && aging <= 60) {
                        t.setAging31To60(t.getUnsettledTaxAmount());
                    } else if (aging >= 61 && aging <= 90) {
                        t.setAging61To90(t.getUnsettledTaxAmount());
                    } else if (aging >= 91 && aging <= 120) {
                        t.setAging91To120(t.getUnsettledTaxAmount());
                    } else if (aging >= 121 && aging <= 180) {
                        t.setAging121To180(t.getUnsettledTaxAmount());
                    } else if (aging >= 181 && aging <= 360) {
                        t.setAging181To360(t.getUnsettledTaxAmount());
                    } else if (aging > 361) {
                        t.setAgingGt360(t.getUnsettledTaxAmount());
                    }
                }
            });
        }
    }

    public void produceReportAgingStatistic(ReportAgingStatisticRequest params, String token) {
        String fileName = "\u8d26\u9f84\u7edf\u8ba1\u62a5\u8868_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")) + ".xlsx";
        Map map = (Map)JSON.parseObject((String)JSON.toJSONString((Object)params), Map.class);
        this.queryCondition(map, params);
        List list = new ArrayList(0);
        if ("1".equals(params.getType())) {
            list = this.meportAgingStatisticMapper.selectClaimMapsByParams(map);
        } else if ("2".equals(params.getType())) {
            list = this.meportAgingStatisticMapper.selectAggrementMapsByParams(map);
        }
        this.dealResult(params.getPeriod(), list);
        String path = this.ftpConfig.getServerSavePath();
        ExcelUtils.createExcel(list, (String)ExcelTypeConfig.REPORT_AGING_STATISTIC_QUERY, (String)fileName, (String)path, (FtpConfig)this.ftpConfig);
        String condition = JSON.toJSONString((Object)params);
        HashMap<String, String> parmMap = new HashMap<String, String>();
        parmMap.put("token", token);
        parmMap.put("condition", condition);
        parmMap.put("path", path);
        parmMap.put("fileName", fileName);
        String s = JSON.toJSONString(parmMap);
        this.baseReportExportService.exportExcel(token, condition, path, fileName);
    }
}

